/* 
 * © 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_SPLITTER_H_
#define _WF_SPLITTER_H_

#include "wf_view.h"

using namespace System::Collections;

namespace MySQL
{
  namespace Forms
  {
    public ref class SplitterImpl : public ViewImpl
    {
    protected:
      SplitterImpl(::mforms::Splitter *self);

      static bool create(::mforms::Splitter *self, bool horizontal);
      static void add(::mforms::Splitter *self, ::mforms::View *view, int min_size);
	    static void remove(::mforms::Splitter *self, ::mforms::View *view);
	    static void set_position(::mforms::Splitter *self, int position);

    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::Splitter*, bool, mgr, f->_splitter_impl, SplitterImpl, create);
		    DEF_CALLBACK3(void, ::mforms::Splitter*, ::mforms::View*, int, mgr, f->_splitter_impl, SplitterImpl, add);
		    DEF_CALLBACK2(void, ::mforms::Splitter*, ::mforms::View*, mgr, f->_splitter_impl, SplitterImpl, remove);
		    DEF_CALLBACK2(void, ::mforms::Splitter*, int, mgr, f->_splitter_impl, SplitterImpl, set_position);
      }
    };
  };
};

#endif
