/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_TABVIEW_H_
#define _WF_TABVIEW_H_

#include "wf_view.h"

using namespace System::Collections;

namespace MySQL
{
  namespace Forms
  {
    public ref class TabViewImpl : public ViewImpl
    {
    private:
      bool _tabless;
      int _active_index;
      List<ViewImpl^> _pages; // Only used if the tab view is set to have no tabs.
    protected:
      TabViewImpl(::mforms::TabView *self, bool tabless);

      static bool create(::mforms::TabView *self, bool tabless);
      static void set_active_tab(::mforms::TabView *self, int index);
      static int get_active_tab(::mforms::TabView *self);
      static int add_page(::mforms::TabView *self, ::mforms::View *page, const std::string& caption);

      static void tab_changed(System::Object^ sender, TabControlEventArgs^ e);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::TabView*, bool, mgr, f->_tabview_impl, TabViewImpl, create);
        DEF_CALLBACK1(int, ::mforms::TabView*, mgr, f->_tabview_impl, TabViewImpl, get_active_tab);
        DEF_CALLBACK2(void, ::mforms::TabView*, int, mgr, f->_tabview_impl, TabViewImpl, set_active_tab);
        DEF_CALLBACK3(int, ::mforms::TabView*, ::mforms::View*, const std::string&, mgr, f->_tabview_impl, TabViewImpl, add_page);
      }
    };
  };
};

#endif
