/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRTPP_SHELL_PYTHON_H_
#define _GRTPP_SHELL_PYTHON_H_

#ifdef ENABLE_PYTHON_MODULES

#include "grtpp_shell.h"
#include "grtpp_module_python.h"

namespace grt
{  
  class MYSQLGRT_PUBLIC PythonShell : public Shell
  {
  public:
    PythonShell(GRT *grt);
    
    virtual void init();
    virtual void print_welcome();
    virtual std::string get_prompt();
    virtual int execute_line(const std::string &linebuf);
    virtual int run_file(const std::string &file_name, bool interactive);
    virtual void show_help(const std::string &topic);
    
    virtual std::vector<std::string> complete_line(const std::string &line, std::string &completed);
    
    virtual ValueRef get_global_var(const std::string &var_name);
    virtual int set_global_var(const std::string &var_name, const ValueRef &value);
        
  protected:
    std::vector<std::string> get_tokens_for_prefix(const std::string &prefix);
    
    std::string _current_line;

    PythonModuleLoader *_loader;
  };
  
};

#endif

#endif /* _GRTPP_SHELL_PYTHON_H_ */
