/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRTPP_SERIALIZER_H__
#define _GRTPP_SERIALIZER_H__

#include "grtpp.h"

#include <set>

namespace grt
{
  namespace internal
  {
    class Serializer
    {
    public:
      Serializer(GRT *grt);

      void save_to_xml(const ValueRef &value, const std::string &path, 
                       const std::string &doctype= "", const std::string &docversion= "");

      xmlDocPtr create_xmldoc_for_value(const ValueRef &value,
                                        const std::string &doctype, const std::string &docversion);

      std::string serialize_to_xmldata(const ValueRef &value,
                                       const std::string &type, const std::string &version);

    protected:
      GRT *_grt;
      std::set<void*> _cache;
      
      xmlNodePtr serialize_value(const ValueRef &value, xmlNodePtr parent, bool owned_objects);
      xmlNodePtr serialize_object(const Ref<Object> &object, xmlNodePtr parent);

      bool seen(const ValueRef &value);
       
      bool serialize_member(const MetaClass::Member *member, const ObjectRef &object, xmlNodePtr node);
    };
  };
};

#endif
