#include "stdafx.h"

#include "grt_test_utility.h"
#include "testgrt.h"
#include "grtdiff.h"
#include "grtpp.h"
#include "diffchange.h"
#include "grtdb/diff_dbobjectmatch.h"

using namespace grt;

BEGIN_TEST_DATA_CLASS(grtlistdiff_test)
public:
  GRT grt;
END_TEST_DATA_CLASS

TEST_MODULE(grtlistdiff_test, "grtlistdiff_test");

void list_from_container(const double* values, const double* limit, DoubleListRef& target)
{
  for (; values != limit; values++)
    target.insert(*values);
}

void list_from_container(const int* values, const int* limit, IntegerListRef& target)
{
  for (; values != limit; values++)
    target.insert(*values);
}

TEST_FUNCTION(2)
{
  const int s[]= {0, 1, 2};
  const int t[]= {0, 1};

  IntegerListRef source(&grt);
  IntegerListRef target(&grt);

  list_from_container(s, s + UPPER_BOUND(s), source);
  list_from_container(t, t + UPPER_BOUND(t), target);

  DiffChange* change= diff_make(source, target, NULL,  grt::NormalizedComparer<grt::GRT*>(&grt));
  change->apply(source);

  assure_grt_values_equal(source, target);
}

TEST_FUNCTION(1)
{
  const int s[]= {0, 1};
  const int t[]= {0, 1, 2};

  IntegerListRef source(&grt);
  IntegerListRef target(&grt);

  list_from_container(s, s + UPPER_BOUND(s), source);
  list_from_container(t, t + UPPER_BOUND(t), target);

  DiffChange* change= diff_make(source, target, NULL,  grt::NormalizedComparer<grt::GRT*>(&grt));
  change->apply(source);

  assure_grt_values_equal(source, target);
}

TEST_FUNCTION(3)
{
  const int s[]= {0, 1, 2, 3};
  const int t[]= {5, 1, 6, 3, 2};

  IntegerListRef source(&grt);
  IntegerListRef target(&grt);

  list_from_container(s, s + UPPER_BOUND(s), source);
  list_from_container(t, t + UPPER_BOUND(t), target);

  DiffChange* change= diff_make(source, target, NULL,  grt::NormalizedComparer<grt::GRT*>(&grt));
  change->apply(source);

  assure_grt_values_equal(source, target);
}

TEST_FUNCTION(4)
{
  const int s[]= {10, 10, 11, 0, 1, 2, 3};
  const int t[]= {2, 5, 1, 6, 6, 6, 3, 2};

  IntegerListRef source(&grt);
  IntegerListRef target(&grt);

  list_from_container(s, s + UPPER_BOUND(s), source);
  list_from_container(t, t + UPPER_BOUND(t), target);

  DiffChange* change= diff_make(source, target, NULL,  grt::NormalizedComparer<grt::GRT*>(&grt));
  change->apply(source);

  assure_grt_values_equal(source, target);
}

TEST_FUNCTION(5)
{
  const double s[]= {.0, 1., .2, .3};
  const double t[]= {5., .1, .6, .3, .2};

  DoubleListRef source(&grt);
  DoubleListRef target(&grt);

  list_from_container(s, s + UPPER_BOUND(s), source);
  list_from_container(t, t + UPPER_BOUND(t), target);

  DiffChange* change= diff_make(source, target, NULL,  grt::NormalizedComparer<grt::GRT*>(&grt));
  change->apply(source);

  assure_grt_values_equal(source, target);
}

END_TESTS
