/* Copyright (C) 2000-2003 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* sql_yacc.yy */

%{
typedef void* YYSTYPE;
#define YYSTYPE_IS_DECLARED

#include <stdio.h>
#include "myx_sql_tree_item.h"
#include "myx_lex_helpers.h"
using mysql_parser::yyerror;
using mysql_parser::yylex;
%}

%pure_parser                                    /* We have threads */
/*
  Currently there are 177 shift/reduce conflicts.
  We should not introduce new conflicts any more.
*/
%expect 167

/*
   Comments for TOKENS.
   For each token, please include in the same line a comment that contains
   the following tags:
   SQL-2003-R : Reserved keyword as per SQL-2003
   SQL-2003-N : Non Reserved keyword as per SQL-2003
   SQL-1999-R : Reserved keyword as per SQL-1999
   SQL-1999-N : Non Reserved keyword as per SQL-1999
   MYSQL      : MySQL extention (unspecified)
   MYSQL-FUNC : MySQL extention, function
   INTERNAL   : Not a real token, lex optimization
   OPERATOR   : SQL operator
   FUTURE-USE : Reserved for futur use

   This makes the code grep-able, and helps maintenance.
*/

%token  ABORT_SYM                     /* INTERNAL (used in lex) */
%token  ACCESSIBLE_SYM
%token  ACTION                        /* SQL-2003-N */
%token  ADD                           /* SQL-2003-R */
%token  ADDDATE_SYM                   /* MYSQL-FUNC */
%token  AFTER_SYM                     /* SQL-2003-N */
%token  AGAINST
%token  AGGREGATE_SYM
%token  ALGORITHM_SYM
%token  ALL                           /* SQL-2003-R */
%token  ALTER                         /* SQL-2003-R */
%token  ANALYZE_SYM
%token  AND_AND_SYM                   /* OPERATOR */
%token  AND_SYM                       /* SQL-2003-R */
%token  ANY_SYM                       /* SQL-2003-R */
%token  AS                            /* SQL-2003-R */
%token  ASC                           /* SQL-2003-N */
%token  ASCII_SYM                     /* MYSQL-FUNC */
%token  ASENSITIVE_SYM                /* FUTURE-USE */
%token  AT_SYM                        /* SQL-2003-R */
%token  AUTHORS_SYM
%token  AUTOEXTEND_SIZE_SYM
%token  AUTO_INC
%token  AVG_ROW_LENGTH
%token  AVG_SYM                       /* SQL-2003-N */
%token  BACKUP_SYM
%token  BEFORE_SYM                    /* SQL-2003-N */
%token  BEGIN_SYM                     /* SQL-2003-R */
%token  BETWEEN_SYM                   /* SQL-2003-R */
%token  BIGINT                        /* SQL-2003-R */
%token  BINARY                        /* SQL-2003-R */
%token  BINLOG_SYM
%token  BIN_NUM
%token  BIT_AND                       /* MYSQL-FUNC */
%token  BIT_OR                        /* MYSQL-FUNC */
%token  BIT_SYM                       /* MYSQL-FUNC */
%token  BIT_XOR                       /* MYSQL-FUNC */
%token  BLOB_SYM                      /* SQL-2003-R */
%token  BOOLEAN_SYM                   /* SQL-2003-R */
%token  BOOL_SYM
%token  BOTH                          /* SQL-2003-R */
%token  BTREE_SYM
%token  BY                            /* SQL-2003-R */
%token  BYTE_SYM
%token  CACHE_SYM
%token  CALL_SYM                      /* SQL-2003-R */
%token  CASCADE                       /* SQL-2003-N */
%token  CASCADED                      /* SQL-2003-R */
%token  CASE_SYM                      /* SQL-2003-R */
%token  CAST_SYM                      /* SQL-2003-R */
%token  CHAIN_SYM                     /* SQL-2003-N */
%token  CHANGE
%token  CHANGED
%token  CHARSET
%token  CHAR_SYM                      /* SQL-2003-R */
%token  CHECKSUM_SYM
%token  CHECK_SYM                     /* SQL-2003-R */
%token  CIPHER_SYM
%token  CLIENT_SYM
%token  CLOSE_SYM                     /* SQL-2003-R */
%token  COALESCE                      /* SQL-2003-N */
%token  CODE_SYM
%token  COLLATE_SYM                   /* SQL-2003-R */
%token  COLLATION_SYM                 /* SQL-2003-N */
%token  COLUMNS
%token  COLUMN_SYM                    /* SQL-2003-R */
%token  COMMENT_SYM
%token  COMMITTED_SYM                 /* SQL-2003-N */
%token  COMMIT_SYM                    /* SQL-2003-R */
%token  COMPACT_SYM
%token  COMPLETION_SYM
%token  COMPRESSED_SYM
%token  CONCURRENT
%token  CONDITION_SYM                 /* SQL-2003-N */
%token  CONNECTION_SYM
%token  CONSISTENT_SYM
%token  CONSTRAINT                    /* SQL-2003-R */
%token  CONTAINS_SYM                  /* SQL-2003-N */
%token  CONTINUE_SYM                  /* SQL-2003-R */
%token  CONTRIBUTORS_SYM
%token  CONVERT_SYM                   /* SQL-2003-N */
%token  COUNT_SYM                     /* SQL-2003-N */
%token  CREATE                        /* SQL-2003-R */
%token  CROSS                         /* SQL-2003-R */
%token  CUBE_SYM                      /* SQL-2003-R */
%token  CURDATE                       /* MYSQL-FUNC */
%token  CURRENT_USER                  /* SQL-2003-R */
%token  CURSOR_SYM                    /* SQL-2003-R */
%token  CURTIME                       /* MYSQL-FUNC */
%token  DATABASE
%token  DATABASES
%token  DATAFILE_SYM
%token  DATA_SYM                      /* SQL-2003-N */
%token  DATETIME
%token  DATE_ADD_INTERVAL             /* MYSQL-FUNC */
%token  DATE_SUB_INTERVAL             /* MYSQL-FUNC */
%token  DATE_SYM                      /* SQL-2003-R */
%token  DAY_HOUR_SYM
%token  DAY_MICROSECOND_SYM
%token  DAY_MINUTE_SYM
%token  DAY_SECOND_SYM
%token  DAY_SYM                       /* SQL-2003-R */
%token  DEALLOCATE_SYM                /* SQL-2003-R */
%token  DECIMAL_NUM
%token  DECIMAL_SYM                   /* SQL-2003-R */
%token  DECLARE_SYM                   /* SQL-2003-R */
%token  DEFAULT                       /* SQL-2003-R */
%token  DEFINER_SYM
%token  DELAYED_SYM
%token  DELAY_KEY_WRITE_SYM
%token  DELETE_SYM                    /* SQL-2003-R */
%token  DESC                          /* SQL-2003-N */
%token  DESCRIBE                      /* SQL-2003-R */
%token  DES_KEY_FILE
%token  DETERMINISTIC_SYM             /* SQL-2003-R */
%token  DIRECTORY_SYM
%token  DISABLE_SYM
%token  DISCARD
%token  DISK_SYM
%token  DISTINCT                      /* SQL-2003-R */
%token  DIV_SYM
%token  DOUBLE_SYM                    /* SQL-2003-R */
%token  DO_SYM
%token  DROP                          /* SQL-2003-R */
%token  DUAL_SYM
%token  DUMPFILE
%token  DUPLICATE_SYM
%token  DYNAMIC_SYM                   /* SQL-2003-R */
%token  EACH_SYM                      /* SQL-2003-R */
%token  EDIT_SYM
%token  ELSE                          /* SQL-2003-R */
%token  ELSEIF_SYM
%token  ENABLE_SYM
%token  ENCLOSED
%token  END                           /* SQL-2003-R */
%token  ENDS_SYM
%token  END_OF_INPUT                  /* INTERNAL */
%token  ENGINES_SYM
%token  ENGINE_SYM
%token  ENUM
%token  EQ                            /* OPERATOR */
%token  EQUAL_SYM                     /* OPERATOR */
%token  ERRORS
%token  ESCAPED
%token  ESCAPE_SYM                    /* SQL-2003-R */
%token  EVENTS_SYM
%token  EVENT_SYM
%token  EVERY_SYM                     /* SQL-2003-N */
%token  EXECUTE_SYM                   /* SQL-2003-R */
%token  EXISTS                        /* SQL-2003-R */
%token  EXIT_SYM
%token  EXPANSION_SYM
%token  EXTENDED_SYM
%token  EXTENT_SIZE_SYM
%token  EXTRACT_SYM                   /* SQL-2003-N */
%token  FALSE_SYM                     /* SQL-2003-R */
%token  FAST_SYM
%token  FETCH_SYM                     /* SQL-2003-R */
%token  FILE_SYM
%token  FIRST_SYM                     /* SQL-2003-N */
%token  FIXED_SYM
%token  FLOAT_NUM
%token  FLOAT_SYM                     /* SQL-2003-R */
%token  FLUSH_SYM
%token  FORCE_SYM
%token  FOREIGN                       /* SQL-2003-R */
%token  FOR_SYM                       /* SQL-2003-R */
%token  FOUND_SYM                     /* SQL-2003-R */
%token  FRAC_SECOND_SYM
%token  FROM
%token  FULL                          /* SQL-2003-R */
%token  FULLTEXT_SYM
%token  FUNCTION_SYM                  /* SQL-2003-R */
%token  GE
%token  GEOMETRYCOLLECTION
%token  GEOMETRY_SYM
%token  GET_FORMAT                    /* MYSQL-FUNC */
%token  GLOBAL_SYM                    /* SQL-2003-R */
%token  GRANT                         /* SQL-2003-R */
%token  GRANTS
%token  GROUP_SYM                     /* SQL-2003-R */
%token  GROUP_CONCAT_SYM
%token  GT_SYM                        /* OPERATOR */
%token  HANDLER_SYM
%token  HASH_SYM
%token  HAVING                        /* SQL-2003-R */
%token  HELP_SYM
%token  HEX_NUM
%token  HIGH_PRIORITY
%token  HOST_SYM
%token  HOSTS_SYM
%token  HOUR_MICROSECOND_SYM
%token  HOUR_MINUTE_SYM
%token  HOUR_SECOND_SYM
%token  HOUR_SYM                      /* SQL-2003-R */
%token  IDENT
%token  IDENTIFIED_SYM
%token  IDENT_QUOTED
%token  IF
%token  IGNORE_SYM
%token  IMPORT
%token  INDEXES
%token  INDEX_SYM
%token  INFILE
%token  INITIAL_SIZE_SYM
%token  INNER_SYM                     /* SQL-2003-R */
%token  INNOBASE_SYM
%token  INOUT_SYM                     /* SQL-2003-R */
%token  INSENSITIVE_SYM               /* SQL-2003-R */
%token  INSERT                        /* SQL-2003-R */
%token  INSERT_METHOD
%token  INSTALL_SYM
%token  INTERVAL_SYM                  /* SQL-2003-R */
%token  INTO                          /* SQL-2003-R */
%token  INT_SYM                       /* SQL-2003-R */
%token  INVOKER_SYM
%token  IN_SYM                        /* SQL-2003-R */
%token  IS                            /* SQL-2003-R */
%token  ISOLATION                     /* SQL-2003-R */
%token  ISSUER_SYM
%token  ITERATE_SYM
%token  JOIN_SYM                      /* SQL-2003-R */
%token  KEYS
%token  KEY_BLOCK_SIZE
%token  KEY_SYM                       /* SQL-2003-N */
%token  KILL_SYM
%token  LANGUAGE_SYM                  /* SQL-2003-R */
%token  LAST_SYM                      /* SQL-2003-N */
%token  LE                            /* OPERATOR */
%token  LEADING                       /* SQL-2003-R */
%token  LEAVES
%token  LEAVE_SYM
%token  LEFT                          /* SQL-2003-R */
%token  LESS_SYM
%token  LEVEL_SYM
%token  LEX_HOSTNAME
%token  LIKE                          /* SQL-2003-R */
%token  LIMIT
%token  LINEAR_SYM
%token  LINES
%token  LINESTRING
%token  LIST_SYM
%token  LOAD
%token  LOCAL_SYM                     /* SQL-2003-R */
%token  LOCATOR_SYM                   /* SQL-2003-N */
%token  LOCKS_SYM
%token  LOCK_SYM
%token  LOGFILE_SYM
%token  LOGS_SYM
%token  LONGBLOB
%token  LONGTEXT
%token  LONG_NUM
%token  LONG_SYM
%token  LOOP_SYM
%token  LOW_PRIORITY
%token  LT                            /* OPERATOR */
%token  MASTER_CONNECT_RETRY_SYM
%token  MASTER_HOST_SYM
%token  MASTER_LOG_FILE_SYM
%token  MASTER_LOG_POS_SYM
%token  MASTER_PASSWORD_SYM
%token  MASTER_PORT_SYM
%token  MASTER_SERVER_ID_SYM
%token  MASTER_SSL_CAPATH_SYM
%token  MASTER_SSL_CA_SYM
%token  MASTER_SSL_CERT_SYM
%token  MASTER_SSL_CIPHER_SYM
%token  MASTER_SSL_KEY_SYM
%token  MASTER_SSL_SYM
%token  MASTER_SSL_VERIFY_SERVER_CERT_SYM
%token  MASTER_SYM
%token  MASTER_USER_SYM
%token  MATCH                         /* SQL-2003-R */
%token  MAX_CONNECTIONS_PER_HOUR
%token  MAX_QUERIES_PER_HOUR
%token  MAX_ROWS
%token  MAX_SIZE_SYM
%token  MAX_SYM                       /* SQL-2003-N */
%token  MAX_UPDATES_PER_HOUR
%token  MAX_USER_CONNECTIONS_SYM
%token  MAX_VALUE_SYM                 /* SQL-2003-N */
%token  MEDIUMBLOB
%token  MEDIUMINT
%token  MEDIUMTEXT
%token  MEDIUM_SYM
%token  MEMORY_SYM
%token  MERGE_SYM                     /* SQL-2003-R */
%token  MICROSECOND_SYM               /* MYSQL-FUNC */
%token  MIGRATE_SYM
%token  MINUTE_MICROSECOND_SYM
%token  MINUTE_SECOND_SYM
%token  MINUTE_SYM                    /* SQL-2003-R */
%token  MIN_ROWS
%token  MIN_SYM                       /* SQL-2003-N */
%token  MODE_SYM
%token  MODIFIES_SYM                  /* SQL-2003-R */
%token  MODIFY_SYM
%token  MOD_SYM                       /* SQL-2003-N */
%token  MONTH_SYM                     /* SQL-2003-R */
%token  MULTILINESTRING
%token  MULTIPOINT
%token  MULTIPOLYGON
%token  MUTEX_SYM
%token  NAMES_SYM                     /* SQL-2003-N */
%token  NAME_SYM                      /* SQL-2003-N */
%token  NATIONAL_SYM                  /* SQL-2003-R */
%token  NATURAL                       /* SQL-2003-R */
%token  NCHAR_STRING
%token  NCHAR_SYM                     /* SQL-2003-R */
%token  NDBCLUSTER_SYM
%token  NE                            /* OPERATOR */
%token  NEG
%token  NEW_SYM                       /* SQL-2003-R */
%token  NEXT_SYM                      /* SQL-2003-N */
%token  NODEGROUP_SYM
%token  NONE_SYM                      /* SQL-2003-R */
%token  NOT2_SYM
%token  NOT_SYM                       /* SQL-2003-R */
%token  NOW_SYM
%token  NO_SYM                        /* SQL-2003-R */
%token  NO_WAIT_SYM
%token  NO_WRITE_TO_BINLOG
%token  NULL_SYM                      /* SQL-2003-R */
%token  NUM
%token  NUMERIC_SYM                   /* SQL-2003-R */
%token  NVARCHAR_SYM
%token  OFFSET_SYM
%token  OLD_PASSWORD
%token  ON                            /* SQL-2003-R */
%token  ONE_SHOT_SYM
%token  ONE_SYM
%token  OPEN_SYM                      /* SQL-2003-R */
%token  OPTIMIZE
%token  OPTIONS_SYM
%token  OPTION                        /* SQL-2003-N */
%token  OPTIONALLY
%token  OR2_SYM
%token  ORDER_SYM                     /* SQL-2003-R */
%token  OR_OR_SYM                     /* OPERATOR */
%token  OR_SYM                        /* SQL-2003-R */
%token  OUTER
%token  OUTFILE
%token  OUT_SYM                       /* SQL-2003-R */
%token  OWNER_SYM
%token  PACK_KEYS_SYM
%token  PAGE_SYM
%token  PARAM_MARKER
%token  PARSER_SYM
%token  PARTIAL                       /* SQL-2003-N */
%token  PARTITIONING_SYM
%token  PARTITIONS_SYM
%token  PARTITION_SYM                 /* SQL-2003-R */
%token  PASSWORD
%token  PHASE_SYM
%token  PLUGINS_SYM
%token  PLUGIN_SYM
%token  POINT_SYM
%token  POLYGON
%token  PORT_SYM
%token  POSITION_SYM                  /* SQL-2003-N */
%token  PRECISION                     /* SQL-2003-R */
%token  PREPARE_SYM                   /* SQL-2003-R */
%token  PRESERVE_SYM
%token  PREV_SYM
%token  PRIMARY_SYM                   /* SQL-2003-R */
%token  PRIVILEGES                    /* SQL-2003-N */
%token  PROCEDURE                     /* SQL-2003-R */
%token  PROCESS
%token  PROCESSLIST_SYM
%token  PURGE
%token  QUARTER_SYM
%token  QUERY_SYM
%token  QUICK
%token  RANGE_SYM                     /* SQL-2003-R */
%token  READS_SYM                     /* SQL-2003-R */
%token  READ_ONLY_SYM
%token  READ_SYM                      /* SQL-2003-N */
%token  READ_WRITE_SYM
%token  REAL                          /* SQL-2003-R */
%token  REBUILD_SYM
%token  RECOVER_SYM
%token  REDOFILE_SYM
%token  REDO_BUFFER_SIZE_SYM
%token  REDUNDANT_SYM
%token  REFERENCES                    /* SQL-2003-R */
%token  REGEXP
%token  RELAY_LOG_FILE_SYM
%token  RELAY_LOG_POS_SYM
%token  RELAY_THREAD
%token  RELEASE_SYM                   /* SQL-2003-R */
%token  RELOAD
%token  REMOVE_SYM
%token  RENAME
%token  REORGANIZE_SYM
%token  REPAIR
%token  REPEATABLE_SYM                /* SQL-2003-N */
%token  REPEAT_SYM                    /* MYSQL-FUNC */
%token  REPLACE                       /* MYSQL-FUNC */
%token  REPLICATION
%token  REQUIRE_SYM
%token  RESET_SYM
%token  RESOURCES
%token  RESTORE_SYM
%token  RESTRICT
%token  RESUME_SYM
%token  RETURNS_SYM                   /* SQL-2003-R */
%token  RETURN_SYM                    /* SQL-2003-R */
%token  REVOKE                        /* SQL-2003-R */
%token  RIGHT                         /* SQL-2003-R */
%token  ROLLBACK_SYM                  /* SQL-2003-R */
%token  ROLLUP_SYM                    /* SQL-2003-R */
%token  ROUTINE_SYM                   /* SQL-2003-N */
%token  ROWS_SYM                      /* SQL-2003-R */
%token  ROW_FORMAT_SYM
%token  ROW_SYM                       /* SQL-2003-R */
%token  RTREE_SYM
%token  SAVEPOINT_SYM                 /* SQL-2003-R */
%token  SCHEDULE_SYM
%token  SECOND_MICROSECOND_SYM
%token  SECOND_SYM                    /* SQL-2003-R */
%token  SECURITY_SYM                  /* SQL-2003-N */
%token  SELECT_SYM                    /* SQL-2003-R */
%token  SENSITIVE_SYM                 /* FUTURE-USE */
%token  SEPARATOR_SYM
%token  SERIALIZABLE_SYM              /* SQL-2003-N */
%token  SERIAL_SYM
%token  SESSION_SYM                   /* SQL-2003-N */
%token  SERVER_SYM
%token  SERVER_OPTIONS
%token  SET                           /* SQL-2003-R */
%token  SET_VAR
%token  SHARE_SYM
%token  SHIFT_LEFT                    /* OPERATOR */
%token  SHIFT_RIGHT                   /* OPERATOR */
%token  SHOW
%token  SHUTDOWN
%token  SIGNED_SYM
%token  SIMPLE_SYM                    /* SQL-2003-N */
%token  SLAVE
%token  SMALLINT                      /* SQL-2003-R */
%token  SNAPSHOT_SYM
%token  SOCKET_SYM
%token  SONAME_SYM
%token  SOUNDS_SYM
%token  SPATIAL_SYM
%token  SPECIFIC_SYM                  /* SQL-2003-R */
%token  SQLEXCEPTION_SYM              /* SQL-2003-R */
%token  SQLSTATE_SYM                  /* SQL-2003-R */
%token  SQLWARNING_SYM                /* SQL-2003-R */
%token  SQL_BIG_RESULT
%token  SQL_BUFFER_RESULT
%token  SQL_CACHE_SYM
%token  SQL_CALC_FOUND_ROWS
%token  SQL_NO_CACHE_SYM
%token  SQL_SMALL_RESULT
%token  SQL_SYM                       /* SQL-2003-R */
%token  SQL_THREAD
%token  SSL_SYM
%token  STARTING
%token  STARTS_SYM
%token  START_SYM                     /* SQL-2003-R */
%token  STATUS_SYM
%token  STDDEV_SAMP_SYM               /* SQL-2003-N */
%token  STD_SYM
%token  STOP_SYM
%token  STORAGE_SYM
%token  STRAIGHT_JOIN
%token  STRING_SYM
%token  SUBDATE_SYM
%token  SUBJECT_SYM
%token  SUBPARTITIONS_SYM
%token  SUBPARTITION_SYM
%token  SUBSTRING                     /* SQL-2003-N */
%token  SUM_SYM                       /* SQL-2003-N */
%token  SUPER_SYM
%token  SUSPEND_SYM
%token  SYSDATE
%token  TABLES
%token  TABLESPACE
%token  TABLE_REF_PRIORITY
%token  TABLE_SYM                     /* SQL-2003-R */
%token  TEMPORARY                     /* SQL-2003-N */
%token  TEMPTABLE_SYM
%token  TERMINATED
%token  TEXT_STRING
%token  TEXT_SYM
%token  THAN_SYM
%token  THEN_SYM                      /* SQL-2003-R */
%token  TIMESTAMP                     /* SQL-2003-R */
%token  TIMESTAMP_ADD
%token  TIMESTAMP_DIFF
%token  TIME_SYM                      /* SQL-2003-R */
%token  TINYBLOB
%token  TINYINT
%token  TINYTEXT
%token  TO_SYM                        /* SQL-2003-R */
%token  TRAILING                      /* SQL-2003-R */
%token  TRANSACTION_SYM
%token  TRANSACTIONAL_SYM
%token  TRIGGERS_SYM
%token  TRIGGER_SYM                   /* SQL-2003-R */
%token  TRIM                          /* SQL-2003-N */
%token  TRUE_SYM                      /* SQL-2003-R */
%token  TRUNCATE_SYM
%token  TYPES_SYM
%token  TYPE_SYM                      /* SQL-2003-N */
%token  UDF_RETURNS_SYM
%token  ULONGLONG_NUM
%token  UNCOMMITTED_SYM               /* SQL-2003-N */
%token  UNDEFINED_SYM
%token  UNDERSCORE_CHARSET
%token  UNDOFILE_SYM
%token  UNDO_BUFFER_SIZE_SYM
%token  UNDO_SYM                      /* FUTURE-USE */
%token  UNICODE_SYM
%token  UNINSTALL_SYM
%token  UNION_SYM                     /* SQL-2003-R */
%token  UNIQUE_SYM
%token  UNKNOWN_SYM                   /* SQL-2003-R */
%token  UNLOCK_SYM
%token  UNSIGNED
%token  UNTIL_SYM
%token  UPDATE_SYM                    /* SQL-2003-R */
%token  UPGRADE_SYM
%token  USAGE                         /* SQL-2003-N */
%token  USER                          /* SQL-2003-R */
%token  USE_FRM
%token  USE_SYM
%token  USING                         /* SQL-2003-R */
%token  UTC_DATE_SYM
%token  UTC_TIMESTAMP_SYM
%token  UTC_TIME_SYM
%token  VALUES                        /* SQL-2003-R */
%token  VALUE_SYM                     /* SQL-2003-R */
%token  VARBINARY
%token  VARCHAR                       /* SQL-2003-R */
%token  VARIABLES
%token  VARIANCE_SYM
%token  VARYING                       /* SQL-2003-R */
%token  VAR_SAMP_SYM
%token  VIEW_SYM                      /* SQL-2003-N */
%token  WAIT_SYM
%token  WARNINGS
%token  WEEK_SYM
%token  WHEN_SYM                      /* SQL-2003-R */
%token  WHERE                         /* SQL-2003-R */
%token  WHILE_SYM
%token  WITH                          /* SQL-2003-R */
%token  WORK_SYM                      /* SQL-2003-N */
%token  WRAPPER_SYM
%token  WRITE_SYM                     /* SQL-2003-N */
%token  X509_SYM
%token  XA_SYM
%token  XOR
%token  YEAR_MONTH_SYM
%token  YEAR_SYM                      /* SQL-2003-R */
%token  ZEROFILL

%left   JOIN_SYM INNER_SYM STRAIGHT_JOIN CROSS LEFT RIGHT
/* A dummy token to force the priority of table_ref production in a join. */
%left   TABLE_REF_PRIORITY
%left   SET_VAR
%left   OR_OR_SYM OR_SYM OR2_SYM
%left   XOR
%left   AND_SYM AND_AND_SYM
%left   BETWEEN_SYM CASE_SYM WHEN_SYM THEN_SYM ELSE
%left   EQ EQUAL_SYM GE GT_SYM LE LT NE IS LIKE REGEXP IN_SYM
%left   '|'
%left   '&'
%left   SHIFT_LEFT SHIFT_RIGHT
%left   '-' '+'
%left   '*' '/' '%' DIV_SYM MOD_SYM
%left   '^'
%left   NEG '~'
%right  NOT_SYM NOT2_SYM
%right  BINARY COLLATE_SYM
%left  INTERVAL_SYM

%%

query:
      END_OF_INPUT
      {
        $$= NULL;
        mysql_parser::SqlAstStatics::tree(static_cast<mysql_parser::SqlAstNode*>($$));
      }
    | verb_clause END_OF_INPUT
      {
        $$= $1;
        mysql_parser::SqlAstStatics::tree(static_cast<mysql_parser::SqlAstNode*>($$));
      }
    ;

verb_clause:
      statement
      {
        $$= mysql_parser::new_ast_node(sql::_verb_clause);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | begin
      {
        $$= mysql_parser::new_ast_node(sql::_verb_clause);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | verb_clause ';'
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_verb_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_59));
      }
    ;

statement:
      alter
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | analyze
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | backup
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | binlog_base64_event
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | call
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | change
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | check
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | checksum
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | commit
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | create
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | deallocate
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | delete
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | describe
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | do
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | drop
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | edit
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | execute
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | flush
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | grant
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | handler
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | help
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | insert
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | install
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | kill
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | load
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | lock
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | optimize
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | keycache
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | partition_entry
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | preload
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | prepare
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | purge
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | release
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | rename
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | repair
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | replace
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | reset
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | restore
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | revoke
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | rollback
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | savepoint
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | select
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | set
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | show
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | slave
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | start
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | truncate
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | uninstall
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | unlock
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | update
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | use
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | xa
      {
        $$= mysql_parser::new_ast_node(sql::_statement);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

deallocate:
      deallocate_or_drop PREPARE_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_deallocate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PREPARE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

deallocate_or_drop:
      DEALLOCATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_deallocate_or_drop);
      }
    | DROP
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_deallocate_or_drop);
      }
    ;

prepare:
      PREPARE_SYM ident FROM prepare_src
      {
        $$= mysql_parser::new_ast_node(sql::_prepare);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PREPARE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

prepare_src:
      TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_prepare_src);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '@' ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_prepare_src);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

edit:
      EDIT_SYM table_ident where_clause opt_order_clause
      {
        $$= mysql_parser::new_ast_node(sql::_edit);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EDIT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

execute:
      EXECUTE_SYM ident execute_using
      {
        $$= mysql_parser::new_ast_node(sql::_execute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EXECUTE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

execute_using:
      /* empty */
      {
        $$= NULL;
      }
    | USING execute_var_list
      {
        $$= mysql_parser::new_ast_node(sql::_execute_using);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USING));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

execute_var_list:
      execute_var_list ',' execute_var_ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_execute_var_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | execute_var_ident
      {
        $$= mysql_parser::new_ast_node(sql::_execute_var_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

execute_var_ident:
      '@' ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_execute_var_ident);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

help:
      HELP_SYM ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_help);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HELP_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

change:
      CHANGE MASTER_SYM TO_SYM master_defs
      {
        $$= mysql_parser::new_ast_node(sql::_change);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHANGE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MASTER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

master_defs:
      master_def
      {
        $$= mysql_parser::new_ast_node(sql::_master_defs);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | master_defs ',' master_def
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_master_defs);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

master_def:
      MASTER_HOST_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_HOST_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_USER_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_USER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_PASSWORD_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_PASSWORD_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_PORT_SYM EQ ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_PORT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_CONNECT_RETRY_SYM EQ ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_CONNECT_RETRY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_SYM EQ ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_CA_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_CA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_CAPATH_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_CAPATH_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_CERT_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_CERT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_CIPHER_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_CIPHER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_KEY_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_KEY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SSL_VERIFY_SERVER_CERT_SYM EQ ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SSL_VERIFY_SERVER_CERT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | master_file_def
      {
        $$= mysql_parser::new_ast_node(sql::_master_def);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

master_file_def:
      MASTER_LOG_FILE_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_file_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_LOG_FILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_LOG_POS_SYM EQ ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_master_file_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_LOG_POS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | RELAY_LOG_FILE_SYM EQ TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_master_file_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RELAY_LOG_FILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | RELAY_LOG_POS_SYM EQ ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_master_file_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RELAY_LOG_POS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

create:
      CREATE opt_table_options TABLE_SYM opt_if_not_exists table_ident create2
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | CREATE opt_unique_or_fulltext INDEX_SYM ident key_alg ON table_ident '(' key_list ')' key_options
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INDEX_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_ON));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_40));
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($10, sql::_41));
        mysql_parser::add_ast_child_node($$, $11);
      }
    | CREATE DATABASE opt_if_not_exists ident opt_create_database_options
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | CREATE view_or_trigger_or_sp_or_event
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | CREATE USER clear_privileges grant_list
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_USER));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | CREATE LOGFILE_SYM GROUP_SYM logfile_group_info
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOGFILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_GROUP_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | CREATE TABLESPACE tablespace_info
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CREATE server_def
      {
        $$= mysql_parser::new_ast_node(sql::_create);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

server_def:
      SERVER_SYM ident_or_text FOREIGN DATA_SYM WRAPPER_SYM ident_or_text OPTIONS_SYM '(' server_options_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_server_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SERVER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FOREIGN));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_DATA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_WRAPPER_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_OPTIONS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_40));
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($10, sql::_41));
      }
    ;

server_options_list:
      server_option
      {
        $$= mysql_parser::new_ast_node(sql::_server_options_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | server_options_list ',' server_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_server_options_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

server_option:
      USER TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USER));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | HOST_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HOST_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | DATABASE TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | OWNER_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OWNER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | PASSWORD TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | SOCKET_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SOCKET_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | PORT_SYM ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_server_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PORT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

event_tail:
      EVENT_SYM opt_if_not_exists sp_name ON SCHEDULE_SYM ev_schedule_time opt_ev_on_completion opt_ev_status opt_ev_comment DO_SYM ev_sql_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_event_tail);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EVENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_SCHEDULE_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($10, sql::_DO_SYM));
        mysql_parser::add_ast_child_node($$, $11);
      }
    ;

ev_schedule_time:
      EVERY_SYM expr interval ev_starts ev_ends
      {
        $$= mysql_parser::new_ast_node(sql::_ev_schedule_time);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EVERY_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | AT_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_ev_schedule_time);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_ev_status:
      /* empty */
      {
        $$= NULL;
      }
    | ENABLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_status);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENABLE_SYM));
      }
    | DISABLE_SYM ON SLAVE
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_status);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DISABLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_SLAVE));
      }
    | DISABLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_status);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DISABLE_SYM));
      }
    ;

ev_starts:
      /* empty */
      {
        $$= NULL;
      }
    | STARTS_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_ev_starts);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STARTS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

ev_ends:
      /* empty */
      {
        $$= NULL;
      }
    | ENDS_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_ev_ends);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENDS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_ev_on_completion:
      /* empty */
      {
        $$= NULL;
      }
    | ev_on_completion
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_on_completion);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

ev_on_completion:
      ON COMPLETION_SYM PRESERVE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_ev_on_completion);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COMPLETION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_PRESERVE_SYM));
      }
    | ON COMPLETION_SYM NOT_SYM PRESERVE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_ev_on_completion);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COMPLETION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NOT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_PRESERVE_SYM));
      }
    ;

opt_ev_comment:
      /* empty */
      {
        $$= NULL;
      }
    | COMMENT_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_comment);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

ev_sql_stmt:
      ev_sql_stmt_inner
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ev_sql_stmt);
      }
    ;

ev_sql_stmt_inner:
      sp_proc_stmt_statement
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_return
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_if
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | case_stmt_specification
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_labeled_control
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_unlabeled
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_leave
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_iterate
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_open
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_fetch
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_close
      {
        $$= mysql_parser::new_ast_node(sql::_ev_sql_stmt_inner);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

clear_privileges:
      /* empty */
      {
        $$= NULL;
      }
    ;

sp_name:
      ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_name);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_name);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_a_chistics:
      /* empty */
      {
        $$= NULL;
      }
    | sp_a_chistics sp_chistic
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_a_chistics);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_c_chistics:
      /* empty */
      {
        $$= NULL;
      }
    | sp_c_chistics sp_c_chistic
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_c_chistics);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_chistic:
      COMMENT_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | LANGUAGE_SYM SQL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LANGUAGE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SQL_SYM));
      }
    | NO_SYM SQL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NO_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SQL_SYM));
      }
    | CONTAINS_SYM SQL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONTAINS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SQL_SYM));
      }
    | READS_SYM SQL_SYM DATA_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SQL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DATA_SYM));
      }
    | MODIFIES_SYM SQL_SYM DATA_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MODIFIES_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SQL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DATA_SYM));
      }
    | sp_suid
      {
        $$= mysql_parser::new_ast_node(sql::_sp_chistic);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_c_chistic:
      sp_chistic
      {
        $$= mysql_parser::new_ast_node(sql::_sp_c_chistic);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | DETERMINISTIC_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_c_chistic);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DETERMINISTIC_SYM));
      }
    | not DETERMINISTIC_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_c_chistic);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DETERMINISTIC_SYM));
      }
    ;

sp_suid:
      SQL_SYM SECURITY_SYM DEFINER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_suid);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SECURITY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DEFINER_SYM));
      }
    | SQL_SYM SECURITY_SYM INVOKER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_suid);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SECURITY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INVOKER_SYM));
      }
    ;

call:
      CALL_SYM sp_name opt_sp_cparam_list
      {
        $$= mysql_parser::new_ast_node(sql::_call);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CALL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_sp_cparam_list:
      /* empty */
      {
        $$= NULL;
      }
    | '(' opt_sp_cparams ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_sp_cparam_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

opt_sp_cparams:
      /* empty */
      {
        $$= NULL;
      }
    | sp_cparams
      {
        $$= mysql_parser::new_ast_node(sql::_opt_sp_cparams);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_cparams:
      sp_cparams ',' expr
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_cparams);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | expr
      {
        $$= mysql_parser::new_ast_node(sql::_sp_cparams);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_fdparam_list:
      /* empty */
      {
        $$= NULL;
      }
    | sp_fdparams
      {
        $$= mysql_parser::new_ast_node(sql::_sp_fdparam_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_fdparams:
      sp_fdparams ',' sp_fdparam
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_fdparams);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | sp_fdparam
      {
        $$= mysql_parser::new_ast_node(sql::_sp_fdparams);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_init_param:
      /* empty */
      {
        $$= NULL;
      }
    ;

sp_fdparam:
      ident sp_init_param type
      {
        $$= mysql_parser::new_ast_node(sql::_sp_fdparam);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sp_pdparam_list:
      /* empty */
      {
        $$= NULL;
      }
    | sp_pdparams
      {
        $$= mysql_parser::new_ast_node(sql::_sp_pdparam_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_pdparams:
      sp_pdparams ',' sp_pdparam
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_pdparams);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | sp_pdparam
      {
        $$= mysql_parser::new_ast_node(sql::_sp_pdparams);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_pdparam:
      sp_opt_inout sp_init_param ident type
      {
        $$= mysql_parser::new_ast_node(sql::_sp_pdparam);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

sp_opt_inout:
      /* empty */
      {
        $$= NULL;
      }
    | IN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_opt_inout);
      }
    | OUT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_opt_inout);
      }
    | INOUT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_opt_inout);
      }
    ;

sp_proc_stmts:
      /* empty */
      {
        $$= NULL;
      }
    | sp_proc_stmts sp_proc_stmt ';'
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_proc_stmts);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_59));
      }
    ;

sp_proc_stmts1:
      sp_proc_stmt ';'
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmts1);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_59));
      }
    | sp_proc_stmts1 sp_proc_stmt ';'
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_proc_stmts1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_59));
      }
    ;

sp_decls:
      /* empty */
      {
        $$= NULL;
      }
    | sp_decls sp_decl ';'
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_decls);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_59));
      }
    ;

sp_decl:
      DECLARE_SYM sp_decl_idents type sp_opt_default
      {
        $$= mysql_parser::new_ast_node(sql::_sp_decl);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DECLARE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DECLARE_SYM ident CONDITION_SYM FOR_SYM sp_cond
      {
        $$= mysql_parser::new_ast_node(sql::_sp_decl);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DECLARE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_CONDITION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | DECLARE_SYM sp_handler_type HANDLER_SYM FOR_SYM sp_hcond_list sp_proc_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_sp_decl);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DECLARE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_HANDLER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | DECLARE_SYM ident CURSOR_SYM FOR_SYM sp_cursor_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_sp_decl);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DECLARE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_CURSOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

sp_cursor_stmt:
      select
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_cursor_stmt);
      }
    ;

sp_handler_type:
      EXIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_handler_type);
      }
    | CONTINUE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_handler_type);
      }
    ;

sp_hcond_list:
      sp_hcond_element
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_hcond_list ',' sp_hcond_element
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_hcond_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sp_hcond_element:
      sp_hcond
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond_element);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_cond:
      ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_sp_cond);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | SQLSTATE_SYM opt_value TEXT_STRING_literal
      {
        $$= mysql_parser::new_ast_node(sql::_sp_cond);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQLSTATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_value:
      /* empty */
      {
        $$= NULL;
      }
    | VALUE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_value);
      }
    ;

sp_hcond:
      sp_cond
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | SQLWARNING_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQLWARNING_SYM));
      }
    | not FOUND_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FOUND_SYM));
      }
    | SQLEXCEPTION_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_hcond);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQLEXCEPTION_SYM));
      }
    ;

sp_decl_idents:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_decl_idents);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_decl_idents ',' ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_decl_idents);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sp_opt_default:
      /* empty */
      {
        $$= NULL;
      }
    | DEFAULT expr
      {
        $$= mysql_parser::new_ast_node(sql::_sp_opt_default);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFAULT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_proc_stmt:
      sp_proc_stmt_statement
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_return
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_if
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | case_stmt_specification
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_labeled_control
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_unlabeled
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_leave
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_iterate
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_open
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_fetch
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_proc_stmt_close
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_proc_stmt_if:
      IF sp_if END IF
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_if);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IF));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_END));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_IF));
      }
    ;

sp_proc_stmt_statement:
      statement
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_proc_stmt_statement);
      }
    ;

sp_proc_stmt_return:
      RETURN_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_return);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RETURN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_proc_stmt_unlabeled:
      sp_unlabeled_control
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_unlabeled);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

sp_proc_stmt_leave:
      LEAVE_SYM label_ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_leave);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LEAVE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_proc_stmt_iterate:
      ITERATE_SYM label_ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_iterate);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ITERATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_proc_stmt_open:
      OPEN_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_open);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OPEN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_proc_stmt_fetch:
      FETCH_SYM sp_opt_fetch_noise ident INTO sp_fetch_list
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_fetch);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FETCH_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_INTO));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

sp_proc_stmt_close:
      CLOSE_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_proc_stmt_close);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CLOSE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_opt_fetch_noise:
      /* empty */
      {
        $$= NULL;
      }
    | NEXT_SYM FROM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_opt_fetch_noise);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NEXT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FROM));
      }
    | FROM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_opt_fetch_noise);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
      }
    ;

sp_fetch_list:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_sp_fetch_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_fetch_list ',' ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sp_fetch_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sp_if:
      expr THEN_SYM sp_proc_stmts1 sp_elseifs
      {
        $$= mysql_parser::new_ast_node(sql::_sp_if);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_THEN_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

sp_elseifs:
      /* empty */
      {
        $$= NULL;
      }
    | ELSEIF_SYM sp_if
      {
        $$= mysql_parser::new_ast_node(sql::_sp_elseifs);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ELSEIF_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | ELSE sp_proc_stmts1
      {
        $$= mysql_parser::new_ast_node(sql::_sp_elseifs);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ELSE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

case_stmt_specification:
      simple_case_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_case_stmt_specification);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | searched_case_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_case_stmt_specification);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

simple_case_stmt:
      CASE_SYM expr simple_when_clause_list else_clause_opt END CASE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_simple_case_stmt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CASE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_END));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_CASE_SYM));
      }
    ;

searched_case_stmt:
      CASE_SYM searched_when_clause_list else_clause_opt END CASE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_searched_case_stmt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CASE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_END));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_CASE_SYM));
      }
    ;

simple_when_clause_list:
      simple_when_clause
      {
        $$= mysql_parser::new_ast_node(sql::_simple_when_clause_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | simple_when_clause_list simple_when_clause
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_simple_when_clause_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

searched_when_clause_list:
      searched_when_clause
      {
        $$= mysql_parser::new_ast_node(sql::_searched_when_clause_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | searched_when_clause_list searched_when_clause
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_searched_when_clause_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

simple_when_clause:
      WHEN_SYM expr THEN_SYM sp_proc_stmts1
      {
        $$= mysql_parser::new_ast_node(sql::_simple_when_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WHEN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_THEN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

searched_when_clause:
      WHEN_SYM expr THEN_SYM sp_proc_stmts1
      {
        $$= mysql_parser::new_ast_node(sql::_searched_when_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WHEN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_THEN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

else_clause_opt:
      /* empty */
      {
        $$= NULL;
      }
    | ELSE sp_proc_stmts1
      {
        $$= mysql_parser::new_ast_node(sql::_else_clause_opt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ELSE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sp_labeled_control:
      label_ident ':' sp_unlabeled_control sp_opt_label
      {
        $$= mysql_parser::new_ast_node(sql::_sp_labeled_control);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_58));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

sp_opt_label:
      /* empty */
      {
        $$= NULL;
      }
    | label_ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sp_opt_label);
      }
    ;

sp_unlabeled_control:
      BEGIN_SYM sp_decls sp_proc_stmts END
      {
        $$= mysql_parser::new_ast_node(sql::_sp_unlabeled_control);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BEGIN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_END));
      }
    | LOOP_SYM sp_proc_stmts1 END LOOP_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_unlabeled_control);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOOP_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_END));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_LOOP_SYM));
      }
    | WHILE_SYM expr DO_SYM sp_proc_stmts1 END WHILE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_unlabeled_control);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WHILE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DO_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_END));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_WHILE_SYM));
      }
    | REPEAT_SYM sp_proc_stmts1 UNTIL_SYM expr END REPEAT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_sp_unlabeled_control);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPEAT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_UNTIL_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_END));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_REPEAT_SYM));
      }
    ;

trg_action_time:
      BEFORE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_trg_action_time);
      }
    | AFTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_trg_action_time);
      }
    ;

trg_event:
      INSERT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_trg_event);
      }
    | UPDATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_trg_event);
      }
    | DELETE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_trg_event);
      }
    ;

change_tablespace_access:
      tablespace_name ts_access_mode
      {
        $$= mysql_parser::new_ast_node(sql::_change_tablespace_access);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

change_tablespace_info:
      tablespace_name CHANGE ts_datafile change_ts_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_change_tablespace_info);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CHANGE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

tablespace_info:
      tablespace_name ADD ts_datafile opt_logfile_group_name tablespace_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_info);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ADD));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

opt_logfile_group_name:
      /* empty */
      {
        $$= NULL;
      }
    | USE_SYM LOGFILE_SYM GROUP_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_opt_logfile_group_name);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOGFILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_GROUP_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

alter_tablespace_info:
      tablespace_name ADD ts_datafile alter_tablespace_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_info);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ADD));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | tablespace_name DROP ts_datafile alter_tablespace_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_info);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DROP));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

logfile_group_info:
      logfile_group_name add_log_file logfile_group_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_info);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

alter_logfile_group_info:
      logfile_group_name add_log_file alter_logfile_group_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_logfile_group_info);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

add_log_file:
      ADD lg_undofile
      {
        $$= mysql_parser::new_ast_node(sql::_add_log_file);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADD));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | ADD lg_redofile
      {
        $$= mysql_parser::new_ast_node(sql::_add_log_file);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADD));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

change_ts_option_list:
      change_ts_options
      {
        $$= mysql_parser::new_ast_node(sql::_change_ts_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

change_ts_options:
      change_ts_option
      {
        $$= mysql_parser::new_ast_node(sql::_change_ts_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | change_ts_options change_ts_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_change_ts_options);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | change_ts_options ',' change_ts_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_change_ts_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

change_ts_option:
      opt_ts_initial_size
      {
        $$= mysql_parser::new_ast_node(sql::_change_ts_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_autoextend_size
      {
        $$= mysql_parser::new_ast_node(sql::_change_ts_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_max_size
      {
        $$= mysql_parser::new_ast_node(sql::_change_ts_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

tablespace_option_list:
      tablespace_options
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

tablespace_options:
      tablespace_option
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | tablespace_options tablespace_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_tablespace_options);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | tablespace_options ',' tablespace_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_tablespace_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

tablespace_option:
      opt_ts_initial_size
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_autoextend_size
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_max_size
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_extent_size
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_nodegroup
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_engine
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ts_wait
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_comment
      {
        $$= mysql_parser::new_ast_node(sql::_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

alter_tablespace_option_list:
      alter_tablespace_options
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

alter_tablespace_options:
      alter_tablespace_option
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | alter_tablespace_options alter_tablespace_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alter_tablespace_options);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | alter_tablespace_options ',' alter_tablespace_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alter_tablespace_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

alter_tablespace_option:
      opt_ts_initial_size
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_autoextend_size
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_max_size
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_engine
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ts_wait
      {
        $$= mysql_parser::new_ast_node(sql::_alter_tablespace_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

logfile_group_option_list:
      logfile_group_options
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

logfile_group_options:
      logfile_group_option
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | logfile_group_options logfile_group_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_logfile_group_options);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | logfile_group_options ',' logfile_group_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_logfile_group_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

logfile_group_option:
      opt_ts_initial_size
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_undo_buffer_size
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_redo_buffer_size
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_nodegroup
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_engine
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ts_wait
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_comment
      {
        $$= mysql_parser::new_ast_node(sql::_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

alter_logfile_group_option_list:
      alter_logfile_group_options
      {
        $$= mysql_parser::new_ast_node(sql::_alter_logfile_group_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

alter_logfile_group_options:
      alter_logfile_group_option
      {
        $$= mysql_parser::new_ast_node(sql::_alter_logfile_group_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | alter_logfile_group_options alter_logfile_group_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alter_logfile_group_options);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | alter_logfile_group_options ',' alter_logfile_group_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alter_logfile_group_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

alter_logfile_group_option:
      opt_ts_initial_size
      {
        $$= mysql_parser::new_ast_node(sql::_alter_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | opt_ts_engine
      {
        $$= mysql_parser::new_ast_node(sql::_alter_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ts_wait
      {
        $$= mysql_parser::new_ast_node(sql::_alter_logfile_group_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

ts_datafile:
      DATAFILE_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_ts_datafile);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATAFILE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

lg_undofile:
      UNDOFILE_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_lg_undofile);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNDOFILE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

lg_redofile:
      REDOFILE_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_lg_redofile);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REDOFILE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

tablespace_name:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_tablespace_name);
      }
    ;

logfile_group_name:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_logfile_group_name);
      }
    ;

ts_access_mode:
      READ_ONLY_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_ts_access_mode);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READ_ONLY_SYM));
      }
    | READ_WRITE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_ts_access_mode);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READ_WRITE_SYM));
      }
    | NOT_SYM ACCESSIBLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_ts_access_mode);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NOT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ACCESSIBLE_SYM));
      }
    ;

opt_ts_initial_size:
      INITIAL_SIZE_SYM opt_equal size_number
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_initial_size);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INITIAL_SIZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_autoextend_size:
      AUTOEXTEND_SIZE_SYM opt_equal size_number
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_autoextend_size);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AUTOEXTEND_SIZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_max_size:
      MAX_SIZE_SYM opt_equal size_number
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_max_size);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_SIZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_extent_size:
      EXTENT_SIZE_SYM opt_equal size_number
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_extent_size);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EXTENT_SIZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_undo_buffer_size:
      UNDO_BUFFER_SIZE_SYM opt_equal size_number
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_undo_buffer_size);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNDO_BUFFER_SIZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_redo_buffer_size:
      REDO_BUFFER_SIZE_SYM opt_equal size_number
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_redo_buffer_size);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REDO_BUFFER_SIZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_nodegroup:
      NODEGROUP_SYM opt_equal real_ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_nodegroup);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NODEGROUP_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_comment:
      COMMENT_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_comment);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ts_engine:
      opt_storage ENGINE_SYM opt_equal storage_engines
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ts_engine);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ENGINE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_ts_wait:
      /* empty */
      {
        $$= NULL;
      }
    | ts_wait
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_ts_wait);
      }
    ;

ts_wait:
      WAIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ts_wait);
      }
    | NO_WAIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ts_wait);
      }
    ;

size_number:
      real_ulong_num
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_size_number);
      }
    | IDENT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_size_number);
      }
    ;

create2:
      '(' create2a
      {
        $$= mysql_parser::new_ast_node(sql::_create2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | opt_create_table_options opt_partitioning create3
      {
        $$= mysql_parser::new_ast_node(sql::_create2);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | LIKE table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_create2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LIKE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | '(' LIKE table_ident ')'
      {
        $$= mysql_parser::new_ast_node(sql::_create2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LIKE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

create2a:
      field_list ')' opt_create_table_options opt_partitioning create3
      {
        $$= mysql_parser::new_ast_node(sql::_create2a);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_41));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | opt_partitioning create_select ')' union_opt
      {
        $$= mysql_parser::new_ast_node(sql::_create2a);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

create3:
      /* empty */
      {
        $$= NULL;
      }
    | opt_duplicate opt_as create_select union_clause
      {
        $$= mysql_parser::new_ast_node(sql::_create3);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | opt_duplicate opt_as '(' create_select ')' union_opt
      {
        $$= mysql_parser::new_ast_node(sql::_create3);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
        mysql_parser::add_ast_child_node($$, $6);
      }
    ;

opt_partitioning:
      /* empty */
      {
        $$= NULL;
      }
    | partitioning
      {
        $$= mysql_parser::new_ast_node(sql::_opt_partitioning);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

partitioning:
      PARTITION_SYM partition
      {
        $$= mysql_parser::new_ast_node(sql::_partitioning);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

partition_entry:
      PARTITION_SYM partition
      {
        $$= mysql_parser::new_ast_node(sql::_partition_entry);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

partition:
      BY part_type_def opt_no_parts opt_sub_part part_defs
      {
        $$= mysql_parser::new_ast_node(sql::_partition);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BY));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

part_type_def:
      opt_linear KEY_SYM '(' part_field_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_part_type_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_KEY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | opt_linear HASH_SYM part_func
      {
        $$= mysql_parser::new_ast_node(sql::_part_type_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_HASH_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | RANGE_SYM part_func
      {
        $$= mysql_parser::new_ast_node(sql::_part_type_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RANGE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | LIST_SYM part_func
      {
        $$= mysql_parser::new_ast_node(sql::_part_type_def);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LIST_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_linear:
      /* empty */
      {
        $$= NULL;
      }
    | LINEAR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_linear);
      }
    ;

part_field_list:
      /* empty */
      {
        $$= NULL;
      }
    | part_field_item_list
      {
        $$= mysql_parser::new_ast_node(sql::_part_field_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

part_field_item_list:
      part_field_item
      {
        $$= mysql_parser::new_ast_node(sql::_part_field_item_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | part_field_item_list ',' part_field_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_part_field_item_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

part_field_item:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_part_field_item);
      }
    ;

part_func:
      '(' remember_name part_func_expr remember_end ')'
      {
        $$= mysql_parser::new_ast_node(sql::_part_func);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    ;

sub_part_func:
      '(' remember_name part_func_expr remember_end ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sub_part_func);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    ;

opt_no_parts:
      /* empty */
      {
        $$= NULL;
      }
    | PARTITIONS_SYM real_ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_opt_no_parts);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PARTITIONS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_sub_part:
      /* empty */
      {
        $$= NULL;
      }
    | SUBPARTITION_SYM BY opt_linear HASH_SYM sub_part_func opt_no_subparts
      {
        $$= mysql_parser::new_ast_node(sql::_opt_sub_part);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBPARTITION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_HASH_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | SUBPARTITION_SYM BY opt_linear KEY_SYM '(' sub_part_field_list ')' opt_no_subparts
      {
        $$= mysql_parser::new_ast_node(sql::_opt_sub_part);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBPARTITION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_KEY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_40));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
        mysql_parser::add_ast_child_node($$, $8);
      }
    ;

sub_part_field_list:
      sub_part_field_item
      {
        $$= mysql_parser::new_ast_node(sql::_sub_part_field_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sub_part_field_list ',' sub_part_field_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sub_part_field_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sub_part_field_item:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sub_part_field_item);
      }
    ;

part_func_expr:
      bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_part_func_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_no_subparts:
      /* empty */
      {
        $$= NULL;
      }
    | SUBPARTITIONS_SYM real_ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_opt_no_subparts);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBPARTITIONS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

part_defs:
      /* empty */
      {
        $$= NULL;
      }
    | '(' part_def_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_part_defs);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

part_def_list:
      part_definition
      {
        $$= mysql_parser::new_ast_node(sql::_part_def_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | part_def_list ',' part_definition
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_part_def_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

part_definition:
      PARTITION_SYM part_name opt_part_values opt_part_options opt_sub_partition
      {
        $$= mysql_parser::new_ast_node(sql::_part_definition);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

part_name:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_part_name);
      }
    ;

opt_part_values:
      /* empty */
      {
        $$= NULL;
      }
    | VALUES LESS_SYM THAN_SYM part_func_max
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_values);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VALUES));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LESS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_THAN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | VALUES IN_SYM '(' part_list_func ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_values);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VALUES));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    ;

part_func_max:
      max_value_sym
      {
        $$= mysql_parser::new_ast_node(sql::_part_func_max);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | part_range_func
      {
        $$= mysql_parser::new_ast_node(sql::_part_func_max);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

max_value_sym:
      MAX_VALUE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_max_value_sym);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_VALUE_SYM));
      }
    | '(' MAX_VALUE_SYM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_max_value_sym);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MAX_VALUE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

part_range_func:
      '(' part_bit_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_part_range_func);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

part_list_func:
      part_list_item
      {
        $$= mysql_parser::new_ast_node(sql::_part_list_func);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | part_list_func ',' part_list_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_part_list_func);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

part_list_item:
      part_bit_expr
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_part_list_item);
      }
    ;

part_bit_expr:
      bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_part_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_sub_partition:
      /* empty */
      {
        $$= NULL;
      }
    | '(' sub_part_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_sub_partition);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

sub_part_list:
      sub_part_definition
      {
        $$= mysql_parser::new_ast_node(sql::_sub_part_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sub_part_list ',' sub_part_definition
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_sub_part_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sub_part_definition:
      SUBPARTITION_SYM sub_name opt_part_options
      {
        $$= mysql_parser::new_ast_node(sql::_sub_part_definition);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBPARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

sub_name:
      ident_or_text
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_sub_name);
      }
    ;

opt_part_options:
      /* empty */
      {
        $$= NULL;
      }
    | opt_part_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_part_option_list:
      opt_part_option_list opt_part_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_opt_part_option_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | opt_part_option
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_part_option:
      TABLESPACE opt_equal ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | opt_storage ENGINE_SYM opt_equal storage_engines
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ENGINE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | NODEGROUP_SYM opt_equal real_ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NODEGROUP_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MAX_ROWS opt_equal real_ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_ROWS));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MIN_ROWS opt_equal real_ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MIN_ROWS));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | DATA_SYM DIRECTORY_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DIRECTORY_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | INDEX_SYM DIRECTORY_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INDEX_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DIRECTORY_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | COMMENT_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_opt_part_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

create_select:
      SELECT_SYM select_options select_item_list opt_select_from
      {
        $$= mysql_parser::new_ast_node(sql::_create_select);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SELECT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_as:
      /* empty */
      {
        $$= NULL;
      }
    | AS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_as);
      }
    ;

opt_create_database_options:
      /* empty */
      {
        $$= NULL;
      }
    | create_database_options
      {
        $$= mysql_parser::new_ast_node(sql::_opt_create_database_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

create_database_options:
      create_database_option
      {
        $$= mysql_parser::new_ast_node(sql::_create_database_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | create_database_options create_database_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_create_database_options);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

create_database_option:
      default_collation
      {
        $$= mysql_parser::new_ast_node(sql::_create_database_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | default_charset
      {
        $$= mysql_parser::new_ast_node(sql::_create_database_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_table_options:
      /* empty */
      {
        $$= NULL;
      }
    | table_options
      {
        $$= mysql_parser::new_ast_node(sql::_opt_table_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

table_options:
      table_option
      {
        $$= mysql_parser::new_ast_node(sql::_table_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_option table_options
      {
        $$= mysql_parser::new_ast_node(sql::_table_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    ;

table_option:
      TEMPORARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_table_option);
      }
    ;

opt_if_not_exists:
      /* empty */
      {
        $$= NULL;
      }
    | IF not EXISTS
      {
        $$= mysql_parser::new_ast_node(sql::_opt_if_not_exists);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IF));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_EXISTS));
      }
    ;

opt_create_table_options:
      /* empty */
      {
        $$= NULL;
      }
    | create_table_options
      {
        $$= mysql_parser::new_ast_node(sql::_opt_create_table_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

create_table_options_space_separated:
      create_table_option
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_options_space_separated);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | create_table_option create_table_options_space_separated
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_options_space_separated);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    ;

create_table_options:
      create_table_option
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | create_table_option create_table_options
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | create_table_option ',' create_table_options
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::merge_ast_child_nodes($$, $3);
      }
    ;

create_table_option:
      ENGINE_SYM opt_equal storage_engines
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENGINE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | TYPE_SYM opt_equal storage_engines
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TYPE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MAX_ROWS opt_equal ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_ROWS));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MIN_ROWS opt_equal ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MIN_ROWS));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | AVG_ROW_LENGTH opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AVG_ROW_LENGTH));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PASSWORD opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | COMMENT_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | AUTO_INC opt_equal ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AUTO_INC));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PACK_KEYS_SYM opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PACK_KEYS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PACK_KEYS_SYM opt_equal DEFAULT
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PACK_KEYS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DEFAULT));
      }
    | CHECKSUM_SYM opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHECKSUM_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | DELAY_KEY_WRITE_SYM opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DELAY_KEY_WRITE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ROW_FORMAT_SYM opt_equal row_types
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ROW_FORMAT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | UNION_SYM opt_equal '(' table_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | default_charset
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | default_collation
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | INSERT_METHOD opt_equal merge_insert_types
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INSERT_METHOD));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | DATA_SYM DIRECTORY_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DIRECTORY_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | INDEX_SYM DIRECTORY_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INDEX_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DIRECTORY_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | TABLESPACE ident
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | STORAGE_SYM DISK_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STORAGE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DISK_SYM));
      }
    | STORAGE_SYM MEMORY_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STORAGE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MEMORY_SYM));
      }
    | CONNECTION_SYM opt_equal TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONNECTION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | KEY_BLOCK_SIZE opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_KEY_BLOCK_SIZE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | TRANSACTIONAL_SYM opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_create_table_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRANSACTIONAL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

default_charset:
      opt_default charset opt_equal charset_name_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_default_charset);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

default_collation:
      opt_default COLLATE_SYM opt_equal collation_name_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_default_collation);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COLLATE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

storage_engines:
      ident_or_text
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_storage_engines);
      }
    ;

known_storage_engines:
      ident_or_text
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_known_storage_engines);
      }
    ;

row_types:
      DEFAULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    | FIXED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    | DYNAMIC_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    | COMPRESSED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    | REDUNDANT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    | COMPACT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    | PAGE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_row_types);
      }
    ;

merge_insert_types:
      NO_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_merge_insert_types);
      }
    | FIRST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_merge_insert_types);
      }
    | LAST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_merge_insert_types);
      }
    ;

opt_select_from:
      opt_limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_opt_select_from);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | select_from select_lock_type
      {
        $$= mysql_parser::new_ast_node(sql::_opt_select_from);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

udf_type:
      STRING_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_udf_type);
      }
    | REAL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_udf_type);
      }
    | DECIMAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_udf_type);
      }
    | INT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_udf_type);
      }
    ;

field_list:
      field_list_item
      {
        $$= mysql_parser::new_ast_node(sql::_field_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | field_list ',' field_list_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_field_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

field_list_item:
      column_def
      {
        $$= mysql_parser::new_ast_node(sql::_field_list_item);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | key_def
      {
        $$= mysql_parser::new_ast_node(sql::_field_list_item);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

column_def:
      field_spec opt_check_constraint
      {
        $$= mysql_parser::new_ast_node(sql::_column_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | field_spec references
      {
        $$= mysql_parser::new_ast_node(sql::_column_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_def:
      key_type opt_ident key_alg '(' key_list ')' key_options
      {
        $$= mysql_parser::new_ast_node(sql::_key_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
        mysql_parser::add_ast_child_node($$, $7);
      }
    | opt_constraint constraint_key_type opt_ident key_alg '(' key_list ')' key_options
      {
        $$= mysql_parser::new_ast_node(sql::_key_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_40));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
        mysql_parser::add_ast_child_node($$, $8);
      }
    | opt_constraint FOREIGN KEY_SYM opt_ident '(' key_list ')' references
      {
        $$= mysql_parser::new_ast_node(sql::_key_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FOREIGN));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_KEY_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_40));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
        mysql_parser::add_ast_child_node($$, $8);
      }
    | constraint opt_check_constraint
      {
        $$= mysql_parser::new_ast_node(sql::_key_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | opt_constraint check_constraint
      {
        $$= mysql_parser::new_ast_node(sql::_key_def);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_check_constraint:
      /* empty */
      {
        $$= NULL;
      }
    | check_constraint
      {
        $$= mysql_parser::new_ast_node(sql::_opt_check_constraint);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

check_constraint:
      CHECK_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_check_constraint);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHECK_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_constraint:
      /* empty */
      {
        $$= NULL;
      }
    | constraint
      {
        $$= mysql_parser::new_ast_node(sql::_opt_constraint);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

constraint:
      CONSTRAINT opt_ident
      {
        $$= mysql_parser::new_ast_node(sql::_constraint);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONSTRAINT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

field_spec:
      field_ident type opt_attribute
      {
        $$= mysql_parser::new_ast_node(sql::_field_spec);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

type:
      int_type opt_len field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | real_type opt_precision field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | FLOAT_SYM float_options field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FLOAT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | BIT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BIT_SYM));
      }
    | BIT_SYM '(' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BIT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | BOOL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BOOL_SYM));
      }
    | BOOLEAN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BOOLEAN_SYM));
      }
    | char '(' NUM ')' opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | char opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | nchar '(' NUM ')' opt_bin_mod
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | nchar opt_bin_mod
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | BINARY '(' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINARY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | BINARY
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINARY));
      }
    | varchar '(' NUM ')' opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | nvarchar '(' NUM ')' opt_bin_mod
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | VARBINARY '(' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VARBINARY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | YEAR_SYM opt_len field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_YEAR_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | DATE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATE_SYM));
      }
    | TIME_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIME_SYM));
      }
    | TIMESTAMP opt_len
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIMESTAMP));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | DATETIME
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATETIME));
      }
    | TINYBLOB
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TINYBLOB));
      }
    | BLOB_SYM opt_len
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BLOB_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | spatial_type
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | MEDIUMBLOB
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MEDIUMBLOB));
      }
    | LONGBLOB
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LONGBLOB));
      }
    | LONG_SYM VARBINARY
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LONG_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VARBINARY));
      }
    | LONG_SYM varchar opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LONG_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | TINYTEXT opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TINYTEXT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | TEXT_SYM opt_len opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TEXT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MEDIUMTEXT opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MEDIUMTEXT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | LONGTEXT opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LONGTEXT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | DECIMAL_SYM float_options field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DECIMAL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | NUMERIC_SYM float_options field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NUMERIC_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | FIXED_SYM float_options field_options
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FIXED_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ENUM '(' string_list ')' opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | SET '(' string_list ')' opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | LONG_SYM opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LONG_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | SERIAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SERIAL_SYM));
      }
    ;

spatial_type:
      GEOMETRY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | GEOMETRYCOLLECTION
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | POINT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | MULTIPOINT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | LINESTRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | MULTILINESTRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | POLYGON
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    | MULTIPOLYGON
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_spatial_type);
      }
    ;

char:
      CHAR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_char);
      }
    ;

nchar:
      NCHAR_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_nchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NCHAR_SYM));
      }
    | NATIONAL_SYM CHAR_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_nchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NATIONAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CHAR_SYM));
      }
    ;

varchar:
      char VARYING
      {
        $$= mysql_parser::new_ast_node(sql::_varchar);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VARYING));
      }
    | VARCHAR
      {
        $$= mysql_parser::new_ast_node(sql::_varchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VARCHAR));
      }
    ;

nvarchar:
      NATIONAL_SYM VARCHAR
      {
        $$= mysql_parser::new_ast_node(sql::_nvarchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NATIONAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VARCHAR));
      }
    | NVARCHAR_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_nvarchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NVARCHAR_SYM));
      }
    | NCHAR_SYM VARCHAR
      {
        $$= mysql_parser::new_ast_node(sql::_nvarchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NCHAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VARCHAR));
      }
    | NATIONAL_SYM CHAR_SYM VARYING
      {
        $$= mysql_parser::new_ast_node(sql::_nvarchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NATIONAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CHAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_VARYING));
      }
    | NCHAR_SYM VARYING
      {
        $$= mysql_parser::new_ast_node(sql::_nvarchar);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NCHAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VARYING));
      }
    ;

int_type:
      INT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_int_type);
      }
    | TINYINT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_int_type);
      }
    | SMALLINT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_int_type);
      }
    | MEDIUMINT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_int_type);
      }
    | BIGINT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_int_type);
      }
    ;

real_type:
      REAL
      {
        $$= mysql_parser::new_ast_node(sql::_real_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REAL));
      }
    | DOUBLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_real_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DOUBLE_SYM));
      }
    | DOUBLE_SYM PRECISION
      {
        $$= mysql_parser::new_ast_node(sql::_real_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DOUBLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PRECISION));
      }
    ;

float_options:
      /* empty */
      {
        $$= NULL;
      }
    | '(' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_float_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | precision
      {
        $$= mysql_parser::new_ast_node(sql::_float_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

precision:
      '(' NUM ',' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_precision);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_44));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    ;

field_options:
      /* empty */
      {
        $$= NULL;
      }
    | field_opt_list
      {
        $$= mysql_parser::new_ast_node(sql::_field_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

field_opt_list:
      field_opt_list field_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_field_opt_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | field_option
      {
        $$= mysql_parser::new_ast_node(sql::_field_opt_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

field_option:
      SIGNED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_field_option);
      }
    | UNSIGNED
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_field_option);
      }
    | ZEROFILL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_field_option);
      }
    ;

opt_len:
      /* empty */
      {
        $$= NULL;
      }
    | '(' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_len);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

opt_precision:
      /* empty */
      {
        $$= NULL;
      }
    | precision
      {
        $$= mysql_parser::new_ast_node(sql::_opt_precision);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_attribute:
      /* empty */
      {
        $$= NULL;
      }
    | opt_attribute_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_attribute);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_attribute_list:
      opt_attribute_list attribute
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_opt_attribute_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | attribute
      {
        $$= mysql_parser::new_ast_node(sql::_opt_attribute_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

attribute:
      NULL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NULL_SYM));
      }
    | not NULL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NULL_SYM));
      }
    | DEFAULT now_or_signed_literal
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFAULT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | ON UPDATE_SYM NOW_SYM optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_UPDATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NOW_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | AUTO_INC
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AUTO_INC));
      }
    | SERIAL_SYM DEFAULT VALUE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SERIAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DEFAULT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_VALUE_SYM));
      }
    | opt_primary KEY_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_KEY_SYM));
      }
    | UNIQUE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNIQUE_SYM));
      }
    | UNIQUE_SYM KEY_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNIQUE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_KEY_SYM));
      }
    | COMMENT_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMENT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | COLLATE_SYM collation_name
      {
        $$= mysql_parser::new_ast_node(sql::_attribute);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COLLATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

now_or_signed_literal:
      NOW_SYM optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_now_or_signed_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NOW_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | signed_literal
      {
        $$= mysql_parser::new_ast_node(sql::_now_or_signed_literal);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

charset:
      CHAR_SYM SET
      {
        $$= mysql_parser::new_ast_node(sql::_charset);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SET));
      }
    | CHARSET
      {
        $$= mysql_parser::new_ast_node(sql::_charset);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHARSET));
      }
    ;

charset_name:
      ident_or_text
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_charset_name);
      }
    | BINARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_charset_name);
      }
    ;

charset_name_or_default:
      charset_name
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_charset_name_or_default);
      }
    | DEFAULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_charset_name_or_default);
      }
    ;

opt_load_data_charset:
      /* empty */
      {
        $$= NULL;
      }
    | charset charset_name_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_opt_load_data_charset);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

old_or_new_charset_name:
      ident_or_text
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_old_or_new_charset_name);
      }
    | BINARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_old_or_new_charset_name);
      }
    ;

old_or_new_charset_name_or_default:
      old_or_new_charset_name
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_old_or_new_charset_name_or_default);
      }
    | DEFAULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_old_or_new_charset_name_or_default);
      }
    ;

collation_name:
      ident_or_text
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_collation_name);
      }
    ;

opt_collate:
      /* empty */
      {
        $$= NULL;
      }
    | COLLATE_SYM collation_name_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_opt_collate);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COLLATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

collation_name_or_default:
      collation_name
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_collation_name_or_default);
      }
    | DEFAULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_collation_name_or_default);
      }
    ;

opt_default:
      /* empty */
      {
        $$= NULL;
      }
    | DEFAULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_default);
      }
    ;

opt_binary:
      /* empty */
      {
        $$= NULL;
      }
    | ASCII_SYM opt_bin_mod
      {
        $$= mysql_parser::new_ast_node(sql::_opt_binary);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ASCII_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | BYTE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_binary);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BYTE_SYM));
      }
    | UNICODE_SYM opt_bin_mod
      {
        $$= mysql_parser::new_ast_node(sql::_opt_binary);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNICODE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | charset charset_name opt_bin_mod
      {
        $$= mysql_parser::new_ast_node(sql::_opt_binary);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | BINARY opt_bin_charset
      {
        $$= mysql_parser::new_ast_node(sql::_opt_binary);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINARY));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_bin_mod:
      /* empty */
      {
        $$= NULL;
      }
    | BINARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_bin_mod);
      }
    ;

opt_bin_charset:
      /* empty */
      {
        $$= NULL;
      }
    | ASCII_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_bin_charset);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ASCII_SYM));
      }
    | UNICODE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_bin_charset);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNICODE_SYM));
      }
    | charset charset_name
      {
        $$= mysql_parser::new_ast_node(sql::_opt_bin_charset);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_primary:
      /* empty */
      {
        $$= NULL;
      }
    | PRIMARY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_primary);
      }
    ;

references:
      REFERENCES table_ident opt_ref_list
      {
        $$= mysql_parser::new_ast_node(sql::_references);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REFERENCES));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ref_list:
      opt_on_delete
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ref_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '(' ref_list ')' opt_on_delete
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ref_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

ref_list:
      ref_list ',' ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_ref_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ident
      {
        $$= mysql_parser::new_ast_node(sql::_ref_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_on_delete:
      /* empty */
      {
        $$= NULL;
      }
    | opt_on_delete_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_on_delete_list:
      opt_on_delete_list opt_on_delete_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_opt_on_delete_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | opt_on_delete_item
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_on_delete_item:
      ON DELETE_SYM delete_option
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DELETE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ON UPDATE_SYM delete_option
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_UPDATE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MATCH FULL
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MATCH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FULL));
      }
    | MATCH PARTIAL
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MATCH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTIAL));
      }
    | MATCH SIMPLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_on_delete_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MATCH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SIMPLE_SYM));
      }
    ;

delete_option:
      RESTRICT
      {
        $$= mysql_parser::new_ast_node(sql::_delete_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RESTRICT));
      }
    | CASCADE
      {
        $$= mysql_parser::new_ast_node(sql::_delete_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CASCADE));
      }
    | SET NULL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_delete_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NULL_SYM));
      }
    | NO_SYM ACTION
      {
        $$= mysql_parser::new_ast_node(sql::_delete_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NO_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ACTION));
      }
    | SET DEFAULT
      {
        $$= mysql_parser::new_ast_node(sql::_delete_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DEFAULT));
      }
    ;

key_type:
      key_or_index
      {
        $$= mysql_parser::new_ast_node(sql::_key_type);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | FULLTEXT_SYM opt_key_or_index
      {
        $$= mysql_parser::new_ast_node(sql::_key_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FULLTEXT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | SPATIAL_SYM opt_key_or_index
      {
        $$= mysql_parser::new_ast_node(sql::_key_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SPATIAL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

constraint_key_type:
      PRIMARY_SYM KEY_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_constraint_key_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PRIMARY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_KEY_SYM));
      }
    | UNIQUE_SYM opt_key_or_index
      {
        $$= mysql_parser::new_ast_node(sql::_constraint_key_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNIQUE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_or_index:
      KEY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_key_or_index);
      }
    | INDEX_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_key_or_index);
      }
    ;

opt_key_or_index:
      /* empty */
      {
        $$= NULL;
      }
    | key_or_index
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_key_or_index);
      }
    ;

keys_or_index:
      KEYS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keys_or_index);
      }
    | INDEX_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keys_or_index);
      }
    | INDEXES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keys_or_index);
      }
    ;

opt_unique_or_fulltext:
      /* empty */
      {
        $$= NULL;
      }
    | UNIQUE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_unique_or_fulltext);
      }
    | FULLTEXT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_unique_or_fulltext);
      }
    | SPATIAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_unique_or_fulltext);
      }
    ;

init_key_options:
      /* empty */
      {
        $$= NULL;
      }
    ;

key_alg:
      init_key_options
      {
        $$= mysql_parser::new_ast_node(sql::_key_alg);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | init_key_options key_using_alg
      {
        $$= mysql_parser::new_ast_node(sql::_key_alg);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_options:
      /* empty */
      {
        $$= NULL;
      }
    | key_opts
      {
        $$= mysql_parser::new_ast_node(sql::_key_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

key_opts:
      key_opt
      {
        $$= mysql_parser::new_ast_node(sql::_key_opts);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | key_opts key_opt
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_key_opts);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_using_alg:
      USING btree_or_rtree
      {
        $$= mysql_parser::new_ast_node(sql::_key_using_alg);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USING));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | TYPE_SYM btree_or_rtree
      {
        $$= mysql_parser::new_ast_node(sql::_key_using_alg);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TYPE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_opt:
      key_using_alg
      {
        $$= mysql_parser::new_ast_node(sql::_key_opt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | KEY_BLOCK_SIZE opt_equal ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_key_opt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_KEY_BLOCK_SIZE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | WITH PARSER_SYM IDENT_sys
      {
        $$= mysql_parser::new_ast_node(sql::_key_opt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARSER_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

btree_or_rtree:
      BTREE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_btree_or_rtree);
      }
    | RTREE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_btree_or_rtree);
      }
    | HASH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_btree_or_rtree);
      }
    ;

key_list:
      key_list ',' key_part order_dir
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_key_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | key_part order_dir
      {
        $$= mysql_parser::new_ast_node(sql::_key_list);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_part:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_key_part);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident '(' NUM ')'
      {
        $$= mysql_parser::new_ast_node(sql::_key_part);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

opt_ident:
      /* empty */
      {
        $$= NULL;
      }
    | field_ident
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_component:
      /* empty */
      {
        $$= NULL;
      }
    | '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_opt_component);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_46));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

string_list:
      text_string
      {
        $$= mysql_parser::new_ast_node(sql::_string_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | string_list ',' text_string
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_string_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

alter:
      ALTER opt_ignore TABLE_SYM table_ident alter_commands
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | ALTER DATABASE ident_or_empty create_database_options
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ALTER DATABASE ident UPGRADE_SYM DATA_SYM DIRECTORY_SYM NAME_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_UPGRADE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_DATA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_DIRECTORY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_NAME_SYM));
      }
    | ALTER PROCEDURE sp_name sp_a_chistics
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ALTER FUNCTION_SYM sp_name sp_a_chistics
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ALTER view_algorithm definer_opt view_tail
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ALTER definer_opt view_tail
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ALTER definer_opt EVENT_SYM sp_name ev_alter_on_schedule_completion opt_ev_rename_to opt_ev_status opt_ev_comment opt_ev_sql_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_EVENT_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, $9);
      }
    | ALTER TABLESPACE alter_tablespace_info
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ALTER LOGFILE_SYM GROUP_SYM alter_logfile_group_info
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOGFILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_GROUP_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ALTER TABLESPACE change_tablespace_info
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ALTER TABLESPACE change_tablespace_access
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ALTER SERVER_SYM ident_or_text OPTIONS_SYM '(' server_options_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_alter);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SERVER_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_OPTIONS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_40));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    ;

ev_alter_on_schedule_completion:
      /* empty */
      {
        $$= NULL;
      }
    | ON SCHEDULE_SYM ev_schedule_time
      {
        $$= mysql_parser::new_ast_node(sql::_ev_alter_on_schedule_completion);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SCHEDULE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ev_on_completion
      {
        $$= mysql_parser::new_ast_node(sql::_ev_alter_on_schedule_completion);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ON SCHEDULE_SYM ev_schedule_time ev_on_completion
      {
        $$= mysql_parser::new_ast_node(sql::_ev_alter_on_schedule_completion);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SCHEDULE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_ev_rename_to:
      /* empty */
      {
        $$= NULL;
      }
    | RENAME TO_SYM sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_rename_to);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RENAME));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ev_sql_stmt:
      /* empty */
      {
        $$= NULL;
      }
    | DO_SYM ev_sql_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ev_sql_stmt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DO_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

ident_or_empty:
      /* empty */
      {
        $$= NULL;
      }
    | ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident_or_empty);
      }
    ;

alter_commands:
      /* empty */
      {
        $$= NULL;
      }
    | DISCARD TABLESPACE
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DISCARD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
      }
    | IMPORT TABLESPACE
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IMPORT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
      }
    | alter_list opt_partitioning
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | alter_list remove_partitioning
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | remove_partitioning
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | partitioning
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | add_partition_rule
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | DROP PARTITION_SYM alt_part_name_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | REBUILD_SYM PARTITION_SYM opt_no_write_to_binlog all_or_alt_part_name_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REBUILD_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | OPTIMIZE PARTITION_SYM opt_no_write_to_binlog all_or_alt_part_name_list opt_no_write_to_binlog
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OPTIMIZE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | ANALYZE_SYM PARTITION_SYM opt_no_write_to_binlog all_or_alt_part_name_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ANALYZE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | CHECK_SYM PARTITION_SYM all_or_alt_part_name_list opt_mi_check_type
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHECK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | REPAIR PARTITION_SYM opt_no_write_to_binlog all_or_alt_part_name_list opt_mi_repair_type
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPAIR));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | COALESCE PARTITION_SYM opt_no_write_to_binlog real_ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COALESCE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | reorg_partition_rule
      {
        $$= mysql_parser::new_ast_node(sql::_alter_commands);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

remove_partitioning:
      REMOVE_SYM PARTITIONING_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_remove_partitioning);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REMOVE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITIONING_SYM));
      }
    ;

all_or_alt_part_name_list:
      ALL
      {
        $$= mysql_parser::new_ast_node(sql::_all_or_alt_part_name_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALL));
      }
    | alt_part_name_list
      {
        $$= mysql_parser::new_ast_node(sql::_all_or_alt_part_name_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

add_partition_rule:
      ADD PARTITION_SYM opt_no_write_to_binlog add_part_extra
      {
        $$= mysql_parser::new_ast_node(sql::_add_partition_rule);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

add_part_extra:
      /* empty */
      {
        $$= NULL;
      }
    | '(' part_def_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_add_part_extra);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | PARTITIONS_SYM real_ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_add_part_extra);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PARTITIONS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

reorg_partition_rule:
      REORGANIZE_SYM PARTITION_SYM opt_no_write_to_binlog reorg_parts_rule
      {
        $$= mysql_parser::new_ast_node(sql::_reorg_partition_rule);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REORGANIZE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PARTITION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

reorg_parts_rule:
      /* empty */
      {
        $$= NULL;
      }
    | alt_part_name_list INTO '(' part_def_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_reorg_parts_rule);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_INTO));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    ;

alt_part_name_list:
      alt_part_name_item
      {
        $$= mysql_parser::new_ast_node(sql::_alt_part_name_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | alt_part_name_list ',' alt_part_name_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alt_part_name_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

alt_part_name_item:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_alt_part_name_item);
      }
    ;

alter_list:
      alter_list_item
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | alter_list ',' alter_list_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alter_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

add_column:
      ADD opt_column
      {
        $$= mysql_parser::new_ast_node(sql::_add_column);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADD));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

alter_list_item:
      add_column column_def opt_place
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ADD key_def
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADD));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | add_column '(' field_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | CHANGE opt_column field_ident field_spec opt_place
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHANGE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | MODIFY_SYM opt_column field_ident type opt_attribute opt_place
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MODIFY_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | DROP opt_column field_ident opt_restrict
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP FOREIGN KEY_SYM opt_ident
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FOREIGN));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_KEY_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP PRIMARY_SYM KEY_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PRIMARY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_KEY_SYM));
      }
    | DROP key_or_index field_ident
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | DISABLE_SYM KEYS
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DISABLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_KEYS));
      }
    | ENABLE_SYM KEYS
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENABLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_KEYS));
      }
    | ALTER opt_column field_ident SET DEFAULT signed_literal
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_SET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_DEFAULT));
        mysql_parser::add_ast_child_node($$, $6);
      }
    | ALTER opt_column field_ident DROP DEFAULT
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_DEFAULT));
      }
    | RENAME opt_to table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RENAME));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CONVERT_SYM TO_SYM charset charset_name_or_default opt_collate
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONVERT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | create_table_options_space_separated
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | FORCE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FORCE_SYM));
      }
    | alter_order_clause
      {
        $$= mysql_parser::new_ast_node(sql::_alter_list_item);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_column:
      /* empty */
      {
        $$= NULL;
      }
    | COLUMN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_column);
      }
    ;

opt_ignore:
      /* empty */
      {
        $$= NULL;
      }
    | IGNORE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_ignore);
      }
    ;

opt_restrict:
      /* empty */
      {
        $$= NULL;
      }
    | RESTRICT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_restrict);
      }
    | CASCADE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_restrict);
      }
    ;

opt_place:
      /* empty */
      {
        $$= NULL;
      }
    | AFTER_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_opt_place);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AFTER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | FIRST_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_place);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FIRST_SYM));
      }
    ;

opt_to:
      /* empty */
      {
        $$= NULL;
      }
    | TO_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_to);
      }
    | EQ
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_to);
      }
    | AS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_to);
      }
    ;

slave:
      START_SYM SLAVE slave_thread_opts slave_until
      {
        $$= mysql_parser::new_ast_node(sql::_slave);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_START_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | STOP_SYM SLAVE slave_thread_opts
      {
        $$= mysql_parser::new_ast_node(sql::_slave);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STOP_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | SLAVE START_SYM slave_thread_opts slave_until
      {
        $$= mysql_parser::new_ast_node(sql::_slave);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_START_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | SLAVE STOP_SYM slave_thread_opts
      {
        $$= mysql_parser::new_ast_node(sql::_slave);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STOP_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

start:
      START_SYM TRANSACTION_SYM start_transaction_opts
      {
        $$= mysql_parser::new_ast_node(sql::_start);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_START_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TRANSACTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

start_transaction_opts:
      /* empty */
      {
        $$= NULL;
      }
    | WITH CONSISTENT_SYM SNAPSHOT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_start_transaction_opts);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CONSISTENT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_SNAPSHOT_SYM));
      }
    ;

slave_thread_opts:
      slave_thread_opt_list
      {
        $$= mysql_parser::new_ast_node(sql::_slave_thread_opts);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

slave_thread_opt_list:
      slave_thread_opt
      {
        $$= mysql_parser::new_ast_node(sql::_slave_thread_opt_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | slave_thread_opt_list ',' slave_thread_opt
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_slave_thread_opt_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

slave_thread_opt:
      /* empty */
      {
        $$= NULL;
      }
    | SQL_THREAD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_slave_thread_opt);
      }
    | RELAY_THREAD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_slave_thread_opt);
      }
    ;

slave_until:
      /* empty */
      {
        $$= NULL;
      }
    | UNTIL_SYM slave_until_opts
      {
        $$= mysql_parser::new_ast_node(sql::_slave_until);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNTIL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

slave_until_opts:
      master_file_def
      {
        $$= mysql_parser::new_ast_node(sql::_slave_until_opts);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | slave_until_opts ',' master_file_def
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_slave_until_opts);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

restore:
      RESTORE_SYM table_or_tables table_list FROM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_restore);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RESTORE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

backup:
      BACKUP_SYM table_or_tables table_list TO_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_backup);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BACKUP_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

checksum:
      CHECKSUM_SYM table_or_tables table_list opt_checksum_type
      {
        $$= mysql_parser::new_ast_node(sql::_checksum);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHECKSUM_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_checksum_type:
      /* empty */
      {
        $$= NULL;
      }
    | QUICK
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_checksum_type);
      }
    | EXTENDED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_checksum_type);
      }
    ;

repair:
      REPAIR opt_no_write_to_binlog table_or_tables table_list opt_mi_repair_type
      {
        $$= mysql_parser::new_ast_node(sql::_repair);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPAIR));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

opt_mi_repair_type:
      /* empty */
      {
        $$= NULL;
      }
    | mi_repair_types
      {
        $$= mysql_parser::new_ast_node(sql::_opt_mi_repair_type);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

mi_repair_types:
      mi_repair_type
      {
        $$= mysql_parser::new_ast_node(sql::_mi_repair_types);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | mi_repair_type mi_repair_types
      {
        $$= mysql_parser::new_ast_node(sql::_mi_repair_types);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    ;

mi_repair_type:
      QUICK
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_mi_repair_type);
      }
    | EXTENDED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_mi_repair_type);
      }
    | USE_FRM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_mi_repair_type);
      }
    ;

analyze:
      ANALYZE_SYM opt_no_write_to_binlog table_or_tables table_list
      {
        $$= mysql_parser::new_ast_node(sql::_analyze);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ANALYZE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

binlog_base64_event:
      BINLOG_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_binlog_base64_event);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINLOG_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

check:
      CHECK_SYM table_or_tables table_list opt_mi_check_type
      {
        $$= mysql_parser::new_ast_node(sql::_check);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHECK_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_mi_check_type:
      /* empty */
      {
        $$= NULL;
      }
    | mi_check_types
      {
        $$= mysql_parser::new_ast_node(sql::_opt_mi_check_type);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

mi_check_types:
      mi_check_type
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_types);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | mi_check_type mi_check_types
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_types);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    ;

mi_check_type:
      QUICK
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_QUICK));
      }
    | FAST_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FAST_SYM));
      }
    | MEDIUM_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MEDIUM_SYM));
      }
    | EXTENDED_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EXTENDED_SYM));
      }
    | CHANGED
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHANGED));
      }
    | FOR_SYM UPGRADE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_mi_check_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_UPGRADE_SYM));
      }
    ;

optimize:
      OPTIMIZE opt_no_write_to_binlog table_or_tables table_list
      {
        $$= mysql_parser::new_ast_node(sql::_optimize);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OPTIMIZE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_no_write_to_binlog:
      /* empty */
      {
        $$= NULL;
      }
    | NO_WRITE_TO_BINLOG
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_no_write_to_binlog);
      }
    | LOCAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_no_write_to_binlog);
      }
    ;

rename:
      RENAME table_or_tables table_to_table_list
      {
        $$= mysql_parser::new_ast_node(sql::_rename);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RENAME));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | RENAME USER clear_privileges rename_list
      {
        $$= mysql_parser::new_ast_node(sql::_rename);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RENAME));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_USER));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

rename_list:
      user TO_SYM user
      {
        $$= mysql_parser::new_ast_node(sql::_rename_list);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | rename_list ',' user TO_SYM user
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_rename_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

table_to_table_list:
      table_to_table
      {
        $$= mysql_parser::new_ast_node(sql::_table_to_table_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_to_table_list ',' table_to_table
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_table_to_table_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

table_to_table:
      table_ident TO_SYM table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_table_to_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

keycache:
      CACHE_SYM INDEX_SYM keycache_list IN_SYM key_cache_name
      {
        $$= mysql_parser::new_ast_node(sql::_keycache);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CACHE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_INDEX_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

keycache_list:
      assign_to_keycache
      {
        $$= mysql_parser::new_ast_node(sql::_keycache_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | keycache_list ',' assign_to_keycache
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_keycache_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

assign_to_keycache:
      table_ident cache_keys_spec
      {
        $$= mysql_parser::new_ast_node(sql::_assign_to_keycache);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

key_cache_name:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_key_cache_name);
      }
    | DEFAULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_key_cache_name);
      }
    ;

preload:
      LOAD INDEX_SYM INTO CACHE_SYM preload_list
      {
        $$= mysql_parser::new_ast_node(sql::_preload);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOAD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_INDEX_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INTO));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_CACHE_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

preload_list:
      preload_keys
      {
        $$= mysql_parser::new_ast_node(sql::_preload_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | preload_list ',' preload_keys
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_preload_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

preload_keys:
      table_ident cache_keys_spec opt_ignore_leaves
      {
        $$= mysql_parser::new_ast_node(sql::_preload_keys);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

cache_keys_spec:
      cache_key_list_or_empty
      {
        $$= mysql_parser::new_ast_node(sql::_cache_keys_spec);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

cache_key_list_or_empty:
      /* empty */
      {
        $$= NULL;
      }
    | key_or_index '(' opt_key_usage_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_cache_key_list_or_empty);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

opt_ignore_leaves:
      /* empty */
      {
        $$= NULL;
      }
    | IGNORE_SYM LEAVES
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ignore_leaves);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IGNORE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LEAVES));
      }
    ;

select:
      select_init
      {
        $$= mysql_parser::new_ast_node(sql::_select);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

select_init:
      SELECT_SYM select_init2
      {
        $$= mysql_parser::new_ast_node(sql::_select_init);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SELECT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | '(' select_paren ')' union_opt
      {
        $$= mysql_parser::new_ast_node(sql::_select_init);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

select_paren:
      SELECT_SYM select_part2
      {
        $$= mysql_parser::new_ast_node(sql::_select_paren);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SELECT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | '(' select_paren ')'
      {
        $$= mysql_parser::new_ast_node(sql::_select_paren);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

select_init2:
      select_part2 union_clause
      {
        $$= mysql_parser::new_ast_node(sql::_select_init2);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

select_part2:
      select_options select_item_list select_into select_lock_type
      {
        $$= mysql_parser::new_ast_node(sql::_select_part2);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

select_into:
      opt_order_clause opt_limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_select_into);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | into
      {
        $$= mysql_parser::new_ast_node(sql::_select_into);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | select_from
      {
        $$= mysql_parser::new_ast_node(sql::_select_into);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | into select_from
      {
        $$= mysql_parser::new_ast_node(sql::_select_into);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | select_from into
      {
        $$= mysql_parser::new_ast_node(sql::_select_into);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

select_from:
      FROM join_table_list where_clause group_clause having_clause opt_order_clause opt_limit_clause procedure_clause
      {
        $$= mysql_parser::new_ast_node(sql::_select_from);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
      }
    | FROM DUAL_SYM where_clause opt_limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_select_from);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DUAL_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

select_options:
      /* empty */
      {
        $$= NULL;
      }
    | select_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_select_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

select_option_list:
      select_option_list select_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_select_option_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | select_option
      {
        $$= mysql_parser::new_ast_node(sql::_select_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

select_option:
      STRAIGHT_JOIN
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | HIGH_PRIORITY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | DISTINCT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | SQL_SMALL_RESULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | SQL_BIG_RESULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | SQL_BUFFER_RESULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | SQL_CALC_FOUND_ROWS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | SQL_NO_CACHE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | SQL_CACHE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    | ALL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_option);
      }
    ;

select_lock_type:
      /* empty */
      {
        $$= NULL;
      }
    | FOR_SYM UPDATE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_select_lock_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_UPDATE_SYM));
      }
    | LOCK_SYM IN_SYM SHARE_SYM MODE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_select_lock_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOCK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_SHARE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_MODE_SYM));
      }
    ;

select_item_list:
      select_item_list ',' select_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_select_item_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | select_item
      {
        $$= mysql_parser::new_ast_node(sql::_select_item_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '*'
      {
        $$= mysql_parser::new_ast_node(sql::_select_item_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_42));
      }
    ;

select_item:
      remember_name select_item2 remember_end select_alias
      {
        $$= mysql_parser::new_ast_node(sql::_select_item);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

remember_name:
      /* empty */
      {
        $$= NULL;
      }
    ;

remember_end:
      /* empty */
      {
        $$= NULL;
      }
    ;

select_item2:
      table_wild
      {
        $$= mysql_parser::new_ast_node(sql::_select_item2);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | expr
      {
        $$= mysql_parser::new_ast_node(sql::_select_item2);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

select_alias:
      /* empty */
      {
        $$= NULL;
      }
    | AS ident
      {
        $$= mysql_parser::new_ast_node(sql::_select_alias);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AS));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | AS TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_select_alias);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AS));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | ident
      {
        $$= mysql_parser::new_ast_node(sql::_select_alias);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_select_alias);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

optional_braces:
      /* empty */
      {
        $$= NULL;
      }
    | '(' ')'
      {
        $$= mysql_parser::new_ast_node(sql::_optional_braces);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_41));
      }
    ;

expr:
      expr or expr %prec OR_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | expr XOR expr %prec XOR
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_XOR));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | expr and expr %prec AND_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | NOT_SYM expr %prec NOT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NOT_SYM));
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | bool_pri IS TRUE_SYM %prec IS
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TRUE_SYM));
      }
    | bool_pri IS not TRUE_SYM %prec IS
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_TRUE_SYM));
      }
    | bool_pri IS FALSE_SYM %prec IS
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FALSE_SYM));
      }
    | bool_pri IS not FALSE_SYM %prec IS
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FALSE_SYM));
      }
    | bool_pri IS UNKNOWN_SYM %prec IS
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_UNKNOWN_SYM));
      }
    | bool_pri IS not UNKNOWN_SYM %prec IS
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_UNKNOWN_SYM));
      }
    | bool_pri
      {
        $$= mysql_parser::new_ast_node(sql::_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

bool_pri:
      bool_pri IS NULL_SYM %prec IS
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bool_pri);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_NULL_SYM));
      }
    | bool_pri IS not NULL_SYM %prec IS
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bool_pri);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IS));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_NULL_SYM));
      }
    | bool_pri EQUAL_SYM predicate %prec EQUAL_SYM
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bool_pri);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQUAL_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bool_pri comp_op predicate %prec EQ
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bool_pri);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bool_pri comp_op all_or_any '(' subselect ')' %prec EQ
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bool_pri);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | predicate
      {
        $$= mysql_parser::new_ast_node(sql::_bool_pri);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

predicate:
      bit_expr IN_SYM '(' subselect ')'
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | bit_expr not IN_SYM '(' subselect ')'
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | bit_expr IN_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | bit_expr IN_SYM '(' expr ',' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_44));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    | bit_expr not IN_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | bit_expr not IN_SYM '(' expr ',' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | bit_expr BETWEEN_SYM bit_expr AND_SYM predicate
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BETWEEN_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_AND_SYM));
        mysql_parser::merge_ast_child_nodes($$, $5);
      }
    | bit_expr not BETWEEN_SYM bit_expr AND_SYM predicate
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BETWEEN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_AND_SYM));
        mysql_parser::merge_ast_child_nodes($$, $6);
      }
    | bit_expr SOUNDS_SYM LIKE bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SOUNDS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LIKE));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | bit_expr LIKE simple_expr opt_escape
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LIKE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | bit_expr not LIKE simple_expr opt_escape
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LIKE));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | bit_expr REGEXP bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_REGEXP));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr not REGEXP bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_REGEXP));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_predicate);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

bit_expr:
      bit_expr '|' bit_expr %prec '|'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_124));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '&' bit_expr %prec '&'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_38));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr SHIFT_LEFT bit_expr %prec SHIFT_LEFT
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SHIFT_LEFT));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr SHIFT_RIGHT bit_expr %prec SHIFT_RIGHT
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SHIFT_RIGHT));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '+' bit_expr %prec '+'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_43));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '-' bit_expr %prec '-'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_45));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '+' INTERVAL_SYM expr interval %prec '+'
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_43));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | bit_expr '-' INTERVAL_SYM expr interval %prec '-'
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_45));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | bit_expr '*' bit_expr %prec '*'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_42));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '/' bit_expr %prec '/'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_47));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '%' bit_expr %prec '%'
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_37));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr DIV_SYM bit_expr %prec DIV_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DIV_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr MOD_SYM bit_expr %prec MOD_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MOD_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | bit_expr '^' bit_expr
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_94));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | simple_expr
      {
        $$= mysql_parser::new_ast_node(sql::_bit_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

or:
      OR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_or);
      }
    | OR2_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_or);
      }
    ;

and:
      AND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_and);
      }
    | AND_AND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_and);
      }
    ;

not:
      NOT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_not);
      }
    | NOT2_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_not);
      }
    ;

not2:
      '!'
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_not2);
      }
    | NOT2_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_not2);
      }
    ;

comp_op:
      EQ
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_comp_op);
      }
    | GE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_comp_op);
      }
    | GT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_comp_op);
      }
    | LE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_comp_op);
      }
    | LT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_comp_op);
      }
    | NE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_comp_op);
      }
    ;

all_or_any:
      ALL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_all_or_any);
      }
    | ANY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_all_or_any);
      }
    ;

simple_expr:
      simple_ident
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | function_call_keyword
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | function_call_nonkeyword
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | function_call_generic
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | function_call_conflict
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | simple_expr COLLATE_SYM ident_or_text %prec NEG
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COLLATE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | literal
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | param_marker
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | variable
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sum_expr
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | simple_expr OR_OR_SYM simple_expr
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_OR_OR_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '+' simple_expr %prec NEG
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_43));
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | '-' simple_expr %prec NEG
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_45));
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | '~' simple_expr %prec NEG
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_126));
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | not2 simple_expr %prec NEG
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | '(' subselect ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | '(' expr ',' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_44));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | ROW_SYM '(' expr ',' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ROW_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | EXISTS '(' subselect ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EXISTS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | '{' ident expr '}'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_123));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_125));
      }
    | MATCH ident_list_arg AGAINST '(' bit_expr fulltext_options ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MATCH));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_AGAINST));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    | BINARY simple_expr %prec NEG
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINARY));
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    | CAST_SYM '(' expr AS cast_type ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CAST_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_AS));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | CASE_SYM opt_expr when_list opt_else END
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CASE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_END));
      }
    | CONVERT_SYM '(' expr ',' cast_type ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONVERT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | CONVERT_SYM '(' expr USING charset_name ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONVERT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_USING));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | DEFAULT '(' simple_ident ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFAULT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | VALUES '(' simple_ident_nospvar ')'
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VALUES));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | INTERVAL_SYM expr interval '+' expr %prec INTERVAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_simple_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_43));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

function_call_keyword:
      CHAR_SYM '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | CHAR_SYM '(' expr_list USING charset_name ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_USING));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | CURRENT_USER optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CURRENT_USER));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | DATE_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | DAY_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DAY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | HOUR_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HOUR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | INSERT '(' expr ',' expr ',' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INSERT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_44));
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($10, sql::_41));
      }
    | INTERVAL_SYM '(' expr ',' expr ')' %prec INTERVAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | INTERVAL_SYM '(' expr ',' expr ',' expr_list ')' %prec INTERVAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | LEFT '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LEFT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | MINUTE_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MINUTE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MONTH_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MONTH_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | RIGHT '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RIGHT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | SECOND_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SECOND_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | TIME_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIME_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | TIMESTAMP '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIMESTAMP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | TIMESTAMP '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIMESTAMP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | TRIM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | TRIM '(' LEADING expr FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LEADING));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    | TRIM '(' TRAILING expr FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TRAILING));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    | TRIM '(' BOTH expr FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BOTH));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    | TRIM '(' LEADING FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LEADING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | TRIM '(' TRAILING FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TRAILING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | TRIM '(' BOTH FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BOTH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | TRIM '(' expr FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | USER '(' ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | YEAR_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_keyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_YEAR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

function_call_nonkeyword:
      ADDDATE_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADDDATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | ADDDATE_SYM '(' expr ',' INTERVAL_SYM expr interval ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ADDDATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | CURDATE optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CURDATE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | CURTIME optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CURTIME));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | CURTIME '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CURTIME));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | DATE_ADD_INTERVAL '(' expr ',' INTERVAL_SYM expr interval ')' %prec INTERVAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATE_ADD_INTERVAL));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | DATE_SUB_INTERVAL '(' expr ',' INTERVAL_SYM expr interval ')' %prec INTERVAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATE_SUB_INTERVAL));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | EXTRACT_SYM '(' interval FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EXTRACT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | GET_FORMAT '(' date_time_type ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GET_FORMAT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | NOW_SYM optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NOW_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | NOW_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NOW_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | POSITION_SYM '(' bit_expr IN_SYM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_POSITION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | SUBDATE_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBDATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | SUBDATE_SYM '(' expr ',' INTERVAL_SYM expr interval ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBDATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_INTERVAL_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | SUBSTRING '(' expr ',' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBSTRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | SUBSTRING '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBSTRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | SUBSTRING '(' expr FROM expr FOR_SYM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBSTRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | SUBSTRING '(' expr FROM expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBSTRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | SYSDATE optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SYSDATE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | SYSDATE '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SYSDATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | TIMESTAMP_ADD '(' interval_time_st ',' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIMESTAMP_ADD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | TIMESTAMP_DIFF '(' interval_time_st ',' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIMESTAMP_DIFF));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | UTC_DATE_SYM optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UTC_DATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | UTC_TIME_SYM optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UTC_TIME_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | UTC_TIMESTAMP_SYM optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_nonkeyword);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UTC_TIMESTAMP_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

function_call_conflict:
      ASCII_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ASCII_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | CHARSET '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHARSET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | COALESCE '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COALESCE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | COLLATION_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COLLATION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | DATABASE '(' ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | IF '(' expr ',' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IF));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | MICROSECOND_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MICROSECOND_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MOD_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MOD_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | OLD_PASSWORD '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OLD_PASSWORD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | PASSWORD '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | QUARTER_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_QUARTER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | REPEAT_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPEAT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | REPLACE '(' expr ',' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPLACE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_44));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_41));
      }
    | TRUNCATE_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRUNCATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | WEEK_SYM '(' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WEEK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | WEEK_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WEEK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | geometry_function
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_conflict);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

geometry_function:
      CONTAINS_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONTAINS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | GEOMETRYCOLLECTION '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GEOMETRYCOLLECTION));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | LINESTRING '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LINESTRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MULTILINESTRING '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MULTILINESTRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MULTIPOINT '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MULTIPOINT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MULTIPOLYGON '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MULTIPOLYGON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | POINT_SYM '(' expr ',' expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_POINT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | POLYGON '(' expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_geometry_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_POLYGON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

function_call_generic:
      IDENT_sys '(' opt_udf_expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_generic);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | ident '.' ident '(' opt_expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_function_call_generic);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    ;

fulltext_options:
      opt_natural_language_mode opt_query_expansion
      {
        $$= mysql_parser::new_ast_node(sql::_fulltext_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | IN_SYM BOOLEAN_SYM MODE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_fulltext_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BOOLEAN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_MODE_SYM));
      }
    ;

opt_natural_language_mode:
      /* empty */
      {
        $$= NULL;
      }
    | IN_SYM NATURAL LANGUAGE_SYM MODE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_natural_language_mode);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NATURAL));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LANGUAGE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_MODE_SYM));
      }
    ;

opt_query_expansion:
      /* empty */
      {
        $$= NULL;
      }
    | WITH QUERY_SYM EXPANSION_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_query_expansion);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_QUERY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_EXPANSION_SYM));
      }
    ;

opt_udf_expr_list:
      /* empty */
      {
        $$= NULL;
      }
    | udf_expr_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_udf_expr_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

udf_expr_list:
      udf_expr
      {
        $$= mysql_parser::new_ast_node(sql::_udf_expr_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | udf_expr_list ',' udf_expr
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_udf_expr_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

udf_expr:
      remember_name expr remember_end select_alias
      {
        $$= mysql_parser::new_ast_node(sql::_udf_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

sum_expr:
      AVG_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AVG_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | AVG_SYM '(' DISTINCT in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AVG_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DISTINCT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | BIT_AND '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BIT_AND));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | BIT_OR '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BIT_OR));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | BIT_XOR '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BIT_XOR));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | COUNT_SYM '(' opt_all '*' ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COUNT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_42));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | COUNT_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COUNT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | COUNT_SYM '(' DISTINCT expr_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COUNT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DISTINCT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | MIN_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MIN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MIN_SYM '(' DISTINCT in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MIN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DISTINCT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | MAX_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | MAX_SYM '(' DISTINCT in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DISTINCT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | STD_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STD_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | VARIANCE_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VARIANCE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | STDDEV_SAMP_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STDDEV_SAMP_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | VAR_SAMP_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VAR_SAMP_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | SUM_SYM '(' in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUM_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | SUM_SYM '(' DISTINCT in_sum_expr ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUM_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DISTINCT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    | GROUP_CONCAT_SYM '(' opt_distinct expr_list opt_gorder_clause opt_gconcat_separator ')'
      {
        $$= mysql_parser::new_ast_node(sql::_sum_expr);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GROUP_CONCAT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    ;

variable:
      '@' variable_aux
      {
        $$= mysql_parser::new_ast_node(sql::_variable);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

variable_aux:
      ident_or_text SET_VAR expr
      {
        $$= mysql_parser::new_ast_node(sql::_variable_aux);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SET_VAR));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_variable_aux);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '@' opt_var_ident_type ident_or_text opt_component
      {
        $$= mysql_parser::new_ast_node(sql::_variable_aux);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

opt_distinct:
      /* empty */
      {
        $$= NULL;
      }
    | DISTINCT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_distinct);
      }
    ;

opt_gconcat_separator:
      /* empty */
      {
        $$= NULL;
      }
    | SEPARATOR_SYM text_string
      {
        $$= mysql_parser::new_ast_node(sql::_opt_gconcat_separator);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SEPARATOR_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_gorder_clause:
      /* empty */
      {
        $$= NULL;
      }
    | order_clause
      {
        $$= mysql_parser::new_ast_node(sql::_opt_gorder_clause);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

in_sum_expr:
      opt_all expr
      {
        $$= mysql_parser::new_ast_node(sql::_in_sum_expr);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

cast_type:
      BINARY opt_len
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINARY));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | CHAR_SYM opt_len opt_binary
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CHAR_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | NCHAR_SYM opt_len
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NCHAR_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | SIGNED_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SIGNED_SYM));
      }
    | SIGNED_SYM INT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SIGNED_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_INT_SYM));
      }
    | UNSIGNED
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNSIGNED));
      }
    | UNSIGNED INT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNSIGNED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_INT_SYM));
      }
    | DATE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATE_SYM));
      }
    | TIME_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIME_SYM));
      }
    | DATETIME
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATETIME));
      }
    | DECIMAL_SYM float_options
      {
        $$= mysql_parser::new_ast_node(sql::_cast_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DECIMAL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_expr_list:
      /* empty */
      {
        $$= NULL;
      }
    | expr_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_expr_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

expr_list:
      expr
      {
        $$= mysql_parser::new_ast_node(sql::_expr_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | expr_list ',' expr
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_expr_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

ident_list_arg:
      ident_list
      {
        $$= mysql_parser::new_ast_node(sql::_ident_list_arg);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '(' ident_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_ident_list_arg);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

ident_list:
      simple_ident
      {
        $$= mysql_parser::new_ast_node(sql::_ident_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident_list ',' simple_ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_ident_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_expr:
      /* empty */
      {
        $$= NULL;
      }
    | expr
      {
        $$= mysql_parser::new_ast_node(sql::_opt_expr);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_else:
      /* empty */
      {
        $$= NULL;
      }
    | ELSE expr
      {
        $$= mysql_parser::new_ast_node(sql::_opt_else);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ELSE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

when_list:
      WHEN_SYM expr THEN_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_when_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WHEN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_THEN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | when_list WHEN_SYM expr THEN_SYM expr
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_when_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_WHEN_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_THEN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

table_ref:
      table_factor
      {
        $$= mysql_parser::new_ast_node(sql::_table_ref);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | join_table
      {
        $$= mysql_parser::new_ast_node(sql::_table_ref);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

join_table_list:
      derived_table_list
      {
        $$= mysql_parser::new_ast_node(sql::_join_table_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

derived_table_list:
      table_ref
      {
        $$= mysql_parser::new_ast_node(sql::_derived_table_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | derived_table_list ',' table_ref
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_derived_table_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

join_table:
      table_ref normal_join table_ref %prec TABLE_REF_PRIORITY
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | table_ref STRAIGHT_JOIN table_factor
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STRAIGHT_JOIN));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | table_ref normal_join table_ref ON expr
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_ON));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | table_ref STRAIGHT_JOIN table_factor ON expr
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STRAIGHT_JOIN));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_ON));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | table_ref normal_join table_ref USING '(' using_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_USING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_40));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_41));
      }
    | table_ref NATURAL JOIN_SYM table_factor
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NATURAL));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | table_ref LEFT opt_outer JOIN_SYM table_ref ON expr
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LEFT));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_ON));
        mysql_parser::add_ast_child_node($$, $7);
      }
    | table_ref LEFT opt_outer JOIN_SYM table_factor USING '(' using_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LEFT));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_USING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_40));
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($9, sql::_41));
      }
    | table_ref NATURAL LEFT opt_outer JOIN_SYM table_factor
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NATURAL));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LEFT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $6);
      }
    | table_ref RIGHT opt_outer JOIN_SYM table_ref ON expr
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_RIGHT));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_ON));
        mysql_parser::add_ast_child_node($$, $7);
      }
    | table_ref RIGHT opt_outer JOIN_SYM table_factor USING '(' using_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_RIGHT));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_USING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_40));
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($9, sql::_41));
      }
    | table_ref NATURAL RIGHT opt_outer JOIN_SYM table_factor
      {
        $$= mysql_parser::new_ast_node(sql::_join_table);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NATURAL));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_RIGHT));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $6);
      }
    ;

normal_join:
      JOIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_normal_join);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_JOIN_SYM));
      }
    | INNER_SYM JOIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_normal_join);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INNER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_JOIN_SYM));
      }
    | CROSS JOIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_normal_join);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CROSS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_JOIN_SYM));
      }
    ;

table_factor:
      table_ident opt_table_alias opt_key_definition
      {
        $$= mysql_parser::new_ast_node(sql::_table_factor);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '{' ident table_ref LEFT OUTER JOIN_SYM table_ref ON expr '}'
      {
        $$= mysql_parser::new_ast_node(sql::_table_factor);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_123));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_LEFT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_OUTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_JOIN_SYM));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($8, sql::_ON));
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($10, sql::_125));
      }
    | select_derived_init get_select_lex select_derived2
      {
        $$= mysql_parser::new_ast_node(sql::_table_factor);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '(' get_select_lex select_derived union_opt ')' opt_table_alias
      {
        $$= mysql_parser::new_ast_node(sql::_table_factor);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
        mysql_parser::add_ast_child_node($$, $6);
      }
    ;

select_derived:
      get_select_lex derived_table_list
      {
        $$= mysql_parser::new_ast_node(sql::_select_derived);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

select_derived2:
      select_options select_item_list opt_select_from
      {
        $$= mysql_parser::new_ast_node(sql::_select_derived2);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

get_select_lex:
      /* empty */
      {
        $$= NULL;
      }
    ;

select_derived_init:
      SELECT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_select_derived_init);
      }
    ;

opt_outer:
      /* empty */
      {
        $$= NULL;
      }
    | OUTER
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_outer);
      }
    ;

index_hint_clause:
      /* empty */
      {
        $$= NULL;
      }
    | FOR_SYM JOIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_index_hint_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_JOIN_SYM));
      }
    | FOR_SYM ORDER_SYM BY
      {
        $$= mysql_parser::new_ast_node(sql::_index_hint_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ORDER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BY));
      }
    | FOR_SYM GROUP_SYM BY
      {
        $$= mysql_parser::new_ast_node(sql::_index_hint_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_GROUP_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BY));
      }
    ;

index_hint_type:
      FORCE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_index_hint_type);
      }
    | IGNORE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_index_hint_type);
      }
    ;

index_hint_definition:
      index_hint_type key_or_index index_hint_clause '(' key_usage_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_index_hint_definition);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    | USE_SYM key_or_index index_hint_clause '(' opt_key_usage_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_index_hint_definition);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    ;

index_hints_list:
      index_hint_definition
      {
        $$= mysql_parser::new_ast_node(sql::_index_hints_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | index_hints_list index_hint_definition
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_index_hints_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_index_hints_list:
      /* empty */
      {
        $$= NULL;
      }
    | index_hints_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_index_hints_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_key_definition:
      opt_index_hints_list
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_key_definition);
      }
    ;

opt_key_usage_list:
      /* empty */
      {
        $$= NULL;
      }
    | key_usage_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_key_usage_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

key_usage_element:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_key_usage_element);
      }
    | PRIMARY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_key_usage_element);
      }
    ;

key_usage_list:
      key_usage_element
      {
        $$= mysql_parser::new_ast_node(sql::_key_usage_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | key_usage_list ',' key_usage_element
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_key_usage_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

using_list:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_using_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | using_list ',' ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_using_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

interval:
      interval_time_st
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | DAY_HOUR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | DAY_MICROSECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | DAY_MINUTE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | DAY_SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | HOUR_MICROSECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | HOUR_MINUTE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | HOUR_SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | MICROSECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | MINUTE_MICROSECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | MINUTE_SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | SECOND_MICROSECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    | YEAR_MONTH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval);
      }
    ;

interval_time_st:
      DAY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | WEEK_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | HOUR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | FRAC_SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | MINUTE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | MONTH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | QUARTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    | YEAR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_interval_time_st);
      }
    ;

date_time_type:
      DATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_date_time_type);
      }
    | TIME_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_date_time_type);
      }
    | DATETIME
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_date_time_type);
      }
    | TIMESTAMP
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_date_time_type);
      }
    ;

table_alias:
      /* empty */
      {
        $$= NULL;
      }
    | AS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_table_alias);
      }
    | EQ
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_table_alias);
      }
    ;

opt_table_alias:
      /* empty */
      {
        $$= NULL;
      }
    | table_alias ident
      {
        $$= mysql_parser::new_ast_node(sql::_opt_table_alias);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_all:
      /* empty */
      {
        $$= NULL;
      }
    | ALL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_all);
      }
    ;

where_clause:
      /* empty */
      {
        $$= NULL;
      }
    | WHERE expr
      {
        $$= mysql_parser::new_ast_node(sql::_where_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WHERE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

having_clause:
      /* empty */
      {
        $$= NULL;
      }
    | HAVING expr
      {
        $$= mysql_parser::new_ast_node(sql::_having_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HAVING));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_escape:
      ESCAPE_SYM simple_expr
      {
        $$= mysql_parser::new_ast_node(sql::_opt_escape);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ESCAPE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | /* empty */
      {
        $$= NULL;
      }
    ;

group_clause:
      /* empty */
      {
        $$= NULL;
      }
    | GROUP_SYM BY group_list olap_opt
      {
        $$= mysql_parser::new_ast_node(sql::_group_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GROUP_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

group_list:
      group_list ',' order_ident order_dir
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_group_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | order_ident order_dir
      {
        $$= mysql_parser::new_ast_node(sql::_group_list);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

olap_opt:
      /* empty */
      {
        $$= NULL;
      }
    | WITH CUBE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_olap_opt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CUBE_SYM));
      }
    | WITH ROLLUP_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_olap_opt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ROLLUP_SYM));
      }
    ;

alter_order_clause:
      ORDER_SYM BY alter_order_list
      {
        $$= mysql_parser::new_ast_node(sql::_alter_order_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ORDER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

alter_order_list:
      alter_order_list ',' alter_order_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_alter_order_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | alter_order_item
      {
        $$= mysql_parser::new_ast_node(sql::_alter_order_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

alter_order_item:
      simple_ident_nospvar order_dir
      {
        $$= mysql_parser::new_ast_node(sql::_alter_order_item);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_order_clause:
      /* empty */
      {
        $$= NULL;
      }
    | order_clause
      {
        $$= mysql_parser::new_ast_node(sql::_opt_order_clause);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

order_clause:
      ORDER_SYM BY order_list
      {
        $$= mysql_parser::new_ast_node(sql::_order_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ORDER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

order_list:
      order_list ',' order_ident order_dir
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_order_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | order_ident order_dir
      {
        $$= mysql_parser::new_ast_node(sql::_order_list);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

order_dir:
      /* empty */
      {
        $$= NULL;
      }
    | ASC
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_order_dir);
      }
    | DESC
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_order_dir);
      }
    ;

opt_limit_clause_init:
      /* empty */
      {
        $$= NULL;
      }
    | limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_opt_limit_clause_init);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_limit_clause:
      /* empty */
      {
        $$= NULL;
      }
    | limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_opt_limit_clause);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

limit_clause:
      LIMIT limit_options
      {
        $$= mysql_parser::new_ast_node(sql::_limit_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LIMIT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

limit_options:
      limit_option
      {
        $$= mysql_parser::new_ast_node(sql::_limit_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | limit_option ',' limit_option
      {
        $$= mysql_parser::new_ast_node(sql::_limit_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | limit_option OFFSET_SYM limit_option
      {
        $$= mysql_parser::new_ast_node(sql::_limit_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_OFFSET_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

limit_option:
      param_marker
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_limit_option);
      }
    | ULONGLONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_limit_option);
      }
    | LONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_limit_option);
      }
    | NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_limit_option);
      }
    ;

delete_limit_clause:
      /* empty */
      {
        $$= NULL;
      }
    | LIMIT limit_option
      {
        $$= mysql_parser::new_ast_node(sql::_delete_limit_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LIMIT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

ulong_num:
      NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulong_num);
      }
    | HEX_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulong_num);
      }
    | LONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulong_num);
      }
    | ULONGLONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulong_num);
      }
    | DECIMAL_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulong_num);
      }
    | FLOAT_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulong_num);
      }
    ;

real_ulong_num:
      NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulong_num);
      }
    | HEX_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulong_num);
      }
    | LONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulong_num);
      }
    | ULONGLONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulong_num);
      }
    | dec_num_error
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulong_num);
      }
    ;

ulonglong_num:
      NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulonglong_num);
      }
    | ULONGLONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulonglong_num);
      }
    | LONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulonglong_num);
      }
    | DECIMAL_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulonglong_num);
      }
    | FLOAT_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ulonglong_num);
      }
    ;

real_ulonglong_num:
      NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulonglong_num);
      }
    | ULONGLONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulonglong_num);
      }
    | LONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulonglong_num);
      }
    | dec_num_error
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_real_ulonglong_num);
      }
    ;

dec_num_error:
      dec_num
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_dec_num_error);
      }
    ;

dec_num:
      DECIMAL_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_dec_num);
      }
    | FLOAT_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_dec_num);
      }
    ;

procedure_clause:
      /* empty */
      {
        $$= NULL;
      }
    | PROCEDURE ident '(' procedure_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_procedure_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_40));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_41));
      }
    ;

procedure_list:
      /* empty */
      {
        $$= NULL;
      }
    | procedure_list2
      {
        $$= mysql_parser::new_ast_node(sql::_procedure_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

procedure_list2:
      procedure_list2 ',' procedure_item
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_procedure_list2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | procedure_item
      {
        $$= mysql_parser::new_ast_node(sql::_procedure_list2);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

procedure_item:
      remember_name expr remember_end
      {
        $$= mysql_parser::new_ast_node(sql::_procedure_item);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

select_var_list_init:
      select_var_list
      {
        $$= mysql_parser::new_ast_node(sql::_select_var_list_init);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

select_var_list:
      select_var_list ',' select_var_ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_select_var_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | select_var_ident
      {
        $$= mysql_parser::new_ast_node(sql::_select_var_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

select_var_ident:
      '@' ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_select_var_ident);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_select_var_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

into:
      INTO into_destination
      {
        $$= mysql_parser::new_ast_node(sql::_into);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INTO));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

into_destination:
      OUTFILE TEXT_STRING_filesystem opt_field_term opt_line_term
      {
        $$= mysql_parser::new_ast_node(sql::_into_destination);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OUTFILE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DUMPFILE TEXT_STRING_filesystem
      {
        $$= mysql_parser::new_ast_node(sql::_into_destination);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DUMPFILE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | select_var_list_init
      {
        $$= mysql_parser::new_ast_node(sql::_into_destination);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

do:
      DO_SYM expr_list
      {
        $$= mysql_parser::new_ast_node(sql::_do);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DO_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

drop:
      DROP opt_temporary table_or_tables if_exists table_list opt_restrict
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | DROP INDEX_SYM ident ON table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_INDEX_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_ON));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | DROP DATABASE if_exists ident
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP FUNCTION_SYM if_exists ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_46));
        mysql_parser::add_ast_child_node($$, $6);
      }
    | DROP FUNCTION_SYM if_exists ident
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP PROCEDURE if_exists sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP USER clear_privileges user_list
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_USER));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP VIEW_SYM if_exists table_list opt_restrict
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VIEW_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | DROP EVENT_SYM if_exists sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EVENT_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP TRIGGER_SYM if_exists sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TRIGGER_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | DROP TABLESPACE tablespace_name opt_ts_engine opt_ts_wait
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLESPACE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | DROP LOGFILE_SYM GROUP_SYM logfile_group_name opt_ts_engine opt_ts_wait
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOGFILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_GROUP_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | DROP SERVER_SYM if_exists ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_drop);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SERVER_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

table_list:
      table_name
      {
        $$= mysql_parser::new_ast_node(sql::_table_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_list ',' table_name
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_table_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

table_name:
      table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_table_name);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

table_alias_ref_list:
      table_alias_ref
      {
        $$= mysql_parser::new_ast_node(sql::_table_alias_ref_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_alias_ref_list ',' table_alias_ref
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_table_alias_ref_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

table_alias_ref:
      table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_table_alias_ref);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

if_exists:
      /* empty */
      {
        $$= NULL;
      }
    | IF EXISTS
      {
        $$= mysql_parser::new_ast_node(sql::_if_exists);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IF));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EXISTS));
      }
    ;

opt_temporary:
      /* empty */
      {
        $$= NULL;
      }
    | TEMPORARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_temporary);
      }
    ;

insert:
      INSERT insert_lock_option opt_ignore insert2 insert_field_spec opt_insert_update
      {
        $$= mysql_parser::new_ast_node(sql::_insert);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INSERT));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    ;

replace:
      REPLACE replace_lock_option insert2 insert_field_spec
      {
        $$= mysql_parser::new_ast_node(sql::_replace);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPLACE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

insert_lock_option:
      /* empty */
      {
        $$= NULL;
      }
    | LOW_PRIORITY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_insert_lock_option);
      }
    | DELAYED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_insert_lock_option);
      }
    | HIGH_PRIORITY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_insert_lock_option);
      }
    ;

replace_lock_option:
      opt_low_priority
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_replace_lock_option);
      }
    | DELAYED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_replace_lock_option);
      }
    ;

insert2:
      INTO insert_table
      {
        $$= mysql_parser::new_ast_node(sql::_insert2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INTO));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | insert_table
      {
        $$= mysql_parser::new_ast_node(sql::_insert2);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

insert_table:
      table_name
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_insert_table);
      }
    ;

insert_field_spec:
      insert_values
      {
        $$= mysql_parser::new_ast_node(sql::_insert_field_spec);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '(' ')' insert_values
      {
        $$= mysql_parser::new_ast_node(sql::_insert_field_spec);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_41));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '(' fields ')' insert_values
      {
        $$= mysql_parser::new_ast_node(sql::_insert_field_spec);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | SET ident_eq_list
      {
        $$= mysql_parser::new_ast_node(sql::_insert_field_spec);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SET));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

fields:
      fields ',' insert_ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_fields);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | insert_ident
      {
        $$= mysql_parser::new_ast_node(sql::_fields);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

insert_values:
      VALUES values_list
      {
        $$= mysql_parser::new_ast_node(sql::_insert_values);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VALUES));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | VALUE_SYM values_list
      {
        $$= mysql_parser::new_ast_node(sql::_insert_values);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_VALUE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | create_select union_clause
      {
        $$= mysql_parser::new_ast_node(sql::_insert_values);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | '(' create_select ')' union_opt
      {
        $$= mysql_parser::new_ast_node(sql::_insert_values);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

values_list:
      values_list ',' no_braces
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_values_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | no_braces
      {
        $$= mysql_parser::new_ast_node(sql::_values_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

ident_eq_list:
      ident_eq_list ',' ident_eq_value
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_ident_eq_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ident_eq_value
      {
        $$= mysql_parser::new_ast_node(sql::_ident_eq_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

ident_eq_value:
      simple_ident_nospvar equal expr_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_ident_eq_value);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

equal:
      EQ
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_equal);
      }
    | SET_VAR
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_equal);
      }
    ;

opt_equal:
      /* empty */
      {
        $$= NULL;
      }
    | equal
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_equal);
      }
    ;

no_braces:
      '(' opt_values ')'
      {
        $$= mysql_parser::new_ast_node(sql::_no_braces);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

opt_values:
      /* empty */
      {
        $$= NULL;
      }
    | values
      {
        $$= mysql_parser::new_ast_node(sql::_opt_values);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

values:
      values ',' expr_or_default
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_values);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | expr_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_values);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

expr_or_default:
      expr
      {
        $$= mysql_parser::new_ast_node(sql::_expr_or_default);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | DEFAULT
      {
        $$= mysql_parser::new_ast_node(sql::_expr_or_default);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFAULT));
      }
    ;

opt_insert_update:
      /* empty */
      {
        $$= NULL;
      }
    | ON DUPLICATE_SYM KEY_SYM UPDATE_SYM insert_update_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_insert_update);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DUPLICATE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_KEY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_UPDATE_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

update:
      UPDATE_SYM opt_low_priority opt_ignore join_table_list SET update_list where_clause opt_order_clause delete_limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_update);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UPDATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_SET));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, $9);
      }
    ;

update_list:
      update_list ',' update_elem
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_update_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | update_elem
      {
        $$= mysql_parser::new_ast_node(sql::_update_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

update_elem:
      simple_ident_nospvar equal expr_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_update_elem);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

insert_update_list:
      insert_update_list ',' insert_update_elem
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_insert_update_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | insert_update_elem
      {
        $$= mysql_parser::new_ast_node(sql::_insert_update_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

insert_update_elem:
      simple_ident_nospvar equal expr_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_insert_update_elem);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_low_priority:
      /* empty */
      {
        $$= NULL;
      }
    | LOW_PRIORITY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_low_priority);
      }
    ;

delete:
      DELETE_SYM opt_delete_options single_multi
      {
        $$= mysql_parser::new_ast_node(sql::_delete);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DELETE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

single_multi:
      FROM table_ident where_clause opt_order_clause delete_limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_single_multi);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | table_wild_list FROM join_table_list where_clause
      {
        $$= mysql_parser::new_ast_node(sql::_single_multi);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | FROM table_alias_ref_list USING join_table_list where_clause
      {
        $$= mysql_parser::new_ast_node(sql::_single_multi);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_USING));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

table_wild_list:
      table_wild_one
      {
        $$= mysql_parser::new_ast_node(sql::_table_wild_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_wild_list ',' table_wild_one
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_table_wild_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

table_wild_one:
      ident opt_wild opt_table_alias
      {
        $$= mysql_parser::new_ast_node(sql::_table_wild_one);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ident '.' ident opt_wild opt_table_alias
      {
        $$= mysql_parser::new_ast_node(sql::_table_wild_one);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

opt_wild:
      /* empty */
      {
        $$= NULL;
      }
    | '.' '*'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_wild);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_46));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_42));
      }
    ;

opt_delete_options:
      /* empty */
      {
        $$= NULL;
      }
    | opt_delete_option opt_delete_options
      {
        $$= mysql_parser::new_ast_node(sql::_opt_delete_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::merge_ast_child_nodes($$, $2);
      }
    ;

opt_delete_option:
      QUICK
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_delete_option);
      }
    | LOW_PRIORITY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_delete_option);
      }
    | IGNORE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_delete_option);
      }
    ;

truncate:
      TRUNCATE_SYM opt_table_sym table_name
      {
        $$= mysql_parser::new_ast_node(sql::_truncate);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRUNCATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_table_sym:
      /* empty */
      {
        $$= NULL;
      }
    | TABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_table_sym);
      }
    ;

show:
      SHOW show_param
      {
        $$= mysql_parser::new_ast_node(sql::_show);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SHOW));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

show_param:
      DATABASES wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATABASES));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | opt_full TABLES opt_db wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLES));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | opt_full TRIGGERS_SYM opt_db wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TRIGGERS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | EVENTS_SYM opt_db wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EVENTS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | TABLE_SYM STATUS_SYM opt_db wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | OPEN_SYM TABLES opt_db wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OPEN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLES));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | opt_full PLUGIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PLUGIN_SYM));
      }
    | PLUGINS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PLUGINS_SYM));
      }
    | ENGINE_SYM known_storage_engines show_engine_param
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENGINE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ENGINE_SYM ALL show_engine_param
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENGINE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ALL));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | opt_full COLUMNS from_or_in table_ident opt_db wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COLUMNS));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | NEW_SYM MASTER_SYM FOR_SYM SLAVE WITH MASTER_LOG_FILE_SYM EQ TEXT_STRING_sys AND_SYM MASTER_LOG_POS_SYM EQ ulonglong_num AND_SYM MASTER_SERVER_ID_SYM EQ ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NEW_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MASTER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_MASTER_LOG_FILE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($9, sql::_AND_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($10, sql::_MASTER_LOG_POS_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($11, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $12);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($13, sql::_AND_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($14, sql::_MASTER_SERVER_ID_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($15, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $16);
      }
    | master_or_binary LOGS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOGS_SYM));
      }
    | SLAVE HOSTS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_HOSTS_SYM));
      }
    | BINLOG_SYM EVENTS_SYM binlog_in binlog_from opt_limit_clause_init
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINLOG_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EVENTS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | keys_or_index from_or_in table_ident opt_db where_clause
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | COLUMN_SYM TYPES_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COLUMN_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TYPES_SYM));
      }
    | TABLE_SYM TYPES_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TYPES_SYM));
      }
    | opt_storage ENGINES_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ENGINES_SYM));
      }
    | AUTHORS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AUTHORS_SYM));
      }
    | CONTRIBUTORS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CONTRIBUTORS_SYM));
      }
    | PRIVILEGES
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PRIVILEGES));
      }
    | COUNT_SYM '(' '*' ')' WARNINGS
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COUNT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_42));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_WARNINGS));
      }
    | COUNT_SYM '(' '*' ')' ERRORS
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COUNT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_42));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_ERRORS));
      }
    | WARNINGS opt_limit_clause_init
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WARNINGS));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | ERRORS opt_limit_clause_init
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ERRORS));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | opt_var_type STATUS_SYM wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | INNOBASE_SYM STATUS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INNOBASE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
      }
    | MUTEX_SYM STATUS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MUTEX_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
      }
    | opt_full PROCESSLIST_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PROCESSLIST_SYM));
      }
    | opt_var_type VARIABLES wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VARIABLES));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | charset wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | COLLATION_SYM wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COLLATION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | GRANTS
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GRANTS));
      }
    | GRANTS FOR_SYM user
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GRANTS));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CREATE DATABASE opt_if_not_exists ident
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATABASE));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | CREATE TABLE_SYM table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CREATE VIEW_SYM table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VIEW_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | MASTER_SYM STATUS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
      }
    | SLAVE STATUS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SLAVE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
      }
    | CREATE PROCEDURE sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CREATE FUNCTION_SYM sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CREATE TRIGGER_SYM sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TRIGGER_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PROCEDURE STATUS_SYM wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | FUNCTION_SYM STATUS_SYM wild_and_where
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_STATUS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PROCEDURE CODE_SYM sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CODE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | FUNCTION_SYM CODE_SYM sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CODE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CREATE EVENT_SYM sp_name
      {
        $$= mysql_parser::new_ast_node(sql::_show_param);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EVENT_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

show_engine_param:
      STATUS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_show_engine_param);
      }
    | MUTEX_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_show_engine_param);
      }
    | LOGS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_show_engine_param);
      }
    ;

master_or_binary:
      MASTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_master_or_binary);
      }
    | BINARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_master_or_binary);
      }
    ;

opt_storage:
      /* empty */
      {
        $$= NULL;
      }
    | STORAGE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_storage);
      }
    ;

opt_db:
      /* empty */
      {
        $$= NULL;
      }
    | from_or_in ident
      {
        $$= mysql_parser::new_ast_node(sql::_opt_db);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_full:
      /* empty */
      {
        $$= NULL;
      }
    | FULL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_full);
      }
    ;

from_or_in:
      FROM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_from_or_in);
      }
    | IN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_from_or_in);
      }
    ;

binlog_in:
      /* empty */
      {
        $$= NULL;
      }
    | IN_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_binlog_in);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

binlog_from:
      /* empty */
      {
        $$= NULL;
      }
    | FROM ulonglong_num
      {
        $$= mysql_parser::new_ast_node(sql::_binlog_from);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

wild_and_where:
      /* empty */
      {
        $$= NULL;
      }
    | LIKE TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_wild_and_where);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LIKE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | WHERE expr
      {
        $$= mysql_parser::new_ast_node(sql::_wild_and_where);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WHERE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

describe:
      describe_command table_ident opt_describe_column
      {
        $$= mysql_parser::new_ast_node(sql::_describe);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | describe_command opt_extended_describe select
      {
        $$= mysql_parser::new_ast_node(sql::_describe);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

describe_command:
      DESC
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_describe_command);
      }
    | DESCRIBE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_describe_command);
      }
    ;

opt_extended_describe:
      /* empty */
      {
        $$= NULL;
      }
    | EXTENDED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_extended_describe);
      }
    | PARTITIONS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_extended_describe);
      }
    ;

opt_describe_column:
      /* empty */
      {
        $$= NULL;
      }
    | text_string
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_describe_column);
      }
    | ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_describe_column);
      }
    ;

flush:
      FLUSH_SYM opt_no_write_to_binlog flush_options
      {
        $$= mysql_parser::new_ast_node(sql::_flush);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FLUSH_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

flush_options:
      flush_options ',' flush_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_flush_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | flush_option
      {
        $$= mysql_parser::new_ast_node(sql::_flush_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

flush_option:
      table_or_tables opt_table_list
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | TABLES WITH READ_SYM LOCK_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TABLES));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_READ_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_LOCK_SYM));
      }
    | QUERY_SYM CACHE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_QUERY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CACHE_SYM));
      }
    | HOSTS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HOSTS_SYM));
      }
    | PRIVILEGES
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PRIVILEGES));
      }
    | LOGS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOGS_SYM));
      }
    | STATUS_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STATUS_SYM));
      }
    | SLAVE
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SLAVE));
      }
    | MASTER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SYM));
      }
    | DES_KEY_FILE
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DES_KEY_FILE));
      }
    | RESOURCES
      {
        $$= mysql_parser::new_ast_node(sql::_flush_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RESOURCES));
      }
    ;

opt_table_list:
      /* empty */
      {
        $$= NULL;
      }
    | table_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_table_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

reset:
      RESET_SYM reset_options
      {
        $$= mysql_parser::new_ast_node(sql::_reset);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RESET_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

reset_options:
      reset_options ',' reset_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_reset_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | reset_option
      {
        $$= mysql_parser::new_ast_node(sql::_reset_options);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

reset_option:
      SLAVE
      {
        $$= mysql_parser::new_ast_node(sql::_reset_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SLAVE));
      }
    | MASTER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_reset_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MASTER_SYM));
      }
    | QUERY_SYM CACHE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_reset_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_QUERY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CACHE_SYM));
      }
    ;

purge:
      PURGE purge_options
      {
        $$= mysql_parser::new_ast_node(sql::_purge);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PURGE));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

purge_options:
      master_or_binary LOGS_SYM purge_option
      {
        $$= mysql_parser::new_ast_node(sql::_purge_options);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOGS_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

purge_option:
      TO_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_purge_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | BEFORE_SYM expr
      {
        $$= mysql_parser::new_ast_node(sql::_purge_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BEFORE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

kill:
      KILL_SYM kill_option expr
      {
        $$= mysql_parser::new_ast_node(sql::_kill);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_KILL_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

kill_option:
      /* empty */
      {
        $$= NULL;
      }
    | CONNECTION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_kill_option);
      }
    | QUERY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_kill_option);
      }
    ;

use:
      USE_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_use);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

load:
      LOAD DATA_SYM load_data
      {
        $$= mysql_parser::new_ast_node(sql::_load);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOAD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATA_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | LOAD TABLE_SYM table_ident FROM MASTER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_load);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOAD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_FROM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_MASTER_SYM));
      }
    ;

load_data:
      load_data_lock opt_local INFILE TEXT_STRING_filesystem opt_duplicate INTO TABLE_SYM table_ident opt_load_data_charset opt_field_term opt_line_term opt_ignore_lines opt_field_or_var_spec opt_load_data_set_spec
      {
        $$= mysql_parser::new_ast_node(sql::_load_data);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INFILE));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_INTO));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_TABLE_SYM));
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, $10);
        mysql_parser::add_ast_child_node($$, $11);
        mysql_parser::add_ast_child_node($$, $12);
        mysql_parser::add_ast_child_node($$, $13);
        mysql_parser::add_ast_child_node($$, $14);
      }
    | FROM MASTER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_load_data);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FROM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MASTER_SYM));
      }
    ;

opt_local:
      /* empty */
      {
        $$= NULL;
      }
    | LOCAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_local);
      }
    ;

load_data_lock:
      /* empty */
      {
        $$= NULL;
      }
    | CONCURRENT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_load_data_lock);
      }
    | LOW_PRIORITY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_load_data_lock);
      }
    ;

opt_duplicate:
      /* empty */
      {
        $$= NULL;
      }
    | REPLACE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_duplicate);
      }
    | IGNORE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_duplicate);
      }
    ;

opt_field_term:
      /* empty */
      {
        $$= NULL;
      }
    | COLUMNS field_term_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_field_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COLUMNS));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

field_term_list:
      field_term_list field_term
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_field_term_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | field_term
      {
        $$= mysql_parser::new_ast_node(sql::_field_term_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

field_term:
      TERMINATED BY text_string
      {
        $$= mysql_parser::new_ast_node(sql::_field_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TERMINATED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | OPTIONALLY ENCLOSED BY text_string
      {
        $$= mysql_parser::new_ast_node(sql::_field_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OPTIONALLY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ENCLOSED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BY));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ENCLOSED BY text_string
      {
        $$= mysql_parser::new_ast_node(sql::_field_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ENCLOSED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | ESCAPED BY text_string
      {
        $$= mysql_parser::new_ast_node(sql::_field_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ESCAPED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_line_term:
      /* empty */
      {
        $$= NULL;
      }
    | LINES line_term_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_line_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LINES));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

line_term_list:
      line_term_list line_term
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_line_term_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | line_term
      {
        $$= mysql_parser::new_ast_node(sql::_line_term_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

line_term:
      TERMINATED BY text_string
      {
        $$= mysql_parser::new_ast_node(sql::_line_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TERMINATED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | STARTING BY text_string
      {
        $$= mysql_parser::new_ast_node(sql::_line_term);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_STARTING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BY));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_ignore_lines:
      /* empty */
      {
        $$= NULL;
      }
    | IGNORE_SYM NUM LINES
      {
        $$= mysql_parser::new_ast_node(sql::_opt_ignore_lines);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_IGNORE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NUM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_LINES));
      }
    ;

opt_field_or_var_spec:
      /* empty */
      {
        $$= NULL;
      }
    | '(' fields_or_vars ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_field_or_var_spec);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    | '(' ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_field_or_var_spec);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_41));
      }
    ;

fields_or_vars:
      fields_or_vars ',' field_or_var
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_fields_or_vars);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | field_or_var
      {
        $$= mysql_parser::new_ast_node(sql::_fields_or_vars);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

field_or_var:
      simple_ident_nospvar
      {
        $$= mysql_parser::new_ast_node(sql::_field_or_var);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '@' ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_field_or_var);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_load_data_set_spec:
      /* empty */
      {
        $$= NULL;
      }
    | SET insert_update_list
      {
        $$= mysql_parser::new_ast_node(sql::_opt_load_data_set_spec);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SET));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

text_literal:
      TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_text_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TEXT_STRING));
      }
    | NCHAR_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_text_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NCHAR_STRING));
      }
    | UNDERSCORE_CHARSET TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_text_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNDERSCORE_CHARSET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TEXT_STRING));
      }
    | text_literal TEXT_STRING_literal
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_text_literal);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

text_string:
      TEXT_STRING_literal
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_text_string);
      }
    | HEX_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_text_string);
      }
    | BIN_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_text_string);
      }
    ;

param_marker:
      PARAM_MARKER
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_param_marker);
      }
    ;

signed_literal:
      literal
      {
        $$= mysql_parser::new_ast_node(sql::_signed_literal);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | '+' NUM_literal
      {
        $$= mysql_parser::new_ast_node(sql::_signed_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_43));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | '-' NUM_literal
      {
        $$= mysql_parser::new_ast_node(sql::_signed_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_45));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

literal:
      text_literal
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | NUM_literal
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | NULL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NULL_SYM));
      }
    | FALSE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FALSE_SYM));
      }
    | TRUE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRUE_SYM));
      }
    | HEX_NUM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HEX_NUM));
      }
    | BIN_NUM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BIN_NUM));
      }
    | UNDERSCORE_CHARSET HEX_NUM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNDERSCORE_CHARSET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_HEX_NUM));
      }
    | UNDERSCORE_CHARSET BIN_NUM
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNDERSCORE_CHARSET));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_BIN_NUM));
      }
    | DATE_SYM text_literal
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | TIME_SYM text_literal
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIME_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | TIMESTAMP text_literal
      {
        $$= mysql_parser::new_ast_node(sql::_literal);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TIMESTAMP));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

NUM_literal:
      NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_NUM_literal);
      }
    | LONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_NUM_literal);
      }
    | ULONGLONG_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_NUM_literal);
      }
    | DECIMAL_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_NUM_literal);
      }
    | FLOAT_NUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_NUM_literal);
      }
    ;

insert_ident:
      simple_ident_nospvar
      {
        $$= mysql_parser::new_ast_node(sql::_insert_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_wild
      {
        $$= mysql_parser::new_ast_node(sql::_insert_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

table_wild:
      ident '.' '*'
      {
        $$= mysql_parser::new_ast_node(sql::_table_wild);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_42));
      }
    | ident '.' ident '.' '*'
      {
        $$= mysql_parser::new_ast_node(sql::_table_wild);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_46));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_42));
      }
    ;

order_ident:
      expr
      {
        $$= mysql_parser::new_ast_node(sql::_order_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

simple_ident:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | simple_ident_q
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

simple_ident_nospvar:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident_nospvar);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | simple_ident_q
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident_nospvar);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

simple_ident_q:
      ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident_q);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '.' ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident_q);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_46));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_46));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ident '.' ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_simple_ident_q);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_46));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

field_ident:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_field_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident '.' ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_field_ident);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_46));
        mysql_parser::add_ast_child_node($$, $5);
      }
    | ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_field_ident);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_field_ident);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_46));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

table_ident:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_table_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_table_ident);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_table_ident);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_46));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

table_ident_nodb:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_table_ident_nodb);
      }
    ;

IDENT_sys:
      IDENT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_IDENT_sys);
      }
    | IDENT_QUOTED
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_IDENT_sys);
      }
    ;

TEXT_STRING_sys:
      TEXT_STRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_TEXT_STRING_sys);
      }
    ;

TEXT_STRING_literal:
      TEXT_STRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_TEXT_STRING_literal);
      }
    ;

TEXT_STRING_filesystem:
      TEXT_STRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_TEXT_STRING_filesystem);
      }
    ;

ident:
      IDENT_sys
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident);
      }
    | READ_ONLY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident);
      }
    | keyword
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident);
      }
    ;

label_ident:
      IDENT_sys
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_label_ident);
      }
    | keyword_sp
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_label_ident);
      }
    ;

ident_or_text:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident_or_text);
      }
    | TEXT_STRING_sys
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident_or_text);
      }
    | LEX_HOSTNAME
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_ident_or_text);
      }
    ;

user:
      ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_user);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident_or_text '@' ident_or_text
      {
        $$= mysql_parser::new_ast_node(sql::_user);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_64));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | CURRENT_USER optional_braces
      {
        $$= mysql_parser::new_ast_node(sql::_user);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CURRENT_USER));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

keyword:
      keyword_sp
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | ASCII_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | BACKUP_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | BEGIN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | BYTE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | CACHE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | CHARSET
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | CHECKSUM_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | CLOSE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | COMMENT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | COMMIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | CONTAINS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | DEALLOCATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | DO_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | END
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | EXECUTE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | FLUSH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | HANDLER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | HELP_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | HOST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | INSTALL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | LANGUAGE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | NO_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | OPEN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | OPTIONS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | OWNER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | PARSER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | PARTITION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | PORT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | PREPARE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | REMOVE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | REPAIR
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | RESET_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | RESTORE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | ROLLBACK_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SAVEPOINT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SECURITY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SERVER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SIGNED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SOCKET_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SLAVE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | SONAME_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | START_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | STOP_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | TRUNCATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | UNICODE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | UNINSTALL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | WRAPPER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | XA_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    | UPGRADE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword);
      }
    ;

keyword_sp:
      ACTION
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ADDDATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AFTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AGAINST
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AGGREGATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ALGORITHM_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ANY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AUTHORS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AUTO_INC
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AUTOEXTEND_SIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AVG_ROW_LENGTH
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | AVG_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | BINLOG_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | BIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | BOOL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | BOOLEAN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | BTREE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CASCADED
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CHAIN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CHANGED
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CIPHER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CLIENT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COALESCE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CODE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COLLATION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COLUMNS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COMMITTED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COMPACT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COMPLETION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | COMPRESSED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CONCURRENT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CONNECTION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CONSISTENT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CONTRIBUTORS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | CUBE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DATA_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DATAFILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DATETIME
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DAY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DEFINER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DELAY_KEY_WRITE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DES_KEY_FILE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DIRECTORY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DISABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DISCARD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DISK_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DUMPFILE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DUPLICATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | DYNAMIC_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ENDS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ENUM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ENGINE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ENGINES_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ERRORS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ESCAPE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | EVENT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | EVENTS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | EVERY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | EXPANSION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | EXTENDED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | EXTENT_SIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FAST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FOUND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ENABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FULL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FIRST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FIXED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FRAC_SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | GEOMETRY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | GEOMETRYCOLLECTION
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | GET_FORMAT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | GRANTS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | GLOBAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | HASH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | HOSTS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | HOUR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | IDENTIFIED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | INVOKER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | IMPORT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | INDEXES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | INITIAL_SIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ISOLATION
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ISSUER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | INNOBASE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | INSERT_METHOD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | KEY_BLOCK_SIZE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LAST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LEAVES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LESS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LEVEL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LINESTRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LIST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LOCAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LOCKS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LOGFILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | LOGS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_ROWS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_HOST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_PORT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_LOG_FILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_LOG_POS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_USER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_PASSWORD_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SERVER_ID_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_CONNECT_RETRY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SSL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SSL_CA_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SSL_CAPATH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SSL_CERT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SSL_CIPHER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MASTER_SSL_KEY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_CONNECTIONS_PER_HOUR
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_QUERIES_PER_HOUR
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_SIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_UPDATES_PER_HOUR
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_USER_CONNECTIONS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MAX_VALUE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MEDIUM_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MEMORY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MERGE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MICROSECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MIGRATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MINUTE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MIN_ROWS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MODIFY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MODE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MONTH_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MULTILINESTRING
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MULTIPOINT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MULTIPOLYGON
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | MUTEX_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NAME_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NAMES_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NATIONAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NCHAR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NDBCLUSTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NEXT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NEW_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NO_WAIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NODEGROUP_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NONE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | NVARCHAR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | OFFSET_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | OLD_PASSWORD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ONE_SHOT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ONE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PACK_KEYS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PAGE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PARTIAL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PARTITIONING_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PARTITIONS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PASSWORD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PHASE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PLUGIN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PLUGINS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | POINT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | POLYGON
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PRESERVE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PREV_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PRIVILEGES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PROCESS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | PROCESSLIST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | QUARTER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | QUERY_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | QUICK
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REBUILD_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RECOVER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REDO_BUFFER_SIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REDOFILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REDUNDANT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RELAY_LOG_FILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RELAY_LOG_POS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RELAY_THREAD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RELOAD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REORGANIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REPEATABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | REPLICATION
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RESOURCES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RESUME_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RETURNS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ROLLUP_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ROUTINE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ROWS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ROW_FORMAT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | ROW_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | RTREE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SCHEDULE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SECOND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SERIAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SERIALIZABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SESSION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SIMPLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SHARE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SHUTDOWN
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SNAPSHOT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SOUNDS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SQL_CACHE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SQL_BUFFER_RESULT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SQL_NO_CACHE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SQL_THREAD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | STARTS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | STATUS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | STORAGE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | STRING_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SUBDATE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SUBJECT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SUBPARTITION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SUBPARTITIONS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SUPER_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | SUSPEND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TABLES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TABLESPACE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TEMPORARY
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TEMPTABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TEXT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | THAN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TRANSACTION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TRANSACTIONAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TRIGGERS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TIMESTAMP
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TIMESTAMP_ADD
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TIMESTAMP_DIFF
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TIME_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TYPES_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | TYPE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UDF_RETURNS_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | FUNCTION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UNCOMMITTED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UNDEFINED_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UNDO_BUFFER_SIZE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UNDOFILE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UNKNOWN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | UNTIL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | USER
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | USE_FRM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | VARIABLES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | VIEW_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | VALUE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | WARNINGS
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | WAIT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | WEEK_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | WORK_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | X509_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    | YEAR_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_keyword_sp);
      }
    ;

set:
      SET opt_option option_value_list
      {
        $$= mysql_parser::new_ast_node(sql::_set);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SET));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

opt_option:
      /* empty */
      {
        $$= NULL;
      }
    | OPTION
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_option);
      }
    ;

option_value_list:
      option_type_value
      {
        $$= mysql_parser::new_ast_node(sql::_option_value_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | option_value_list ',' option_type_value
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_option_value_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

option_type_value:
      ext_option_value
      {
        $$= mysql_parser::new_ast_node(sql::_option_type_value);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

option_type:
      option_type2
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_option_type);
      }
    | GLOBAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_option_type);
      }
    | LOCAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_option_type);
      }
    | SESSION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_option_type);
      }
    ;

option_type2:
      /* empty */
      {
        $$= NULL;
      }
    | ONE_SHOT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_option_type2);
      }
    ;

opt_var_type:
      /* empty */
      {
        $$= NULL;
      }
    | GLOBAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_var_type);
      }
    | LOCAL_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_var_type);
      }
    | SESSION_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_var_type);
      }
    ;

opt_var_ident_type:
      /* empty */
      {
        $$= NULL;
      }
    | GLOBAL_SYM '.'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_var_ident_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GLOBAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
      }
    | LOCAL_SYM '.'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_var_ident_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOCAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
      }
    | SESSION_SYM '.'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_var_ident_type);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SESSION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
      }
    ;

ext_option_value:
      sys_option_value
      {
        $$= mysql_parser::new_ast_node(sql::_ext_option_value);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | option_type2 option_value
      {
        $$= mysql_parser::new_ast_node(sql::_ext_option_value);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

sys_option_value:
      option_type internal_variable_name equal set_expr_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_sys_option_value);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | option_type TRANSACTION_SYM ISOLATION LEVEL_SYM isolation_types
      {
        $$= mysql_parser::new_ast_node(sql::_sys_option_value);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TRANSACTION_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_ISOLATION));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_LEVEL_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

option_value:
      '@' ident_or_text equal expr
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | '@' '@' opt_var_ident_type internal_variable_name equal set_expr_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_64));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_64));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    | charset old_or_new_charset_name_or_default
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | NAMES_SYM equal expr
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NAMES_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | NAMES_SYM charset_name_or_default opt_collate
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NAMES_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PASSWORD equal text_or_password
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    | PASSWORD FOR_SYM user equal text_or_password
      {
        $$= mysql_parser::new_ast_node(sql::_option_value);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

internal_variable_name:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_internal_variable_name);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_internal_variable_name);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | DEFAULT '.' ident
      {
        $$= mysql_parser::new_ast_node(sql::_internal_variable_name);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFAULT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

isolation_types:
      READ_SYM UNCOMMITTED_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_isolation_types);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READ_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_UNCOMMITTED_SYM));
      }
    | READ_SYM COMMITTED_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_isolation_types);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READ_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COMMITTED_SYM));
      }
    | REPEATABLE_SYM READ_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_isolation_types);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPEATABLE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_READ_SYM));
      }
    | SERIALIZABLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_isolation_types);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SERIALIZABLE_SYM));
      }
    ;

text_or_password:
      TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_text_or_password);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TEXT_STRING));
      }
    | PASSWORD '(' TEXT_STRING ')'
      {
        $$= mysql_parser::new_ast_node(sql::_text_or_password);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TEXT_STRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    | OLD_PASSWORD '(' TEXT_STRING ')'
      {
        $$= mysql_parser::new_ast_node(sql::_text_or_password);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OLD_PASSWORD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TEXT_STRING));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

set_expr_or_default:
      expr
      {
        $$= mysql_parser::new_ast_node(sql::_set_expr_or_default);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | DEFAULT
      {
        $$= mysql_parser::new_ast_node(sql::_set_expr_or_default);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFAULT));
      }
    | ON
      {
        $$= mysql_parser::new_ast_node(sql::_set_expr_or_default);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ON));
      }
    | ALL
      {
        $$= mysql_parser::new_ast_node(sql::_set_expr_or_default);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALL));
      }
    | BINARY
      {
        $$= mysql_parser::new_ast_node(sql::_set_expr_or_default);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BINARY));
      }
    ;

lock:
      LOCK_SYM table_or_tables table_lock_list
      {
        $$= mysql_parser::new_ast_node(sql::_lock);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOCK_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

table_or_tables:
      TABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_table_or_tables);
      }
    | TABLES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_table_or_tables);
      }
    ;

table_lock_list:
      table_lock
      {
        $$= mysql_parser::new_ast_node(sql::_table_lock_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | table_lock_list ',' table_lock
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_table_lock_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

table_lock:
      table_ident opt_table_alias lock_option
      {
        $$= mysql_parser::new_ast_node(sql::_table_lock);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

lock_option:
      READ_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_lock_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READ_SYM));
      }
    | WRITE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_lock_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WRITE_SYM));
      }
    | LOW_PRIORITY WRITE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_lock_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOW_PRIORITY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_WRITE_SYM));
      }
    | READ_SYM LOCAL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_lock_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_READ_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOCAL_SYM));
      }
    ;

unlock:
      UNLOCK_SYM table_or_tables
      {
        $$= mysql_parser::new_ast_node(sql::_unlock);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNLOCK_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

handler:
      HANDLER_SYM table_ident OPEN_SYM opt_table_alias
      {
        $$= mysql_parser::new_ast_node(sql::_handler);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HANDLER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_OPEN_SYM));
        mysql_parser::add_ast_child_node($$, $4);
      }
    | HANDLER_SYM table_ident_nodb CLOSE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_handler);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HANDLER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_CLOSE_SYM));
      }
    | HANDLER_SYM table_ident_nodb READ_SYM handler_read_or_scan where_clause opt_limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_handler);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_HANDLER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_READ_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, $6);
      }
    ;

handler_read_or_scan:
      handler_scan_function
      {
        $$= mysql_parser::new_ast_node(sql::_handler_read_or_scan);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ident handler_rkey_function
      {
        $$= mysql_parser::new_ast_node(sql::_handler_read_or_scan);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

handler_scan_function:
      FIRST_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_scan_function);
      }
    | NEXT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_scan_function);
      }
    ;

handler_rkey_function:
      FIRST_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_handler_rkey_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FIRST_SYM));
      }
    | NEXT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_handler_rkey_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NEXT_SYM));
      }
    | PREV_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_handler_rkey_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PREV_SYM));
      }
    | LAST_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_handler_rkey_function);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LAST_SYM));
      }
    | handler_rkey_mode '(' values ')'
      {
        $$= mysql_parser::new_ast_node(sql::_handler_rkey_function);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_40));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_41));
      }
    ;

handler_rkey_mode:
      EQ
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_rkey_mode);
      }
    | GE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_rkey_mode);
      }
    | LE
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_rkey_mode);
      }
    | GT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_rkey_mode);
      }
    | LT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_handler_rkey_mode);
      }
    ;

revoke:
      REVOKE clear_privileges revoke_command
      {
        $$= mysql_parser::new_ast_node(sql::_revoke);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REVOKE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

revoke_command:
      grant_privileges ON opt_table grant_ident FROM grant_list
      {
        $$= mysql_parser::new_ast_node(sql::_revoke_command);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $6);
      }
    | grant_privileges ON FUNCTION_SYM grant_ident FROM grant_list
      {
        $$= mysql_parser::new_ast_node(sql::_revoke_command);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $6);
      }
    | grant_privileges ON PROCEDURE grant_ident FROM grant_list
      {
        $$= mysql_parser::new_ast_node(sql::_revoke_command);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $6);
      }
    | ALL opt_privileges ',' GRANT OPTION FROM grant_list
      {
        $$= mysql_parser::new_ast_node(sql::_revoke_command);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALL));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_44));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_GRANT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_OPTION));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_FROM));
        mysql_parser::add_ast_child_node($$, $7);
      }
    ;

grant:
      GRANT clear_privileges grant_command
      {
        $$= mysql_parser::new_ast_node(sql::_grant);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GRANT));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

grant_command:
      grant_privileges ON opt_table grant_ident TO_SYM grant_list require_clause grant_options
      {
        $$= mysql_parser::new_ast_node(sql::_grant_command);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
      }
    | grant_privileges ON FUNCTION_SYM grant_ident TO_SYM grant_list require_clause grant_options
      {
        $$= mysql_parser::new_ast_node(sql::_grant_command);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
      }
    | grant_privileges ON PROCEDURE grant_ident TO_SYM grant_list require_clause grant_options
      {
        $$= mysql_parser::new_ast_node(sql::_grant_command);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ON));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
      }
    ;

opt_table:
      /* empty */
      {
        $$= NULL;
      }
    | TABLE_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_table);
      }
    ;

grant_privileges:
      object_privilege_list
      {
        $$= mysql_parser::new_ast_node(sql::_grant_privileges);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | ALL opt_privileges
      {
        $$= mysql_parser::new_ast_node(sql::_grant_privileges);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALL));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_privileges:
      /* empty */
      {
        $$= NULL;
      }
    | PRIVILEGES
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_privileges);
      }
    ;

object_privilege_list:
      object_privilege
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | object_privilege_list ',' object_privilege
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_object_privilege_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

object_privilege:
      SELECT_SYM opt_column_list
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SELECT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | INSERT opt_column_list
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INSERT));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | UPDATE_SYM opt_column_list
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UPDATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | REFERENCES opt_column_list
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REFERENCES));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | DELETE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DELETE_SYM));
      }
    | USAGE
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_USAGE));
      }
    | INDEX_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INDEX_SYM));
      }
    | ALTER
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
      }
    | CREATE
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
      }
    | DROP
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DROP));
      }
    | EXECUTE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EXECUTE_SYM));
      }
    | RELOAD
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RELOAD));
      }
    | SHUTDOWN
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SHUTDOWN));
      }
    | PROCESS
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PROCESS));
      }
    | FILE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FILE_SYM));
      }
    | GRANT OPTION
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GRANT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_OPTION));
      }
    | SHOW DATABASES
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SHOW));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_DATABASES));
      }
    | SUPER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUPER_SYM));
      }
    | CREATE TEMPORARY TABLES
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TEMPORARY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TABLES));
      }
    | LOCK_SYM TABLES
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_LOCK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TABLES));
      }
    | REPLICATION SLAVE
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPLICATION));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SLAVE));
      }
    | REPLICATION CLIENT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REPLICATION));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CLIENT_SYM));
      }
    | CREATE VIEW_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VIEW_SYM));
      }
    | SHOW VIEW_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SHOW));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VIEW_SYM));
      }
    | CREATE ROUTINE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ROUTINE_SYM));
      }
    | ALTER ROUTINE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALTER));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ROUTINE_SYM));
      }
    | CREATE USER
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CREATE));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_USER));
      }
    | EVENT_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_EVENT_SYM));
      }
    | TRIGGER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_object_privilege);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIGGER_SYM));
      }
    ;

opt_and:
      /* empty */
      {
        $$= NULL;
      }
    | AND_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_and);
      }
    ;

require_list:
      require_list_element opt_and require_list
      {
        $$= mysql_parser::new_ast_node(sql::_require_list);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::merge_ast_child_nodes($$, $3);
      }
    | require_list_element
      {
        $$= mysql_parser::new_ast_node(sql::_require_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

require_list_element:
      SUBJECT_SYM TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_require_list_element);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUBJECT_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TEXT_STRING));
      }
    | ISSUER_SYM TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_require_list_element);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ISSUER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TEXT_STRING));
      }
    | CIPHER_SYM TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_require_list_element);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_CIPHER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_TEXT_STRING));
      }
    ;

grant_ident:
      '*'
      {
        $$= mysql_parser::new_ast_node(sql::_grant_ident);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_42));
      }
    | ident '.' '*'
      {
        $$= mysql_parser::new_ast_node(sql::_grant_ident);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_42));
      }
    | '*' '.' '*'
      {
        $$= mysql_parser::new_ast_node(sql::_grant_ident);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_42));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_46));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_42));
      }
    | table_ident
      {
        $$= mysql_parser::new_ast_node(sql::_grant_ident);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

user_list:
      user
      {
        $$= mysql_parser::new_ast_node(sql::_user_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | user_list ',' user
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_user_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

grant_list:
      grant_user
      {
        $$= mysql_parser::new_ast_node(sql::_grant_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | grant_list ',' grant_user
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_grant_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

grant_user:
      user IDENTIFIED_SYM BY TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_grant_user);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IDENTIFIED_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_TEXT_STRING));
      }
    | user IDENTIFIED_SYM BY PASSWORD TEXT_STRING
      {
        $$= mysql_parser::new_ast_node(sql::_grant_user);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_IDENTIFIED_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_BY));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_PASSWORD));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_TEXT_STRING));
      }
    | user
      {
        $$= mysql_parser::new_ast_node(sql::_grant_user);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

opt_column_list:
      /* empty */
      {
        $$= NULL;
      }
    | '(' column_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_opt_column_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

column_list:
      column_list ',' column_list_id
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_column_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | column_list_id
      {
        $$= mysql_parser::new_ast_node(sql::_column_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

column_list_id:
      ident
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_column_list_id);
      }
    ;

require_clause:
      /* empty */
      {
        $$= NULL;
      }
    | REQUIRE_SYM require_list
      {
        $$= mysql_parser::new_ast_node(sql::_require_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REQUIRE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | REQUIRE_SYM SSL_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_require_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REQUIRE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SSL_SYM));
      }
    | REQUIRE_SYM X509_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_require_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REQUIRE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_X509_SYM));
      }
    | REQUIRE_SYM NONE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_require_clause);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_REQUIRE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NONE_SYM));
      }
    ;

grant_options:
      /* empty */
      {
        $$= NULL;
      }
    | WITH grant_option_list
      {
        $$= mysql_parser::new_ast_node(sql::_grant_options);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

grant_option_list:
      grant_option_list grant_option
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_grant_option_list);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | grant_option
      {
        $$= mysql_parser::new_ast_node(sql::_grant_option_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

grant_option:
      GRANT OPTION
      {
        $$= mysql_parser::new_ast_node(sql::_grant_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_GRANT));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_OPTION));
      }
    | MAX_QUERIES_PER_HOUR ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_grant_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_QUERIES_PER_HOUR));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | MAX_UPDATES_PER_HOUR ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_grant_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_UPDATES_PER_HOUR));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | MAX_CONNECTIONS_PER_HOUR ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_grant_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_CONNECTIONS_PER_HOUR));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | MAX_USER_CONNECTIONS_SYM ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_grant_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_MAX_USER_CONNECTIONS_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

begin:
      BEGIN_SYM opt_work
      {
        $$= mysql_parser::new_ast_node(sql::_begin);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_BEGIN_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_work:
      /* empty */
      {
        $$= NULL;
      }
    | WORK_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_work);
      }
    ;

opt_chain:
      /* empty */
      {
        $$= NULL;
      }
    | AND_SYM NO_SYM CHAIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_chain);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AND_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_NO_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_CHAIN_SYM));
      }
    | AND_SYM CHAIN_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_chain);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AND_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CHAIN_SYM));
      }
    ;

opt_release:
      /* empty */
      {
        $$= NULL;
      }
    | RELEASE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_release);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RELEASE_SYM));
      }
    | NO_SYM RELEASE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_release);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_NO_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_RELEASE_SYM));
      }
    ;

opt_savepoint:
      /* empty */
      {
        $$= NULL;
      }
    | SAVEPOINT_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_savepoint);
      }
    ;

commit:
      COMMIT_SYM opt_work opt_chain opt_release
      {
        $$= mysql_parser::new_ast_node(sql::_commit);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_COMMIT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

rollback:
      ROLLBACK_SYM opt_work opt_chain opt_release
      {
        $$= mysql_parser::new_ast_node(sql::_rollback);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ROLLBACK_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | ROLLBACK_SYM opt_work TO_SYM opt_savepoint ident
      {
        $$= mysql_parser::new_ast_node(sql::_rollback);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ROLLBACK_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TO_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

savepoint:
      SAVEPOINT_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_savepoint);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SAVEPOINT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

release:
      RELEASE_SYM SAVEPOINT_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_release);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_RELEASE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SAVEPOINT_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

union_clause:
      /* empty */
      {
        $$= NULL;
      }
    | union_list
      {
        $$= mysql_parser::new_ast_node(sql::_union_clause);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

union_list:
      UNION_SYM union_option select_init
      {
        $$= mysql_parser::new_ast_node(sql::_union_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNION_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

union_opt:
      /* empty */
      {
        $$= NULL;
      }
    | union_list
      {
        $$= mysql_parser::new_ast_node(sql::_union_opt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | union_order_or_limit
      {
        $$= mysql_parser::new_ast_node(sql::_union_opt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

union_order_or_limit:
      order_or_limit
      {
        $$= mysql_parser::new_ast_node(sql::_union_order_or_limit);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

order_or_limit:
      order_clause opt_limit_clause_init
      {
        $$= mysql_parser::new_ast_node(sql::_order_or_limit);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | limit_clause
      {
        $$= mysql_parser::new_ast_node(sql::_order_or_limit);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

union_option:
      /* empty */
      {
        $$= NULL;
      }
    | DISTINCT
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_union_option);
      }
    | ALL
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_union_option);
      }
    ;

take_first_select:
      /* empty */
      {
        $$= NULL;
      }
    ;

subselect:
      SELECT_SYM subselect_start select_init2 take_first_select subselect_end
      {
        $$= mysql_parser::new_ast_node(sql::_subselect);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SELECT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
      }
    | '(' subselect_start select_paren take_first_select subselect_end ')'
      {
        $$= mysql_parser::new_ast_node(sql::_subselect);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
      }
    ;

subselect_start:
      /* empty */
      {
        $$= NULL;
      }
    ;

subselect_end:
      /* empty */
      {
        $$= NULL;
      }
    ;

view_or_trigger_or_sp_or_event:
      definer definer_tail
      {
        $$= mysql_parser::new_ast_node(sql::_view_or_trigger_or_sp_or_event);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | no_definer no_definer_tail
      {
        $$= mysql_parser::new_ast_node(sql::_view_or_trigger_or_sp_or_event);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | view_replace_or_algorithm definer_opt view_tail
      {
        $$= mysql_parser::new_ast_node(sql::_view_or_trigger_or_sp_or_event);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

definer_tail:
      view_tail
      {
        $$= mysql_parser::new_ast_node(sql::_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | trigger_tail
      {
        $$= mysql_parser::new_ast_node(sql::_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_tail
      {
        $$= mysql_parser::new_ast_node(sql::_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sf_tail
      {
        $$= mysql_parser::new_ast_node(sql::_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | event_tail
      {
        $$= mysql_parser::new_ast_node(sql::_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

no_definer_tail:
      view_tail
      {
        $$= mysql_parser::new_ast_node(sql::_no_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | trigger_tail
      {
        $$= mysql_parser::new_ast_node(sql::_no_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sp_tail
      {
        $$= mysql_parser::new_ast_node(sql::_no_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | sf_tail
      {
        $$= mysql_parser::new_ast_node(sql::_no_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | udf_tail
      {
        $$= mysql_parser::new_ast_node(sql::_no_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | event_tail
      {
        $$= mysql_parser::new_ast_node(sql::_no_definer_tail);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

definer_opt:
      no_definer
      {
        $$= mysql_parser::new_ast_node(sql::_definer_opt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | definer
      {
        $$= mysql_parser::new_ast_node(sql::_definer_opt);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

no_definer:
      /* empty */
      {
        $$= NULL;
      }
    ;

definer:
      DEFINER_SYM EQ user
      {
        $$= mysql_parser::new_ast_node(sql::_definer);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_DEFINER_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

view_replace_or_algorithm:
      view_replace
      {
        $$= mysql_parser::new_ast_node(sql::_view_replace_or_algorithm);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | view_replace view_algorithm
      {
        $$= mysql_parser::new_ast_node(sql::_view_replace_or_algorithm);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    | view_algorithm
      {
        $$= mysql_parser::new_ast_node(sql::_view_replace_or_algorithm);
        mysql_parser::add_ast_child_node($$, $1);
      }
    ;

view_replace:
      OR_SYM REPLACE
      {
        $$= mysql_parser::new_ast_node(sql::_view_replace);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_OR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_REPLACE));
      }
    ;

view_algorithm:
      ALGORITHM_SYM EQ UNDEFINED_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_view_algorithm);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALGORITHM_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_UNDEFINED_SYM));
      }
    | ALGORITHM_SYM EQ MERGE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_view_algorithm);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALGORITHM_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_MERGE_SYM));
      }
    | ALGORITHM_SYM EQ TEMPTABLE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_view_algorithm);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ALGORITHM_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_EQ));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_TEMPTABLE_SYM));
      }
    ;

view_suid:
      /* empty */
      {
        $$= NULL;
      }
    | SQL_SYM SECURITY_SYM DEFINER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_view_suid);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SECURITY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_DEFINER_SYM));
      }
    | SQL_SYM SECURITY_SYM INVOKER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_view_suid);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SQL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_SECURITY_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_INVOKER_SYM));
      }
    ;

view_tail:
      view_suid VIEW_SYM table_ident view_list_opt AS view_select
      {
        $$= mysql_parser::new_ast_node(sql::_view_tail);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_VIEW_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_AS));
        mysql_parser::add_ast_child_node($$, $6);
      }
    ;

view_list_opt:
      /* empty */
      {
        $$= NULL;
      }
    | '(' view_list ')'
      {
        $$= mysql_parser::new_ast_node(sql::_view_list_opt);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
      }
    ;

view_list:
      ident
      {
        $$= mysql_parser::new_ast_node(sql::_view_list);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | view_list ',' ident
      {
        $$= mysql_parser::reuse_ast_node($1, sql::_view_list);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

view_select:
      view_select_aux view_check_option
      {
        $$= mysql_parser::new_ast_node(sql::_view_select);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

view_select_aux:
      SELECT_SYM select_init2
      {
        $$= mysql_parser::new_ast_node(sql::_view_select_aux);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SELECT_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    | '(' select_paren ')' union_opt
      {
        $$= mysql_parser::new_ast_node(sql::_view_select_aux);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_40));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_41));
        mysql_parser::add_ast_child_node($$, $4);
      }
    ;

view_check_option:
      /* empty */
      {
        $$= NULL;
      }
    | WITH CHECK_SYM OPTION
      {
        $$= mysql_parser::new_ast_node(sql::_view_check_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CHECK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_OPTION));
      }
    | WITH CASCADED CHECK_SYM OPTION
      {
        $$= mysql_parser::new_ast_node(sql::_view_check_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_CASCADED));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_CHECK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_OPTION));
      }
    | WITH LOCAL_SYM CHECK_SYM OPTION
      {
        $$= mysql_parser::new_ast_node(sql::_view_check_option);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_WITH));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_LOCAL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_CHECK_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_OPTION));
      }
    ;

trigger_tail:
      TRIGGER_SYM remember_name sp_name trg_action_time trg_event ON remember_name table_ident FOR_SYM remember_name EACH_SYM ROW_SYM sp_proc_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_trigger_tail);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_TRIGGER_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_ON));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($9, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, $10);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($11, sql::_EACH_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($12, sql::_ROW_SYM));
        mysql_parser::add_ast_child_node($$, $13);
      }
    ;

udf_tail:
      AGGREGATE_SYM remember_name FUNCTION_SYM ident RETURNS_SYM udf_type SONAME_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_udf_tail);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_AGGREGATE_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($3, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $4);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($5, sql::_RETURNS_SYM));
        mysql_parser::add_ast_child_node($$, $6);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_SONAME_SYM));
        mysql_parser::add_ast_child_node($$, $8);
      }
    | remember_name FUNCTION_SYM ident RETURNS_SYM udf_type SONAME_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_udf_tail);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_RETURNS_SYM));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_SONAME_SYM));
        mysql_parser::add_ast_child_node($$, $7);
      }
    ;

sf_tail:
      remember_name FUNCTION_SYM sp_name '(' sp_fdparam_list ')' RETURNS_SYM type sp_c_chistics sp_proc_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_sf_tail);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_FUNCTION_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($7, sql::_RETURNS_SYM));
        mysql_parser::add_ast_child_node($$, $8);
        mysql_parser::add_ast_child_node($$, $9);
        mysql_parser::add_ast_child_node($$, $10);
      }
    ;

sp_tail:
      PROCEDURE remember_name sp_name '(' sp_pdparam_list ')' sp_c_chistics sp_proc_stmt
      {
        $$= mysql_parser::new_ast_node(sql::_sp_tail);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_PROCEDURE));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_40));
        mysql_parser::add_ast_child_node($$, $5);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($6, sql::_41));
        mysql_parser::add_ast_child_node($$, $7);
        mysql_parser::add_ast_child_node($$, $8);
      }
    ;

xa:
      XA_SYM begin_or_start xid opt_join_or_resume
      {
        $$= mysql_parser::new_ast_node(sql::_xa);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_XA_SYM));
        mysql_parser::add_ast_child_node($$, $2);
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | XA_SYM END xid opt_suspend
      {
        $$= mysql_parser::new_ast_node(sql::_xa);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_XA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_END));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | XA_SYM PREPARE_SYM xid
      {
        $$= mysql_parser::new_ast_node(sql::_xa);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_XA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PREPARE_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | XA_SYM COMMIT_SYM xid opt_one_phase
      {
        $$= mysql_parser::new_ast_node(sql::_xa);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_XA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_COMMIT_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, $4);
      }
    | XA_SYM ROLLBACK_SYM xid
      {
        $$= mysql_parser::new_ast_node(sql::_xa);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_XA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_ROLLBACK_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | XA_SYM RECOVER_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_xa);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_XA_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_RECOVER_SYM));
      }
    ;

xid:
      text_string
      {
        $$= mysql_parser::new_ast_node(sql::_xid);
        mysql_parser::add_ast_child_node($$, $1);
      }
    | text_string ',' text_string
      {
        $$= mysql_parser::new_ast_node(sql::_xid);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
      }
    | text_string ',' text_string ',' ulong_num
      {
        $$= mysql_parser::new_ast_node(sql::_xid);
        mysql_parser::add_ast_child_node($$, $1);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_44));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_44));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

begin_or_start:
      BEGIN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_begin_or_start);
      }
    | START_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_begin_or_start);
      }
    ;

opt_join_or_resume:
      /* empty */
      {
        $$= NULL;
      }
    | JOIN_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_join_or_resume);
      }
    | RESUME_SYM
      {
        $$= mysql_parser::set_ast_node_name($1, sql::_opt_join_or_resume);
      }
    ;

opt_one_phase:
      /* empty */
      {
        $$= NULL;
      }
    | ONE_SYM PHASE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_one_phase);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_ONE_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PHASE_SYM));
      }
    ;

opt_suspend:
      /* empty */
      {
        $$= NULL;
      }
    | SUSPEND_SYM opt_migrate
      {
        $$= mysql_parser::new_ast_node(sql::_opt_suspend);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_SUSPEND_SYM));
        mysql_parser::add_ast_child_node($$, $2);
      }
    ;

opt_migrate:
      /* empty */
      {
        $$= NULL;
      }
    | FOR_SYM MIGRATE_SYM
      {
        $$= mysql_parser::new_ast_node(sql::_opt_migrate);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_FOR_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_MIGRATE_SYM));
      }
    ;

install:
      INSTALL_SYM PLUGIN_SYM ident SONAME_SYM TEXT_STRING_sys
      {
        $$= mysql_parser::new_ast_node(sql::_install);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_INSTALL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PLUGIN_SYM));
        mysql_parser::add_ast_child_node($$, $3);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($4, sql::_SONAME_SYM));
        mysql_parser::add_ast_child_node($$, $5);
      }
    ;

uninstall:
      UNINSTALL_SYM PLUGIN_SYM ident
      {
        $$= mysql_parser::new_ast_node(sql::_uninstall);
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($1, sql::_UNINSTALL_SYM));
        mysql_parser::add_ast_child_node($$, mysql_parser::set_ast_node_name($2, sql::_PLUGIN_SYM));
        mysql_parser::add_ast_child_node($$, $3);
      }
    ;

