#include "stdafx.h"

#include "mysql_sql_editor_be.h"


using namespace bec;
using namespace grt;


Mysql_sql_editor::Mysql_sql_editor(db_mgmt_RdbmsRef rdbms)
:
Sql_editor(rdbms)
{
}


Mysql_sql_editor::~Mysql_sql_editor()
{
}


const char *Mysql_sql_editor::get_keywords(KeywordList list) const
{
  const static char general_keywords[] =
  "accessible add all alter analyze and as asc asensitive "
  "before between bigint binary blob both by "
  "call cascade case change char character check collate column condition connection constraint "
  "continue convert create cross current_date current_time current_timestamp current_user cursor "
  "database databases day_hour day_microsecond day_minute day_second dec decimal declare default "
  "delayed delete desc describe deterministic distinct distinctrow div double drop dual "
  "each else elseif enclosed escaped exists exit explain "
  "false fetch float float4 float8 for force foreign from fulltext "
  "goto grant group "
  "having high_priority hour_microsecond hour_minute hour_second "
  "if ignore in index infile inner inout insensitive insert int int1 int2 int3 int4 int8 integer "
  "interval into is iterate "
  "join "
  "key keys kill "
  "label leading leave left like limit linear lines load localtime localtimestamp lock long "
  "longblob longtext loop low_priority "
  "master_ssl_verify_server_cert match mediumblob mediumint mediumtext middleint minute_microsecond "
  "minute_second mod modifies "
  "natural not no_write_to_binlog null numeric "
  "on optimize option optionally or order out outer outfile "
  "precision primary procedure purge "
  "range read reads read_only read_write real references regexp release rename repeat replace "
  "require restrict return revoke right rlike "
  "schema schemas second_microsecond select sensitive separator set show smallint spatial specific "
  "sql sqlexception sqlstate sqlwarning sql_big_result sql_calc_found_rows sql_small_result ssl "
  "starting straight_join "
  "table terminated then tinyblob tinyint tinytext to trailing trigger true "
  "undo union unique unlock unsigned update upgrade usage use using utc_date utc_time utc_timestamp "
  "values varbinary varchar varcharacter varying "
  "when where while with write "
  "xor "
  "year_month "
  "zerofill";
  
  const static char procedure_keywords[] = // Not reserved words but intrinsic part of procedure definitions.
  "begin comment end";
  
  const static char client_keywords[] = // Definition of keywords only used by clients, not the server itself.
  "delimiter";
  
  const static char user_keywords[] = // Definition of own keywords, not used by MySQL.
  "edit";

  switch (list)
  {
    case Procedure_Keywords:
      return procedure_keywords;
    case Client_Keywords:
      return client_keywords;
    case User_Keywords:
      return user_keywords;
    default:
      return general_keywords;
  }
}

const char *Mysql_sql_editor::get_function_names() const
{
  const static char function_names[] =
  "abs acos adddate aes_encrypt aes_decrypt ascii asin atan atan2 benchmark bin bit_count bit_or "
  "bit_and cast ceil ceiling current_user bit_length char_length character_length coalesce "
  "concat concat_ws connection_id conv convert count cos cot curdate curtime date_add date_format "
  "date_sub dayname dayofmonth dayofweek dayofyear decode degrees des_encrypt des_decrypt elt "
  "encode encrypt extract exp export_set field find_in_set floor format found_rows from_days "
  "from_unixtime get_lock greatest group_concat group_unique_users hex ifnull inet_aton inet_ntoa "
  "instr isnull is_free_lock last_insert_id lcase least length ln load_file locate log log2 log10 "
  "lower lpad ltrim make_set master_pos_wait max md5 mid min mod monthname now nullif octet_length "
  "oct old_password ord period_add period_diff pi position pow power quarter quote radians rand "
  "release_lock repeat reverse round rpad rtrim sec_to_time session_user subdate sign sin sha "
  "sha1 soundex space sqrt std stddev strcmp substring substring_index sum sysdate system_user "
  "tan time_format time_to_sec to_days trim ucase unique_users unix_timestamp upper user version "
  "week weekday yearweek";
  
  return function_names;
}
