/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"

#include "mysql_sql_facade.h"
#include "mysql_sql_parser.h"
#include "mysql_sql_specifics.h"
#include "mysql_sql_normalizer.h"
#include "mysql_sql_inserts_loader.h"
#include "mysql_sql_schema_rename.h"
#include "mysql_sql_syntax_check.h"
#include "mysql_sql_semantic_check.h"
#include "mysql_invalid_sql_parser.h"
#include "mysql_sql_script_splitter.h"
#include "mysql_sql_statement_decomposer.h"
#include "mysql_sql_schema_rename.h"


using namespace bec;


int MysqlSqlFacadeImpl::splitSqlScript(const std::string &sql, std::list<std::string> &statements)
{
  return Mysql_sql_script_splitter::create()->process(sql, statements);
}


Sql_parser::Ref MysqlSqlFacadeImpl::sqlParser()
{
  return Mysql_sql_parser::create(get_grt());
}


int MysqlSqlFacadeImpl::parseSqlScriptString(db_CatalogRef catalog, const std::string sql)
{
  return parseSqlScriptStringEx(catalog, sql, DictRef());
}


int MysqlSqlFacadeImpl::parseSqlScriptStringEx(db_CatalogRef catalog, const std::string sql, const grt::DictRef options)
{
  return Mysql_sql_parser::create(get_grt())->parse_sql_script(
    db_mysql_CatalogRef::cast_from(catalog), sql, options);
}


int MysqlSqlFacadeImpl::parseSqlScriptFile(db_CatalogRef catalog, const std::string filename)
{
  return parseSqlScriptFileEx(catalog, filename, DictRef());
}


int MysqlSqlFacadeImpl::parseSqlScriptFileEx(db_CatalogRef catalog, const std::string filename, const grt::DictRef options)
{
  return Mysql_sql_parser::create(get_grt())->parse_sql_script_file(
    db_mysql_CatalogRef::cast_from(catalog), filename, options);
}


Invalid_sql_parser::Ref MysqlSqlFacadeImpl::invalidSqlParser()
{
  return Mysql_invalid_sql_parser::create(get_grt());
}


int MysqlSqlFacadeImpl::parseInserts(db_TableRef table, const std::string sql)
{
  return Mysql_invalid_sql_parser::create(get_grt())->parse_inserts(db_mysql_TableRef::cast_from(table), sql);
}


int MysqlSqlFacadeImpl::parseTriggers(db_TableRef table, const std::string sql)
{
  return Mysql_invalid_sql_parser::create(get_grt())->parse_triggers(db_mysql_TableRef::cast_from(table), sql);
}


int MysqlSqlFacadeImpl::parseRoutine(db_RoutineRef routine, const std::string sql)
{
  return Mysql_invalid_sql_parser::create(get_grt())->parse_routine(db_mysql_RoutineRef::cast_from(routine), sql);
}


int MysqlSqlFacadeImpl::parseRoutines(db_RoutineGroupRef routineGroup, const std::string sql)
{
  return Mysql_invalid_sql_parser::create(get_grt())->parse_routines(db_mysql_RoutineGroupRef::cast_from(routineGroup), sql);
}


int MysqlSqlFacadeImpl::parseView(db_ViewRef view, const std::string sql)
{
  return Mysql_invalid_sql_parser::create(get_grt())->parse_view(db_mysql_ViewRef::cast_from(view), sql);
}


Sql_syntax_check::Ref MysqlSqlFacadeImpl::sqlSyntaxCheck()
{
  return Mysql_sql_syntax_check::create(get_grt());
}


int MysqlSqlFacadeImpl::checkSqlSyntax(const std::string sql)
{
  return Mysql_sql_syntax_check::create(get_grt())->check_sql(sql);
}


int MysqlSqlFacadeImpl::checkTriggerSyntax(const std::string sql)
{
  return Mysql_sql_syntax_check::create(get_grt())->check_trigger(sql);
}


int MysqlSqlFacadeImpl::checkViewSyntax(const std::string sql)
{
  return Mysql_sql_syntax_check::create(get_grt())->check_view(sql);
}


int MysqlSqlFacadeImpl::checkRoutineSyntax(const std::string sql)
{
  return Mysql_sql_syntax_check::create(get_grt())->check_routine(sql);
}


Sql_semantic_check::Ref MysqlSqlFacadeImpl::sqlSemanticCheck()
{
  return Mysql_sql_semantic_check::create(get_grt());
}


Sql_specifics::Ref MysqlSqlFacadeImpl::sqlSpecifics()
{
  return Mysql_sql_specifics::create(get_grt());
}


Sql_normalizer::Ref MysqlSqlFacadeImpl::sqlNormalizer()
{
  return Mysql_sql_normalizer::create(get_grt());
}


std::string MysqlSqlFacadeImpl::normalizeSqlStatement(const std::string sql, const std::string schema_name)
{
  return Mysql_sql_normalizer::create(get_grt())->normalize(sql, schema_name);
}


Sql_inserts_loader::Ref MysqlSqlFacadeImpl::sqlInsertsLoader()
{
  return Mysql_sql_inserts_loader::create(get_grt());
}


Sql_schema_rename::Ref MysqlSqlFacadeImpl::sqlSchemaRenamer()
{
  return Mysql_sql_schema_rename::create(get_grt());
}


int MysqlSqlFacadeImpl::renameSchemaReferences(db_CatalogRef catalog, const std::string old_schema_name, const std::string new_schema_name)
{
  return Mysql_sql_schema_rename::create(get_grt())->rename_schema_references(
    catalog, old_schema_name, new_schema_name);
}


Sql_statement_decomposer::Ref MysqlSqlFacadeImpl::sqlStatementDecomposer()
{
  return Mysql_sql_statement_decomposer::create(get_grt());
}
