/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _MYSQL_SQL_SPECIFICS_H_
#define _MYSQL_SQL_SPECIFICS_H_


#include "mysql_sql_parser_base.h"
#include "grtsqlparser/sql_specifics.h"


/** Implements DBMS specifics.
 * 
 * @ingroup sqlparser
 */
class MYSQL_SQL_PARSER_PUBLIC_FUNC Mysql_sql_specifics : public Sql_specifics
{
public:
  typedef boost::shared_ptr<Mysql_sql_specifics> Ref;
  static Ref create(grt::GRT *grt) { return Ref(new Mysql_sql_specifics(grt)); }
  virtual ~Mysql_sql_specifics() {}
protected:
  Mysql_sql_specifics(grt::GRT *grt);

public:
  std::string limit_select_query(const std::string &sql, int &row_count, int &offset);
  void get_connection_startup_script(std::list<std::string> &sql_script);
  std::string query_connection_id();
  std::string query_kill_connection(int connection_id);
  sqlide::QuoteVar::Escape_sql_string escape_sql_string();
  std::string setting_non_std_sql_delimiter();
  std::string non_std_sql_delimiter();
};


#endif // _MYSQL_SQL_SPECIFICS_H_
