/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _MYSQL_SQL_SYNTAX_CHECK_H_
#define _MYSQL_SQL_SYNTAX_CHECK_H_


#include "mysql_sql_parser_base.h"
#include "grtsqlparser/sql_syntax_check.h"


/** Implements DBMS specifics.
 * 
 * @ingroup sqlparser
 */
class MYSQL_SQL_PARSER_PUBLIC_FUNC Mysql_sql_syntax_check
  : virtual protected Mysql_sql_parser_base, virtual public Sql_syntax_check
{
public:
  typedef boost::shared_ptr<Mysql_sql_syntax_check> Ref;
  static Ref create(grt::GRT *grt) { return Ref(new Mysql_sql_syntax_check(grt)); }
  virtual ~Mysql_sql_syntax_check() {}
protected:
  Mysql_sql_syntax_check(grt::GRT *grt);

public:
  Statement_type determine_statement_type(const std::string &sql);

public:
  bool parse_edit_statement(const std::string &sql, std::string &schema_name, std::string &table_name, std::string &statement_tail);

public:
  int check_sql(const std::string &sql);
  int check_trigger(const std::string &sql);
  int check_view(const std::string &sql);
  int check_routine(const std::string &sql);

protected:
  typedef sigc::slot<Parse_result, const SqlAstNode *> Check_sql_statement;
  Check_sql_statement _check_sql_statement;

  int process_sql_statement(const SqlAstNode *tree);
  int check_sql_statement(const std::string &sql, Check_sql_statement check_sql_statement);

  Parse_result do_check_sql(const SqlAstNode *tree);
  Parse_result do_check_trigger(const SqlAstNode *tree);
  Parse_result do_check_view(const SqlAstNode *tree);
  Parse_result do_check_routine(const SqlAstNode *tree);
  Parse_result do_parse_edit_statement(const SqlAstNode *tree, std::string &schema_name, std::string &table_name, std::string &statement_tail);

  virtual Parse_result check_sql(const SqlAstNode *tree);
  virtual Parse_result check_trigger(const SqlAstNode *tree, const SqlAstNode *trigger_tail);
  virtual Parse_result check_view(const SqlAstNode *tree, const SqlAstNode *view_tail);
  virtual Parse_result check_routine(const SqlAstNode *tree, const SqlAstNode *routine_tail);

  bool _use_delimiter;

  class Null_state_keeper : Mysql_sql_parser_base::Null_state_keeper
  {
  public:
    Null_state_keeper(Mysql_sql_syntax_check *sql_parser)
      : Mysql_sql_parser_base::Null_state_keeper(sql_parser), _sql_parser(sql_parser) {}
    ~Null_state_keeper();
  private:
    Mysql_sql_syntax_check *_sql_parser;
  };
};


#endif // _MYSQL_SQL_SYNTAX_CHECK_H_
