#include "wb_config.h"
#include "linux_utilities/plugin_editor_base.h"
#include "../backend/mysql_view_editor.h"
#include "linux_utilities/MGGladeXML.h"
#include "grtdb/db_object_helpers.h"
#include "treemodel_wrapper.h"
#include "sql_editor_fe.h"
#include "mysql_editor_priv_page.h"

//==============================================================================
//
//==============================================================================
class DbMySQLViewEditor : public PluginEditorBase
{
  MySQLViewEditorBE                 *_be;
  DbMySQLEditorPrivPage             *_privs_page;
  
  virtual bec::BaseEditor *get_be();
  
 public:
  DbMySQLViewEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args);
  
  virtual ~DbMySQLViewEditor();
  virtual void do_refresh_form_data();
  virtual std::string get_title();

  virtual bool switch_edited_object(bec::GRTManager *grtm, const grt::BaseListRef &args);
  
 private:
  void sql_changed(const std::string& sql);
  void set_comment(const std::string& txt);
   
  SqlEditorFE           _sql_editor;
};

DbMySQLViewEditor::DbMySQLViewEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args)
    : PluginEditorBase(m ,grtm, args, "modules/data/editor_view.glade")
    , _be(new MySQLViewEditorBE(grtm, db_mysql_ViewRef::cast_from(args[0]), get_rdbms_for_db_object(args[0])))
{
  xml()->get("mysql_view_editor_notebook", &_editor_notebook);

  Gtk::Image *image;
  xml()->get("view_editor_image", &image);
  image->set(ImageCache::get_instance()->image_from_filename("db.View.editor.48x48.png", false));
  xml()->get("view_editor_image2", &image);
  image->set(ImageCache::get_instance()->image_from_filename("db.View.editor.48x48.png", false));

  _be->set_refresh_ui_slot(sigc::mem_fun(this, &DbMySQLViewEditor::refresh_form_data));
  
  _editor_notebook->reparent(*this);
  _editor_notebook->show();

  Gtk::TextView *tview(0);
  xml()->get("viewcomment", &tview);
  if (!_be->is_editing_live_object())
    add_text_change_timer(tview, sigc::mem_fun(this, &DbMySQLViewEditor::set_comment));

  _sql_editor.be(_be->get_sql_editor());

  Gtk::Frame *ddl_win;
  xml()->get("view_ddl", &ddl_win);
  _sql_editor.widget().set_size_request(-1, 100);
  ddl_win->add(_sql_editor.widget());
  add_sqleditor_text_change_timer(&_sql_editor, sigc::mem_fun(this, &DbMySQLViewEditor::sql_changed));
  ddl_win->resize_children();

  if (!is_editing_live_object())
  {
    _privs_page     = new DbMySQLEditorPrivPage(_be);
    _editor_notebook->append_page(_privs_page->page(), "Privileges");
  }
  else
  {
    _editor_notebook->remove_page(1);
    _privs_page= NULL;
  }
    
  refresh_form_data();

  std::string query(_be->get_query());
  _sql_editor.set_text(query);

  show_all();
}

//------------------------------------------------------------------------------
DbMySQLViewEditor::~DbMySQLViewEditor()
{
  delete _privs_page;
  
  delete _be;
}

//------------------------------------------------------------------------------
bool DbMySQLViewEditor::switch_edited_object(bec::GRTManager *grtm, const grt::BaseListRef &args)
{
  MySQLViewEditorBE *old_be = _be;
  
  _be = new MySQLViewEditorBE(grtm, db_mysql_ViewRef::cast_from(args[0]), get_rdbms_for_db_object(args[0]));

  if (!is_editing_live_object())
    _privs_page->switch_be(_be);
  
  _be->set_refresh_ui_slot(sigc::mem_fun(this, &DbMySQLViewEditor::refresh_form_data));

  _sql_editor.be(_be->get_sql_editor());

  std::string query(_be->get_query());
  _sql_editor.set_text(query);

  do_refresh_form_data();
  
  delete old_be;
  old_be = 0;

  return true;
}

//------------------------------------------------------------------------------
void DbMySQLViewEditor::set_comment(const std::string& txt)
{
  if (_be)
    _be->set_comment(txt);
}

//------------------------------------------------------------------------------
std::string DbMySQLViewEditor::get_title()
{
  return strfmt(_("View: %s"), _be->get_name().c_str());
}

//------------------------------------------------------------------------------
bec::BaseEditor *DbMySQLViewEditor::get_be()
{
  return _be;
}

//------------------------------------------------------------------------------
void DbMySQLViewEditor::do_refresh_form_data()
{
  Gtk::Entry* entry(0);
  xml()->get("view_name", &entry);
  if (entry->get_text() != _be->get_name())
  {
    entry->set_text(_be->get_name());
    _signal_title_changed.emit(get_title());
  }

  if (!_be->is_editing_live_object())
  {
    Gtk::TextView *tview(0);
    xml()->get("viewcomment", &tview);
    tview->get_buffer()->set_text(_be->get_comment());
  }
  _sql_editor.set_text(_be->get_query());

  if (!is_editing_live_object())
    _privs_page->refresh();
}

//------------------------------------------------------------------------------
void DbMySQLViewEditor::sql_changed(const std::string& sql)
{
  _sql_editor.reset_sql_check_state();
  _be->set_query(sql, false);
}

//------------------------------------------------------------------------------
extern "C" 
{
  GUIPluginBase *createDbMysqlViewEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args)
  {
    return Gtk::manage(new DbMySQLViewEditor(m, grtm, args));
  }
};
