
/*!
 Copyright 2009 Sun Microsystems, Inc.
 */


#import "WBPluginEditorBase.h"

#if 0 // editor_table_inserts.h was replaced with recordset_table_inserts_storage_be.h
#import "editor_table_inserts.h"
#endif

#include "wb_config.h"

@class DbPrivilegeEditorTab;


class MySQLTableEditorBE;
class MySQLTablePartitionTreeBE;

@class MacTableEditorInformationSource;
@class MacTableEditorColumnsInformationSource;
@class MacTableEditorIndexColumnsInformationSource;
@class MacTableEditorFKColumnsInformationSource;
@class GRTTreeDataSource;
@class MResultsetViewer;

@interface DbMysqlTableEditor : WBPluginEditorBase
{
  IBOutlet NSTabView* mEditorsTabView;
  
  // Table
  IBOutlet NSView* mEditorTable;
  IBOutlet NSTextField* mTableName;
  IBOutlet NSPopUpButton* mTableCollation;
  IBOutlet NSPopUpButton* mTableEngine;
  IBOutlet NSTextView* mTableComment;
  
  // Columns
  IBOutlet NSView* mEditorColumns;
  IBOutlet NSTableView* mColumnsTable;
  IBOutlet NSPopUpButton* mColumnsCollation;
  IBOutlet NSTextView* mColumnsComment;
  IBOutlet NSTextField* mColumnsCommentLabel;
  IBOutlet NSBox* mColumnsDetailsBox;
  IBOutlet NSTextField* mColumnFlagsLabel;
  NSMutableArray* mColumnFlagCheckboxes;
  
  // Indices
  IBOutlet NSView* mEditorIndices;
  IBOutlet NSTableView* mIndicesTable;
  IBOutlet NSTableView* mIndexColumnsTable;
  IBOutlet NSPopUpButton* mIndicesStorageTypes;
  IBOutlet NSTextField* mIndicesBlockSize;
  IBOutlet NSTextField* mIndicesParser;
  IBOutlet NSTextView* mIndicesComment;
  IBOutlet NSBox* mIndicesDetailsBox;
  
  // Foreigh Keys
  IBOutlet NSView* mEditorForeignKeys;
  IBOutlet NSTableView* mFKTable;
  IBOutlet NSTableView* mFKColumnsTable;
  IBOutlet NSPopUpButton* mFKOnUpdate;
  IBOutlet NSPopUpButton* mFKOnDelete;
  IBOutlet NSTextView* mFKComment;
  IBOutlet NSBox* mFKDetailsBox;

  // Triggers
  IBOutlet ScintillaView* mEditorTriggers;
  
  // Partitioning
  IBOutlet NSView* mEditorPartitioning;
  IBOutlet NSButton* mPartitionEnabledCheckbox;
  IBOutlet NSPopUpButton* mPartitionPopup;
  IBOutlet NSPopUpButton* mSubpartitionPopup;
  IBOutlet NSTextField* mPartitionParametersTextField;  
  IBOutlet NSTextField* mSubPartitionParametersTextField;  
  IBOutlet NSComboBox* mPartitionCountCombo;
  IBOutlet NSComboBox* mSubpartitionCountCombo;
  IBOutlet NSButton* mPartitionManualCheckbox;
  IBOutlet NSButton* mSubpartitionManualCheckbox;
  IBOutlet NSOutlineView* mPartitionTable;
  
  // Options
  IBOutlet NSView* mEditorOptions;
  IBOutlet NSPopUpButton* mOptionsPackKeys;
  IBOutlet NSTextField* mOptionsTablePassword;
  IBOutlet NSTextField* mOptionsAutoIncrement;
  IBOutlet NSButton* mOptionsDelayKeyUpdates;
  IBOutlet NSPopUpButton* mOptionsRowFormat;
  IBOutlet NSTextField* mOptionsAvgRowLength;
  IBOutlet NSTextField* mOptionsMinRows;
  IBOutlet NSTextField* mOptionsMaxRows;
  IBOutlet NSButton* mOptionsUseChecksum;
  IBOutlet NSTextField* mOptionsDataDirectory;
  IBOutlet NSTextField* mOptionsIndexDirectory;
  IBOutlet NSTextField* mOptionsUnionTables;
  IBOutlet NSPopUpButton* mOptionsMergeMethod;

  // Inserts
  IBOutlet NSView* mEditorInserts;
  MResultsetViewer* mEditorInsertsController;

//this has changed in 5.2  ::bec::TableInsertsGridBE* mGrid;
  
  MySQLTableEditorBE* mBackEnd;
  MacTableEditorColumnsInformationSource* mColumnsDataSource;
  NSArray* mColumnTypes;
  MacTableEditorInformationSource* mIndicesDataSource;
  MacTableEditorIndexColumnsInformationSource* mIndexColumnsDataSource;
  MacTableEditorInformationSource* mFKDataSource;
  MacTableEditorFKColumnsInformationSource* mFKColumnsDataSource;
  GRTTreeDataSource* mPartitionsTreeDataSource;
  
  // Syntax error checking.
  NSTimer* mSyntaxCheckTimer;
  int mErrorCount;
  
  DbPrivilegeEditorTab *mPrivilegesTab;
  
  BOOL mDidAwakeFromNib;
}


- (IBAction) userPickPopup: (id) sender;
- (IBAction) userClickButton: (id) sender;

// Setup for code editor and syntax checking.
- (void) setupEditor;
- (void) resetSyntaxErrors;
- (void) checkSyntax:(NSTimer*) timer;

@end


