//
//  MySQLRoutineEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 22/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WBPluginEditorBase.h"

#include "mysql_routine_editor.h"

@interface DbMysqlRoutineEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet NSTextField *nameText;
  
  IBOutlet ScintillaView *codeText;
  
  MySQLRoutineEditorBE *mBackEnd;
  
  // Syntax error checking.
  NSTimer* mSyntaxCheckTimer;
  int mErrorCount;
  
  BOOL mNeedsInit;
}

- (void) updateBackend;

// Setup for code editor and syntax checking.
- (void) setupEditor;
- (void) resetSyntaxErrors;
- (void) checkSyntax:(NSTimer*) timer;

@end
