//
//  MySQLViewEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 22/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WBPluginEditorBase.h"

#include "mysql_view_editor.h"

@class DbPrivilegeEditorTab;

@interface DbMysqlViewEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet NSTextField *nameText;
  
  IBOutlet ScintillaView *codeText;
  IBOutlet NSTextView *commentText;
  
  MySQLViewEditorBE *mBackEnd;
  DbPrivilegeEditorTab *mPrivileges;
  
  // Syntax error checking.
  NSTimer* mSyntaxCheckTimer;
  int mErrorCount;
  
  BOOL mNeedsInit;
}

// Setup for code editor and syntax checking.
- (void) setupEditor;
- (void) resetSyntaxErrors;
- (void) checkSyntax:(NSTimer*) timer;

@end
