#include "stdafx.h"

#include "wb_config.h"


#include "grtpp.h"
#include "interfaces/plugin.h"

#include "grts/structs.db.mgmt.h"
#include "grtui/grt_wizard_plugin.h"

#define MODULE_VERSION "1.0.0"


static grt::ListRef<app_Plugin> get_mysql_plugins_info(grt::GRT *grt);


class MySQLDbModuleImpl : public grt::ModuleImplBase, public PluginInterfaceImpl
{
public:
  MySQLDbModuleImpl(grt::CPPModuleLoader *ldr)
  : grt::ModuleImplBase(ldr)
  {
  }

  DEFINE_INIT_MODULE(MODULE_VERSION, "MySQL AB", grt::ModuleImplBase,
    DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::getPluginInfo), 
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runExportCREATEScriptWizard),
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runExportALTERScriptWizard),
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runSynchronizeScriptWizard),
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runImportScriptWizard),
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runDbSynchronizeWizard),
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runDbImportWizard),
                     DECLARE_MODULE_FUNCTION(MySQLDbModuleImpl::runDbExportWizard),
                     NULL);

  int runExportCREATEScriptWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createExportCREATEScriptWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createExportCREATEScriptWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  int runExportALTERScriptWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createExportALTERScriptWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createExportALTERScriptWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  int runSynchronizeScriptWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createSynchronizeScriptWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createSynchronizeScriptWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  int runImportScriptWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createImportScriptWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createImportScriptWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  int runDbSynchronizeWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createDbSynchronizeWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createDbSynchronizeWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  int runDbImportWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createDbImportWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createDbImportWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  int runDbExportWizard(db_CatalogRef catalog)
  {
    extern grtui::WizardPlugin *createDbExportWizard(grt::Module *module, db_CatalogRef catalog);
    
    grtui::WizardPlugin *wizard= createDbExportWizard(this, catalog);
    int rc= wizard->run_wizard();
    delete wizard;
    
    return rc;    
  }
  
  virtual grt::ListRef<app_Plugin> getPluginInfo()
  {
    return get_mysql_plugins_info(get_grt());
  }
};



static void set_object_argument(app_PluginRef &plugin, const std::string &struct_name)
{
  app_PluginObjectInputRef pdef(plugin.get_grt());

  pdef->objectStructName(struct_name);
  pdef->owner(plugin);

  plugin->inputValues().insert(pdef);
}



static grt::ListRef<app_Plugin> get_mysql_plugins_info(grt::GRT *grt)
{
  grt::ListRef<app_Plugin> plugins(grt);
  app_PluginRef diff_sql_generator(grt);

  {
    app_PluginRef plugin(grt);

    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runExportCREATEScriptWizard");
    plugin->name("db.mysql.plugin.export.sql");
    plugin->caption("Export MySQL SQL Script");
    plugin->groups().insert("database/Database");

    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);

    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);

    plugins.insert(plugin);
  }

  {
    app_PluginRef plugin(grt);
    
    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runExportALTERScriptWizard");
    plugin->name("db.mysql.plugin.export.alter");
    plugin->caption("Export MySQL ALTER Script");
    plugin->groups().insert("database/Database");

    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);

    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);

    plugins.insert(plugin);
  }

  {
    app_PluginRef plugin(grt);
    
    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runSynchronizeScriptWizard");
    plugin->name("db.mysql.plugin.sync.catalog");
    plugin->caption("MySQL Script Synchronization");
    plugin->groups().insert("database/Database");

    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);

    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);

    plugins.insert(plugin);
  }
    
  {
    app_PluginRef plugin(grt);
    
    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runImportScriptWizard");
    plugin->name("db.mysql.plugin.import.sql");
    plugin->caption("Import from SQL Script");
    plugin->groups().insert("database/Database");
    
    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);
    
    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);
    
    plugins.insert(plugin);
  }

  {
    app_PluginRef plugin(grt);
    
    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runDbSynchronizeWizard");
    plugin->name("db.mysql.plugin.sync.db");
    plugin->caption("Synchronize with Database");
    plugin->groups().insert("database/Database");
    
    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);
    
    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);
    
    plugins.insert(plugin);
  }
  
  
  {
    app_PluginRef plugin(grt);
    
    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runDbImportWizard");
    plugin->name("db.plugin.database.rev_eng");
    plugin->caption("Reverse Engineer from Database");
    plugin->groups().insert("database/Database");
    
    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);
    
    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);
    
    plugins.insert(plugin);
  }
  
  {
    app_PluginRef plugin(grt);
    
    plugin->pluginType("standalone");
    plugin->moduleName("MySQLDbModule");
    plugin->moduleFunctionName("runDbExportWizard");
    plugin->name("db.plugin.database.frw_eng");
    plugin->caption("Forward Engineer to Database");
    plugin->groups().insert("database/Database");
    
    grt::StringListRef document_types(grt);
    document_types.insert("workbench.Document");
    //plugin->documentStructNames(document_types);
    
    app_PluginObjectInputRef pdef(grt);
    pdef->objectStructName("db.Catalog");
    plugin->inputValues().insert(pdef);
    
    plugins.insert(plugin);
  }

  return plugins;
}


GRT_MODULE_ENTRY_POINT(MySQLDbModuleImpl);
