#ifndef _SCHEMA_SELECTION_PAGE_H_
#define _SCHEMA_SELECTION_PAGE_H_

#include "grtui/wizard_schema_filter_page.h"

class SchemaSelectionPage : public WizardSchemaFilterPage
{
public:
  SchemaSelectionPage(WizardForm *form, const char *name= "pickSchemata",const bool selected_only = false)
    : WizardSchemaFilterPage(form, name), _dbplugin(0), _selected_only(selected_only)
  {
    set_short_title(_("Select Schemata"));
    set_title(_("Select Schemata to Reverse Engineer"));
  }

  virtual void leave(bool advancing)
  {
    if (advancing)
    {
      grt::StringListRef list(_form->grtm()->get_grt());
      std::vector<std::string> selection= _check_list.get_selection();

      for (std::vector<std::string>::const_iterator iter= _schemas.begin();
        iter != _schemas.end(); ++iter)
        if (std::find(selection.begin(),selection.end(),*iter) == selection.end())
          list.insert(*iter);
        values().set("unSelectedSchemata", list);
    }
    WizardSchemaFilterPage::leave(advancing);
  }

  virtual void enter(bool advancing)
  {
    if (advancing)
    {
      _dbplugin->default_schemata_selection(_schemas);

      if (_selected_only)
        _check_list.set_strings(_schemas);
      else
        WizardSchemaFilterPage::enter(advancing);
      
      for (std::vector<std::string>::const_iterator iter= _schemas.begin();
           iter != _schemas.end(); ++iter)
        _check_list.set_selected(*iter, true);
    }
  }
  
  void set_db_plugin(Db_plugin *pl)
  {
    _dbplugin= pl;
  }

private:
  std::vector<std::string> _schemas;
  Db_plugin *_dbplugin;
  bool _selected_only;
};


#endif /* _SCHEMA_SELECTION_PAGE_H_ */
