/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "wb_editor_note.h"
#include "string_utilities.h"

NoteEditorBE::NoteEditorBE(bec::GRTManager *grtm, const workbench_model_NoteFigureRef &note)
: bec::BaseEditor(grtm, note), _note(note)
{
}

bool NoteEditorBE::should_close_on_delete_of(const std::string &oid)
{
  if (_note.id() == oid || _note->owner().id() == oid)
    return true;
  
  return false;
}


void NoteEditorBE::set_text(const std::string &text)
{
  if (*_note->text() != text)
  {
  bec::AutoUndoEdit undo(this, _note, "text");
  _note->text(text);
  undo.end(_("Change Note Text"));
}
}


std::string NoteEditorBE::get_text()
{
  return _note->text();
}


void NoteEditorBE::set_name(const std::string &name)
{
  if (name != *_note->name())
  {
  bec::AutoUndoEdit undo(this, _note, "name");
  _note->name(name);
  undo.end(_("Change Note Name"));
}
}


std::string NoteEditorBE::get_name()
{
  return _note->name();
}
