//
//  WBModelStoredNoteEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 19/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WBPluginEditorBase.h"

#include "wb_editor_storednote.h"


@interface StoredNoteEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet ScintillaView *noteText;
  
  IBOutlet NSButton *applyButton;
  IBOutlet NSButton *revertButton;
  
  StoredNoteEditorBE *mBackEnd; //!< note editor backend

  // Syntax error checking.
  NSTimer* mSyntaxCheckTimer;
  int mErrorCount;
  
  BOOL _editingSQL;
}

- (id)initWithModule:(grt::Module*)module GRTManager:(bec::GRTManager*)grtm arguments:(const grt::BaseListRef&)args;

- (NSView*)dockableView;

- (IBAction)loadText:(id)sender;
- (IBAction)saveText:(id)sender;
- (IBAction)applyChanges:(id)sender;
- (IBAction)revertChanges:(id)sender;

// Setup for code editor and syntax checking.
- (void) setupEditor;
- (void) resetSyntaxErrors;
- (void) checkSyntax:(NSTimer*) timer;

@end
