#ifndef __NOTEEDITOR_H__
#define __NOTEEDITOR_H__

#include "wb_editor_note.h"
#include "GrtTemplates.h"


#pragma make_public(::NoteEditorBE)

#ifdef _MSC_VER
using namespace MySQL::Grt;
using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
#endif

namespace MySQL {
namespace Grt {

public ref class NoteEditorBE : public BaseEditor
{
protected:
  NoteEditorBE(::NoteEditorBE *inn)
    : BaseEditor(inn)
  {}

public:
  NoteEditorBE::NoteEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
  : BaseEditor(
      new ::NoteEditorBE(grtm->get_unmanaged_object(), 
      workbench_model_NoteFigureRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
          )
      )
  {
  }

  ::NoteEditorBE *get_unmanaged_object()
  { return static_cast<::NoteEditorBE *>(inner); }

  void set_text(String ^text)
  {
    get_unmanaged_object()->set_text(NativeToCppString(text));
  }

  String^ get_text()
  {
    return CppStringToNative(get_unmanaged_object()->get_text());
  }

  void set_name(String ^name)
  {
    get_unmanaged_object()->set_name(NativeToCppString(name));
  }

  String^ get_name()
  {
    return CppStringToNative(get_unmanaged_object()->get_name());
  }
};

} // namespace Grt
} // namespace MySQL

#endif // __NOTEEDITOR_H__