#ifndef _ADDON_REPO_H_
#define _ADDON_REPO_H_


#include "addon.h"
#include "logger.h"
#include <map>


class Addon_repo
{
public:
  Addon_repo();
  virtual ~Addon_repo();

  PROPERTY(Logger *, log)
  PROPERTY(File_dir, storage_dir)
  PROPERTY(File_dir, temp_dir)

  void load();
  void purge();
  Addon * find(const std::string &guid, const std::string min_version, const std::string max_version);
  Addon * find_or_create(const std::string &guid, const std::string version);
  void add(Addon *addon);
  void remove(Addon *addon);
  void get_names(std::list<std::string> &guids, std::list<std::string> &names);
  void get_dependent_addons(Addon *addon, Addons_list &addon_list);

private:
  Logger *_log;

  typedef std::multimap<std::string, Addon> Addons_map;
  Addons_map _addons;
  File_dir _storage_dir;
  File_dir _temp_dir;
};


#endif // _ADDON_REPO_H_
