#include "stdafx.h"

#include "wb_addon_manager_wr.h"

namespace MySQL {
namespace GUI {
namespace Workbench {
namespace Plugins {
namespace Wb {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;
using namespace System::Reflection;
using namespace System::Windows::Forms;


Wb_addon_manager::Wb_addon_manager(MySQL::Grt::GrtManager ^grtm)
  : _inner(new ::Wb_addon_manager())
{
  _inner->grtm(grtm->get_unmanaged_object());
  
  Assembly ^assembly = Assembly::GetEntryAssembly();
  String ^value = gcnew String("");

  // configuration
  {
    array<Object^> ^attributes = assembly->GetCustomAttributes(AssemblyConfigurationAttribute::typeid, false);
    if (attributes->Length > 0)
    {
      value = (safe_cast<AssemblyConfigurationAttribute^>(attributes[0]))->Configuration;
      _inner->active_config(NativeToCppString(value));
    }
  }

  // version + revision
  {
    Version ^version = gcnew Version(Application::ProductVersion);
    value = String::Format("{0}.{1}.{2}",
      version->Major, version->Minor, version->Build);
    _inner->active_version(NativeToCppString(value));

    value = String::Format("{0}", version->MinorRevision);
    _inner->active_revision(NativeToCppString(value));
  }
}


Wb_addon_manager::~Wb_addon_manager()
{
  if (_inner)
    delete _inner;
}

/* //!
void Wb_addon_manager::proxy_type(String ^proxy_type)
{
  _inner->proxy_type(NativeToCppString(proxy_type));
}


void Wb_addon_manager::proxy_server(String ^proxy_server)
{
  _inner->proxy_server(NativeToCppString(proxy_server));
}


void Wb_addon_manager::proxy_userpwd(String ^proxy_userpwd)
{
  _inner->proxy_userpwd(NativeToCppString(proxy_userpwd));
}


void Wb_addon_manager::server_userpwd(String ^server_userpwd)
{
  _inner->server_userpwd(NativeToCppString(server_userpwd));
}
*/

String^ Wb_addon_manager::directory_page_url()
{
  return CppStringToNative(_inner->directory_page_url());
}


void Wb_addon_manager::load_manifest_from_url(String ^url, String ^%guid, String ^%version)
{
  std::string guid_, version_;
  _inner->load_manifest_from_url(NativeToCppString(url), guid_, version_);
  guid= CppStringToNative(guid_);
  version= CppStringToNative(version_);
}


void Wb_addon_manager::load_manifest(String ^guid, String ^min_ver, String ^max_ver)
{
  _inner->load_manifest(NativeToCppString(guid), NativeToCppString(min_ver), NativeToCppString(max_ver));
}


void Wb_addon_manager::start_download(String ^guid, String ^version)
{
  return _inner->start_download(NativeToCppString(guid), NativeToCppString(version));
}


void Wb_addon_manager::get_installed_addons(List<String ^> ^%guids, List<String ^> ^%names)
{
  std::list<std::string> guids_;
  std::list<std::string> names_;
  _inner->get_installed_addons(guids_, names_);
  guids= CppStringListToNative2(guids_);
  names= CppStringListToNative2(names_);
}


void Wb_addon_manager::install(String ^guid, String ^version)
{
  _inner->install(NativeToCppString(guid), NativeToCppString(version));
}


void Wb_addon_manager::uninstall(String ^guid)
{
  _inner->uninstall(NativeToCppString(guid));
}


void Wb_addon_manager::task_msg_cb(Task_msg_cb::ManagedDelegate ^deleg)
{
  _task_msg_cb= gcnew Task_msg_cb(deleg);
  _inner->task_msg_cb(_task_msg_cb->get_slot());
}


void Wb_addon_manager::task_progress_cb(Task_progress_cb::ManagedDelegate ^deleg)
{
  _task_progress_cb= gcnew Task_progress_cb(deleg);
  _inner->task_progress_cb(_task_progress_cb->get_slot());
}


void Wb_addon_manager::task_fail_cb(Task_fail_cb::ManagedDelegate ^deleg)
{
  _task_fail_cb= gcnew Task_fail_cb(deleg);
  _inner->task_fail_cb(_task_fail_cb->get_slot());
}


void Wb_addon_manager::task_finish_cb(Task_finish_cb::ManagedDelegate ^deleg)
{
  _task_finish_cb= gcnew Task_finish_cb(deleg);
  _inner->task_finish_cb(_task_finish_cb->get_slot());
}


};  // namespace Wb
};  // namespace Plugins
};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL
