#ifndef __WB_ADDON_MANAGER_WR_H__
#define __WB_ADDON_MANAGER_WR_H__


#include "wb_addon_manager.h"
#include "GrtTemplates.h"
#include "SigCSlot.h"


namespace MySQL {
namespace GUI {
namespace Workbench {
namespace Plugins {
namespace Wb {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;


public ref class Wb_addon_manager
{
private:
  ::Wb_addon_manager *_inner;

public:
  Wb_addon_manager(MySQL::Grt::GrtManager ^grtm);
  ~Wb_addon_manager();

  //!void proxy_type(String ^proxy_type);
  //!void proxy_server(String ^proxy_server);
  //!void proxy_userpwd(String ^proxy_userpwd);
  //!void server_userpwd(String ^server_userpwd);

  String^ directory_page_url();

  void load_manifest_from_url(String ^url, String ^%guid, String ^%version);
  void load_manifest(String ^guid, String ^min_ver, String ^max_ver);

  void start_download(String ^guid, String ^version);
  void cancel_download() { _inner->cancel_download(); }

  void get_installed_addons(List<String ^> ^%guids, List<String ^> ^%names);
  void install(String ^guid, String ^version);
  void uninstall(String ^guid);

  typedef DelegateSlot2<int, int,
    int, int,
    std::string, String^> Task_msg_cb;
  void task_msg_cb(Task_msg_cb::ManagedDelegate ^cb);

  typedef DelegateSlot2<int, int,
    float, float,
    std::string, String^> Task_progress_cb;
  void task_progress_cb(Task_progress_cb::ManagedDelegate ^cb);

  typedef DelegateSlot1<int, int,
    std::string, String^> Task_fail_cb;
  void task_fail_cb(Task_fail_cb::ManagedDelegate ^cb);

  typedef DelegateSlot0<int, int> Task_finish_cb;
  void task_finish_cb(Task_finish_cb::ManagedDelegate ^cb);  

protected:
  Task_msg_cb ^_task_msg_cb;
  Task_progress_cb ^_task_progress_cb;
  Task_fail_cb ^_task_fail_cb;
  Task_finish_cb ^_task_finish_cb;
};


};  // namespace Wb
};  // namespace Plugins
};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL


#endif // __WB_ADDON_MANAGER_WR_H__