
#include "grtpp.h"
#include "grtpp_helper.h"

#include <glib.h>

using namespace grt;



int main(int argc, char **argv)
{
  GRT grt;
  std::string structs_file= argv[1];
  std::string structs_dir= argv[2];
  std::string output_dir= argv[3];
  std::string impl_output_dir= argv[4];
  
  std::multimap<std::string,std::string> requires;

  g_print("Reading structs from '%s', outputing classes to '%s'\n",
            structs_dir.c_str(), output_dir.c_str());
  
  grt.scan_metaclasses_in(structs_dir, &requires);
  grt.end_loading_metaclasses(false);

  helper::generate_struct_code(&grt, structs_file, output_dir, impl_output_dir, requires);

  return 0;
}
