USE mythconverg;

#
#   Set the version number of the database schema.
#   This is compared to the version number in mythcontext.h
#   to verify that database changes are up to date.
#

DELETE FROM settings WHERE value='DBSchemaVer';
INSERT INTO settings VALUES ('DBSchemaVer', 1003, NULL);

#
#   Below are the recent alterations to the database.
#   The most recent are listed first. Execution should fail
#   when a previously executed command is encountered.
#

DELETE FROM settings WHERE value="MaxTranscoders";
UPDATE transcoding SET status = 1, starttime = starttime;

ALTER TABLE record ADD recorddups INT DEFAULT 0 NOT NULL;
ALTER TABLE record ADD maxnewest INT DEFAULT 0 NOT NULL;

INSERT INTO settings SET value="TranscoderAutoRun", data=0;
DELETE FROM settings WHERE value="TranscoderUseCutlist";

ALTER TABLE record ADD maxepisodes INT DEFAULT 0 NOT NULL;

ALTER TABLE record ADD autoexpire INT DEFAULT 0 NOT NULL;
ALTER TABLE recorded ADD autoexpire INT DEFAULT 0 NOT NULL;

