/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.16 from the
 * contents of agent.xs. Do not edit this file, edit agent.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "agent.xs"
/* -*- C -*- */
#if defined(_WIN32) && !defined(_WIN32_WINNT)
#define _WIN32_WINNT 0x501
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <netdb.h>
#include <sys/socket.h>

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#ifndef sv_undef
#define sv_undef PL_sv_undef
#endif

typedef netsnmp_handler_registration *NetSNMP__agent__netsnmp_handler_registration;

/*
 * needs to be in sync with the definitions in snmplib/snmpUDPDomain.c
 * and snmplib/snmpTCPDomain.c
 */
typedef netsnmp_indexed_addr_pair netsnmp_udp_addr_pair;

typedef struct handler_cb_data_s {
   SV *perl_cb;
} handler_cb_data;

typedef struct netsnmp_oid_s {
    oid                 *name;
    size_t               len;
    oid                  namebuf[ MAX_OID_LEN ];
} netsnmp_oid;

#define TEST_CONSTANT(value, name, C)           \
    if (strEQ(name, #C)) {                      \
        *value = C;                             \
        return 0;                               \
    }

static int constant_MODE_G(double *value, const char *name, const int len)
{
    switch (len >= 8 ? name[8] : -1) {
    case '\0':
        TEST_CONSTANT(value, name, MODE_GET);
        break;
    case 'B':
        TEST_CONSTANT(value, name, MODE_GETBULK);
        break;
    case 'N':
        TEST_CONSTANT(value, name, MODE_GETNEXT);
        break;
    }
    return EINVAL;
}

static int constant_MODE_SET_R(double *value, const char *name, const int len)
{
    switch (len >= 16 ? name[16] : -1) {
#ifndef NETSNMP_NO_WRITE_SUPPORT
    case '1':
	TEST_CONSTANT(value, name, MODE_SET_RESERVE1);
        break;
    case '2':
	TEST_CONSTANT(value, name, MODE_SET_RESERVE2);
        break;
#endif /* NETSNMP_NO_WRITE_SUPPORT */
    }
    return EINVAL;
}

static int constant_SNMP_ERR(double *value, char *name, int len)
{
    switch (len >= 9 ? name[9] : -1) {
    case 'A':
        TEST_CONSTANT(value, name, SNMP_ERR_AUTHORIZATIONERROR);
        break;
    case 'B':
        TEST_CONSTANT(value, name, SNMP_ERR_BADVALUE);
        break;
    case 'C':
        TEST_CONSTANT(value, name, SNMP_ERR_COMMITFAILED);
        break;
    case 'G':
	TEST_CONSTANT(value, name, SNMP_ERR_GENERR);
        break;
    case 'I':
	TEST_CONSTANT(value, name, SNMP_ERR_INCONSISTENTVALUE);
        break;
    case 'N':
        TEST_CONSTANT(value, name, SNMP_ERR_NOACCESS);
        TEST_CONSTANT(value, name, SNMP_ERR_NOCREATION);
        TEST_CONSTANT(value, name, SNMP_ERR_NOERROR);
        TEST_CONSTANT(value, name, SNMP_ERR_NOSUCHNAME);
        TEST_CONSTANT(value, name, SNMP_ERR_NOTWRITABLE);
        break;
    case 'R':
        TEST_CONSTANT(value, name, SNMP_ERR_READONLY);
        TEST_CONSTANT(value, name, SNMP_ERR_RESOURCEUNAVAILABLE);
        break;
    case 'T':
        TEST_CONSTANT(value, name, SNMP_ERR_TOOBIG);
        break;
    case 'U':
        TEST_CONSTANT(value, name, SNMP_ERR_UNDOFAILED);
        break;
    case 'W':
        TEST_CONSTANT(value, name, SNMP_ERR_WRONGENCODING);
        TEST_CONSTANT(value, name, SNMP_ERR_WRONGLENGTH);
        TEST_CONSTANT(value, name, SNMP_ERR_WRONGTYPE);
        TEST_CONSTANT(value, name, SNMP_ERR_WRONGVALUE);
        break;
    }
    return EINVAL;
}
    
static int constant_MODE_S(double *value, char *name, int len)
{
    if (!strnEQ(name + 6, "ET_", 3))
        return EINVAL;

    switch (len >= 9 ? name[9] : -1) {
#ifndef NETSNMP_NO_WRITE_SUPPORT
    case 'A':
        TEST_CONSTANT(value, name, MODE_SET_ACTION);
        break;
    case 'B':
        TEST_CONSTANT(value, name, MODE_SET_BEGIN);
        break;
    case 'C':
        TEST_CONSTANT(value, name, MODE_SET_COMMIT);
        break;
    case 'F':
        TEST_CONSTANT(value, name, MODE_SET_FREE);
        break;
    case 'U':
        TEST_CONSTANT(value, name, MODE_SET_UNDO);
        break;
#endif /* NETSNMP_NO_WRITE_SUPPORT */
    case 'R':
        return constant_MODE_SET_R(value, name, len);
    }
    return EINVAL;
}

static int constant(double *value, char *name, int len)
{
    switch (len >= 5 ? name[5] : -1) {
    case 'G':
	if (strnEQ(name + 0,"MODE_", 5))
            return constant_MODE_G(value, name, len);
        break;
    case 'S':
	if (strnEQ(name + 0,"MODE_", 5))
            return constant_MODE_S(value, name, len);
        break;
    case 'E':
	if (strnEQ(name + 0,"SNMP_ERR_", 9))
            return constant_SNMP_ERR(value, name, len);
        break;
    }
    return EINVAL;
}

int
handler_wrapper(netsnmp_mib_handler          *handler,
                netsnmp_handler_registration *reginfo,
                netsnmp_agent_request_info   *reqinfo,
                netsnmp_request_info         *requests) 
{
    handler_cb_data *cb_data = (handler_cb_data *) handler->myvoid;
    SV *cb;

    if (cb_data && (cb = cb_data->perl_cb)) {
        SV *arg;
        SV *rarg;
        dSP;
        ENTER;
        SAVETMPS;
        PUSHMARK(sp);
        rarg = newSViv(0);
        arg = newSVrv(rarg, "NetSNMP::agent::netsnmp_mib_handler");
        sv_setiv(arg, (IV) handler);
        XPUSHs(sv_2mortal(rarg));
        rarg = newSViv(0);
        arg = newSVrv(rarg, "NetSNMP::agent::netsnmp_handler_registrationPtr");
        sv_setiv(arg, (IV) reginfo);
        XPUSHs(sv_2mortal(rarg));
        rarg = newSViv(0);
        arg = newSVrv(rarg, "NetSNMP::agent::netsnmp_agent_request_info");
        sv_setiv(arg, (IV) reqinfo);
        XPUSHs(sv_2mortal(rarg));
        rarg = newSViv(0);
        arg = newSVrv(rarg, "NetSNMP::agent::netsnmp_request_infoPtr");
        sv_setiv(arg, (IV) requests);
        XPUSHs(sv_2mortal(rarg));
        PUTBACK;
        if (SvTYPE(cb) == SVt_PVCV) {
            perl_call_sv(cb, G_DISCARD);
                                       
        } else if (SvROK(cb) && SvTYPE(SvRV(cb)) == SVt_PVCV) {
            perl_call_sv(SvRV(cb), G_DISCARD); 
        }
        SPAGAIN;
        PUTBACK;
        FREETMPS;
        LEAVE;
    }
    return SNMP_ERR_NOERROR;
}

#line 225 "agent.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 367 "agent.c"

XS_EUPXS(XS_NetSNMP__agent_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 220 "agent.xs"
	STRLEN		len;
#line 380 "agent.c"
	SV *	sv = ST(0)
;
	char *	s = SvPV(sv, len);
#line 225 "agent.xs"
        int status;
        double value;
#line 387 "agent.c"
#line 228 "agent.xs"
        value = 0;
        status = constant(&value, s, len);
        XPUSHs(sv_2mortal(newSVuv(status)));
        XPUSHs(sv_2mortal(newSVnv(value)));
#line 393 "agent.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_NetSNMP__agent___agent_check_and_process); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent___agent_check_and_process)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "block = 1");
    {
	int	block;
	int	RETVAL;
	dXSTARG;

	if (items < 1)
	    block = 1;
	else {
	    block = (int)SvIV(ST(0))
;
	}
#line 237 "agent.xs"
	RETVAL = agent_check_and_process(block);
#line 419 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__uptime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__uptime)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 244 "agent.xs"
        RETVAL = netsnmp_get_agent_uptime();
#line 437 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent_init_mib); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_init_mib)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 251 "agent.xs"
    {
        netsnmp_init_mib();
    }
#line 455 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent_init_agent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_init_agent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	const char *	name = (const char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 259 "agent.xs"
        SOCK_STARTUP;
        RETVAL = init_agent(name);
#line 475 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent_init_snmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_init_snmp)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	const char *	name = (const char *)SvPV_nolen(ST(0))
;

	init_snmp(name);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent_init_master_agent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_init_master_agent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = init_master_agent();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent_snmp_enable_stderrlog); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_snmp_enable_stderrlog)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	snmp_enable_stderrlog();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_shutdown)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 280 "agent.xs"
    {
        if (0)
            printf("me = %p\n", me);
        snmp_shutdown("perl");
    }
#line 544 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent_errlog); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent_errlog)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, value");
    {
	SV *	me = ST(0)
;
	SV *	value = ST(1)
;
#line 291 "agent.xs"
        STRLEN stringlen;
        char * stringptr;
#line 564 "agent.c"
#line 294 "agent.xs"
    {
        if (0)
            printf("me = %p\n", me);
        stringptr = SvPV(value, stringlen);
        snmp_log(LOG_ERR, "%s", stringptr );
    }
#line 572 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registration_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registration_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "name, regoid, perlcallback");
    {
	char *	name = (char *)SvPV_nolen(ST(0))
;
	char *	regoid = (char *)SvPV_nolen(ST(1))
;
	SV *	perlcallback = ST(2)
;
#line 311 "agent.xs"
	oid myoid[MAX_OID_LEN];
	size_t myoid_len = MAX_OID_LEN;
        handler_cb_data *cb_data;
        int gotit=1;
#line 596 "agent.c"
	NetSNMP__agent__netsnmp_handler_registration	RETVAL;
#line 316 "agent.xs"
	if (!snmp_parse_oid(regoid, myoid, &myoid_len)) {
            if (!read_objid(regoid, myoid, &myoid_len)) {
                snmp_log(LOG_ERR, "couldn't parse %s (reg name: %s)\n",
                        regoid, name);
                RETVAL = NULL;
                gotit = 0;
            }
        }
        if (gotit) {
            cb_data = (handler_cb_data *) malloc(sizeof(handler_cb_data));
            RETVAL = netsnmp_create_handler_registration(name, handler_wrapper,
                                                 myoid, myoid_len,
                                                 HANDLER_CAN_RWRITE);
            cb_data->perl_cb = newSVsv(perlcallback);
            RETVAL->handler->myvoid = cb_data;
        }
#line 615 "agent.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "NetSNMP::agent::netsnmp_handler_registration", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registration_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registration_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reginfo");
    {
	netsnmp_handler_registration *	reginfo;
#line 339 "agent.xs"
        handler_cb_data *cb_data;
#line 633 "agent.c"

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    reginfo = INT2PTR(netsnmp_handler_registration *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"NetSNMP::agent::netsnmp_handler_registration::DESTROY",
			"reginfo")
;
#line 341 "agent.xs"
        if (reginfo && reginfo->handler && reginfo->handler->myvoid) {
	    cb_data = (handler_cb_data *) (reginfo->handler->myvoid);
	    SvREFCNT_dec(cb_data->perl_cb);
	    free(cb_data);
        }
	netsnmp_handler_registration_free(reginfo);
#line 651 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registration_register); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registration_register)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 352 "agent.xs"
        netsnmp_handler_registration *reginfo;
        handler_cb_data *cb_data = NULL;
#line 669 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 355 "agent.xs"
            {
                reginfo = (netsnmp_handler_registration *) SvIV(SvRV(me));
                if (reginfo && reginfo->handler && reginfo->handler->myvoid)
                    cb_data = (handler_cb_data *) (reginfo->handler->myvoid);
                RETVAL = netsnmp_register_handler(reginfo);
                if (!RETVAL) {
                    /* the agent now has a "reference" to this reg pointer */
                    SvREFCNT_inc(me);
                } else {
                    /*
                     * The reginfo was freed by netsnmp_register_handler,
                     * don't touch it in nsahr_DESTROY!
                     */
                    sv_setiv(SvRV(me), 0);
                    if (cb_data) {
                        /* And just free the callback. */
                        SvREFCNT_dec(cb_data->perl_cb);
                        free(cb_data);
                    }
                }
            }
#line 694 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registrationPtr_getRootOID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_handler_registrationPtr_getRootOID)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	me = ST(0)
;
#line 386 "agent.xs"
        int i;
        netsnmp_oid *o;
        netsnmp_handler_registration *reginfo;
        SV *arg, *rarg;
#line 717 "agent.c"
#line 391 "agent.xs"
    {
        dSP;
        PUSHMARK(SP);
        reginfo = (netsnmp_handler_registration *) SvIV(SvRV(me));

        o = malloc(sizeof(netsnmp_oid));
        o->name = o->namebuf;
        o->len = reginfo->rootoid_len;
        memcpy(o->name, reginfo->rootoid,
               reginfo->rootoid_len * sizeof(oid));

        rarg = newSViv((int) 0);
        arg = newSVrv(rarg, "netsnmp_oidPtr");
        sv_setiv(arg, (IV) o);

        XPUSHs(sv_2mortal(rarg));

        PUTBACK;
        i = perl_call_pv("NetSNMP::OID::newwithptr", G_SCALAR);
        SPAGAIN;
        if (i != 1) {
            snmp_log(LOG_ERR, "unhandled OID error.\n");
            /* ack XXX */
        }
        ST(0) = POPs;
        XSRETURN(1);
    }
#line 746 "agent.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getOID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getOID)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	me = ST(0)
;
#line 425 "agent.xs"
        int i;
        netsnmp_oid *o;
        netsnmp_request_info *request;
        SV *arg, *rarg;
#line 769 "agent.c"
#line 430 "agent.xs"
    {
        dSP;
        PUSHMARK(SP);
        request = (netsnmp_request_info *) SvIV(SvRV(me));

        o = malloc(sizeof(netsnmp_oid));
        o->name = o->namebuf;
        o->len = request->requestvb->name_length;
        memcpy(o->name, request->requestvb->name,
               request->requestvb->name_length * sizeof(oid));

        rarg = newSViv((int) 0);
        arg = newSVrv(rarg, "netsnmp_oidPtr");
        sv_setiv(arg, (IV) o);

        XPUSHs(sv_2mortal(rarg));

        PUTBACK;
        i = perl_call_pv("NetSNMP::OID::newwithptr", G_SCALAR);
        SPAGAIN;
        if (i != 1) {
            snmp_log(LOG_ERR, "unhandled OID error.\n");
            /* ack XXX */
        }
        ST(0) = POPs;
        XSRETURN(1);
    }
#line 798 "agent.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getOIDptr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getOIDptr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 462 "agent.xs"
        netsnmp_request_info *request;
#line 816 "agent.c"
	netsnmp_oid *	RETVAL;
#line 464 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        RETVAL = malloc(sizeof(netsnmp_oid));
        RETVAL->name = RETVAL->namebuf;
        RETVAL->len = request->requestvb->name_length;
        memcpy(RETVAL->name, request->requestvb->name,
               request->requestvb->name_length * sizeof(oid));
#line 825 "agent.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "netsnmp_oidPtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getType)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 477 "agent.xs"
        netsnmp_request_info *request;
#line 844 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 479 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));

        RETVAL =  request->requestvb->type ;
#line 851 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setType)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, newvalue");
    {
	SV *	me = ST(0)
;
	int	newvalue = (int)SvIV(ST(1))
;
#line 490 "agent.xs"
        netsnmp_request_info *request;
#line 871 "agent.c"
#line 492 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        request->requestvb->type=newvalue;
#line 875 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getValue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getValue)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 499 "agent.xs"
        char *outbuf = NULL;
        size_t ob_len = 0, oo_len = 0;
        netsnmp_request_info *request;
#line 894 "agent.c"
	SV *	RETVAL;
#line 503 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
	sprint_realloc_by_type((u_char **) &outbuf, &ob_len, &oo_len, 1,
                               request->requestvb, 0, 0, 0);
        RETVAL = newSVpv(outbuf, 0);
	netsnmp_free(outbuf);
#line 902 "agent.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getDelegated); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getDelegated)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 515 "agent.xs"
        netsnmp_request_info *request;
#line 921 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 517 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        RETVAL = request->delegated;
#line 927 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setDelegated); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setDelegated)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, newdelegated");
    {
	SV *	me = ST(0)
;
	int	newdelegated = (int)SvIV(ST(1))
;
#line 527 "agent.xs"
        netsnmp_request_info *request;
#line 947 "agent.c"
#line 529 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        request->delegated = newdelegated;
#line 951 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getProcessed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getProcessed)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 536 "agent.xs"
        netsnmp_request_info *request;
#line 968 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 538 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        RETVAL = request->processed;
#line 974 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setProcessed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setProcessed)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, newprocessed");
    {
	SV *	me = ST(0)
;
	int	newprocessed = (int)SvIV(ST(1))
;
#line 548 "agent.xs"
        netsnmp_request_info *request;
#line 994 "agent.c"
#line 550 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        request->processed = newprocessed;
#line 998 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getStatus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getStatus)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 557 "agent.xs"
        netsnmp_request_info *request;
#line 1015 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 559 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        RETVAL = request->status;
#line 1021 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setStatus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setStatus)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, newstatus");
    {
	SV *	me = ST(0)
;
	int	newstatus = (int)SvIV(ST(1))
;
#line 569 "agent.xs"
        netsnmp_request_info *request;
#line 1041 "agent.c"
#line 571 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        request->status = newstatus;
#line 1045 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getRepeat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_getRepeat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 578 "agent.xs"
        netsnmp_request_info *request;
#line 1062 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 580 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        RETVAL = request->repeat;
#line 1068 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setRepeat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setRepeat)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, newrepeat");
    {
	SV *	me = ST(0)
;
	int	newrepeat = (int)SvIV(ST(1))
;
#line 590 "agent.xs"
        netsnmp_request_info *request;
#line 1088 "agent.c"
#line 592 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        request->repeat = newrepeat;
#line 1092 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setValue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setValue)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "me, type, value");
    {
	SV *	me = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
	SV *	value = ST(2)
;
#line 601 "agent.xs"
        netsnmp_request_info *request;
        u_long utmp;
        long ltmp;
        uint64_t ulltmp;
        struct counter64 c64;
	oid myoid[MAX_OID_LEN];
	size_t myoid_len;
        STRLEN stringlen;
        char * stringptr;
#line 1121 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 611 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        switch(type) {
          case  SNMP_NOSUCHINSTANCE :
              snmp_set_var_typed_value(request->requestvb,SNMP_NOSUCHINSTANCE,0,0) ;
              RETVAL = 1;
              break ;
          case  SNMP_NOSUCHOBJECT :
              snmp_set_var_typed_value(request->requestvb,SNMP_NOSUCHOBJECT,0,0) ;
              RETVAL = 1;
              break ;
          case  SNMP_ENDOFMIBVIEW :
              snmp_set_var_typed_value(request->requestvb,SNMP_ENDOFMIBVIEW,0,0) ;
              RETVAL = 1;
              break ;
          case ASN_INTEGER:
	      /* We want an integer here */
	      if ((SvTYPE(value) == SVt_IV) || (SvTYPE(value) == SVt_PVMG) ||
                   SvIOK(value)) {
		  /* Good - got a real one (or a blessed object that we hope will turn out OK) */
		  ltmp = SvIV(value);
		  snmp_set_var_typed_value(request->requestvb, (u_char)type,
					   (u_char *) &ltmp, sizeof(ltmp));
		  RETVAL = 1;
		  break;
	      }
	      else if (SvPOKp(value)) {
	          /* Might be OK - got a string, so try to convert it, allowing base 10, octal, and hex forms */
	          stringptr = SvPV(value, stringlen);
		  ltmp = strtol( stringptr, NULL, 0 );
		  if (errno == EINVAL) {
		  	snmp_log(LOG_ERR, "Could not convert string to number in setValue: '%s'", stringptr);
			RETVAL = 0;
			break;
		  }

		  snmp_set_var_typed_value(request->requestvb, (u_char)type,
					   (u_char *) &ltmp, sizeof(ltmp));
		  RETVAL = 1;
		  break;
	      }
	      else {
		snmp_log(LOG_ERR, "Non-integer value passed to setValue with ASN_INTEGER: type was %lu\n",
			(unsigned long)SvTYPE(value));
		RETVAL = 0;
		break;
	      }


          case ASN_UNSIGNED:
          case ASN_COUNTER:
          case ASN_TIMETICKS:
	      /* We want an integer here */
	      if ((SvTYPE(value) == SVt_IV) || (SvTYPE(value) == SVt_PVMG) ||
                   SvIOK(value)) {
		  /* Good - got a real one (or a blessed scalar which we have to hope will turn out OK) */
		  utmp = SvIV(value);
                  snmp_set_var_typed_value(request->requestvb, (u_char)type,
                                       (u_char *) &utmp, sizeof(utmp));
		  RETVAL = 1;
		  break;
	      }
	      else if (SvPOKp(value)) {
	          /* Might be OK - got a string, so try to convert it, allowing base 10, octal, and hex forms */
	          stringptr = SvPV(value, stringlen);
		  utmp = strtoul( stringptr, NULL, 0 );
		  if (errno == EINVAL) {
		  	snmp_log(LOG_ERR, "Could not convert string to number in setValue: '%s'", stringptr);
			RETVAL = 0;
			break;
		  }

                  snmp_set_var_typed_value(request->requestvb, (u_char)type,
                                       (u_char *) &utmp, sizeof(utmp));
		  RETVAL = 1;
		  break;
	      }
	      else {
		snmp_log(LOG_ERR, "Non-unsigned-integer value passed to setValue with ASN_UNSIGNED/ASN_COUNTER/ASN_TIMETICKS: type was %lu\n",
			(unsigned long)SvTYPE(value));
		RETVAL = 0;
		break;
	      }

          case ASN_COUNTER64:
	      /* We want an integer here */
	      if ((SvTYPE(value) == SVt_IV) || (SvTYPE(value) == SVt_PVMG)) {
		  /* Good - got a real one (or a blessed scalar which we have to hope will turn out OK) */
		  ulltmp = SvIV(value);
		  RETVAL = 1;
	      }
	      else if (SvPOKp(value)) {
	          /* Might be OK - got a string, so try to convert it, allowing base 10, octal, and hex forms */
	          stringptr = SvPV(value, stringlen);
	          errno = 0;
		  ulltmp = strtoull( stringptr, NULL, 0 );
		  if (errno != 0) {
		      snmp_log(LOG_ERR, "Could not convert string to number in setValue: '%s'", stringptr);
		      RETVAL = 0;
		  } else

		      RETVAL = 1;
	      }
	      else {
		snmp_log(LOG_ERR, "Non-unsigned-integer value passed to setValue with ASN_COUNTER64: type was %lu\n",
			(unsigned long)SvTYPE(value));
		RETVAL = 0;
	      }
	      if (RETVAL) {
		  c64.high = (uint32_t)(ulltmp >> 32);
		  c64.low  = (uint32_t)(ulltmp >> 0);
		  snmp_set_var_typed_value(request->requestvb, (u_char)type,
				     (u_char *) &c64, sizeof(struct counter64));
	      }
	      break;

          case ASN_OCTET_STR:
          case ASN_BIT_STR:
          case ASN_OPAQUE:
	      /* Check that we have been passed something with a string value (or a blessed scalar) */
	      if (!SvPOKp(value) && (SvTYPE(value) != SVt_PVMG)) {
		snmp_log(LOG_ERR, "Non-string value passed to setValue with ASN_OCTET_STR/ASN_BIT_STR: type was %lu\n",
			(unsigned long)SvTYPE(value));
		RETVAL = 0;
		break;
	      }

	      /* Find length of string (strlen will *not* do, as these are binary strings) */
	      stringptr = SvPV(value, stringlen);

              snmp_set_var_typed_value(request->requestvb, (u_char)type,
                                       (u_char *) stringptr,
                                       stringlen);
              RETVAL = 1;
              break;

          case ASN_IPADDRESS:
	      /* IP addresses are passed as *binary* strings.
	       * In the case of IPv4 addresses, these are 4 bytes long.
	       * NOTE: the use of binary strings rather than dotted-quad or FQDNs was
	       * introduced here by Andrew Findlay's patch of March 17th 2003,
	       * and is effectively a change to the previous implied API which assumed
	       * the value was a (valid) hostname.
	       * Responsibility for decoding and resolving has been passed up to the Perl script.
	       */

	      /* Check that we have been passed something with a string value (or a blessed scalar) */
	      if (!SvPOKp(value) && (SvTYPE(value) != SVt_PVMG)) {
		snmp_log(LOG_ERR, "Non-string value passed to setValue with ASN_IPADDRESS: type was %lu\n",
			(unsigned long)SvTYPE(value));
		RETVAL = 0;
		break;
	      }

	      /* Find length of string (strlen will *not* do, as these are binary strings) */
	      stringptr = SvPV(value, stringlen);


	      if ((stringlen != 4) && (stringlen != 16)) {
	      		snmp_log(LOG_ERR, "IP address of %" NETSNMP_PRIz "d bytes passed to setValue with ASN_IPADDRESS\n", stringlen);
			RETVAL = 0;
			break;
	      }

              snmp_set_var_typed_value(request->requestvb, (u_char)type,
                                   stringptr, stringlen);
              RETVAL = 1;
              break;

          case ASN_OBJECT_ID:
	      /* Check that we have been passed something with a string value (or a blessed scalar) */
	      if (!SvPOKp(value) && (SvTYPE(value) != SVt_PVMG)) {
		snmp_log(LOG_ERR, "Non-string value passed to setValue with ASN_OBJECT_ID: type was %lu\n",
			(unsigned long)SvTYPE(value));
		RETVAL = 0;
		break;
	      }

	      /* Extract the string */
	      stringptr = SvPV(value, stringlen);

	      /* snmp_log(LOG_ERR, "setValue returning OID '%s'\n", stringptr); */

	      myoid_len = MAX_OID_LEN;
              if (!snmp_parse_oid(stringptr, myoid, &myoid_len)) {
                  snmp_log(LOG_ERR, "couldn't parse %s in setValue\n", stringptr);
		  RETVAL = 0;
		  break;
              } else {
		  /* snmp_log(LOG_ERR, "setValue returning OID length %d\n", myoid_len); */

                  request = (netsnmp_request_info *) SvIV(SvRV(me));
                  snmp_set_var_typed_value(request->requestvb, (u_char)type,
                                           (u_char *) myoid, (myoid_len * sizeof(myoid[0])) );
              }

              RETVAL = 1;
              break;

            default:
                snmp_log(LOG_ERR, "unknown var value type: %d\n",
                        type);
                RETVAL = 0;
                break;
        }

#line 1330 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setOID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setOID)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, value");
    {
	SV *	me = ST(0)
;
	char *	value = (char *)SvPV_nolen(ST(1))
;
#line 827 "agent.xs"
	oid myoid[MAX_OID_LEN];
	size_t myoid_len = MAX_OID_LEN;
        netsnmp_request_info *request;
#line 1352 "agent.c"
#line 831 "agent.xs"
	myoid_len = MAX_OID_LEN;
	if (!snmp_parse_oid(value, myoid, &myoid_len)) {
            snmp_log(LOG_ERR, "couldn't parse %s in setOID\n", value);
        } else {
            request = (netsnmp_request_info *) SvIV(SvRV(me));
            snmp_set_var_objid(request->requestvb, myoid, myoid_len);
        }
#line 1361 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setError); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_setError)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "me, rinfo, ecode");
    {
	SV *	me = ST(0)
;
	SV *	rinfo = ST(1)
;
	int	ecode = (int)SvIV(ST(2))
;
#line 845 "agent.xs"
        netsnmp_request_info *request;
        netsnmp_agent_request_info *reqinfo;
#line 1383 "agent.c"
#line 848 "agent.xs"
        request = (netsnmp_request_info *) SvIV(SvRV(me));
        reqinfo = (netsnmp_agent_request_info *) SvIV(SvRV(rinfo));
        netsnmp_set_request_error(reqinfo, request, ecode);
#line 1388 "agent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_next); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_request_infoPtr_next)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 856 "agent.xs"
        netsnmp_request_info *request;
        SV *arg, *rarg;
#line 1406 "agent.c"
	SV *	RETVAL;
#line 859 "agent.xs"
        {
            request = (netsnmp_request_info *) SvIV(SvRV(me));
            if (request && request->next) {
                request = request->next;
                rarg = newSViv(0);
                arg = newSVrv(rarg, "NetSNMP::agent::netsnmp_request_infoPtr");
                sv_setiv(arg, (IV) request);
                RETVAL = rarg;				
            } else {
                RETVAL = &sv_undef;
            }
        }
#line 1421 "agent.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_getSourceIp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_getSourceIp)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 881 "agent.xs"
        netsnmp_agent_request_info *reqinfo;
	netsnmp_udp_addr_pair *addr_pair;
	struct sockaddr_in *from;
        SV *rarg;

#line 1444 "agent.c"
	SV *	RETVAL;
#line 887 "agent.xs"
        reqinfo = (netsnmp_agent_request_info *) SvIV(SvRV(me));

        /* XXX: transport-specific: UDP/IPv4 only! */
	addr_pair = (netsnmp_udp_addr_pair *) (reqinfo->asp->pdu->transport_data);
	from = (struct sockaddr_in *) &(addr_pair->remote_addr);
        rarg = newSVpv((const char *)(&from->sin_addr.s_addr), sizeof(from->sin_addr.s_addr));
        RETVAL = rarg;
#line 1454 "agent.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_getDestIp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_getDestIp)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 902 "agent.xs"
        netsnmp_agent_request_info *reqinfo;
	netsnmp_udp_addr_pair *addr_pair;
	struct in_addr *to;
        SV *rarg;

#line 1477 "agent.c"
	SV *	RETVAL;
#line 908 "agent.xs"
        reqinfo = (netsnmp_agent_request_info *) SvIV(SvRV(me));

        /* XXX: transport-specific: UDP/IPv4 only! */
	addr_pair = (netsnmp_udp_addr_pair *) (reqinfo->asp->pdu->transport_data);
	to = (struct in_addr *) &(addr_pair->local_addr);
        rarg = newSVpv((const char *)(&to->s_addr), sizeof(to->s_addr));
        RETVAL = rarg;
#line 1487 "agent.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_getMode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_getMode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "me");
    {
	SV *	me = ST(0)
;
#line 922 "agent.xs"
        netsnmp_agent_request_info *reqinfo;
#line 1506 "agent.c"
	int	RETVAL;
	dXSTARG;
#line 924 "agent.xs"
        reqinfo = (netsnmp_agent_request_info *) SvIV(SvRV(me));
        RETVAL = reqinfo->mode;
#line 1512 "agent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_setMode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__agent__netsnmp_agent_request_info_setMode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "me, newvalue");
    {
	SV *	me = ST(0)
;
	int	newvalue = (int)SvIV(ST(1))
;
#line 934 "agent.xs"
        netsnmp_agent_request_info *reqinfo;
#line 1532 "agent.c"
#line 936 "agent.xs"
        reqinfo = (netsnmp_agent_request_info *) SvIV(SvRV(me));
        reqinfo->mode = newvalue;
#line 1536 "agent.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_NetSNMP__agent); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_NetSNMP__agent)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        (void)newXSproto_portable("NetSNMP::agent::constant", XS_NetSNMP__agent_constant, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::__agent_check_and_process", XS_NetSNMP__agent___agent_check_and_process, file, ";$");
        (void)newXSproto_portable("NetSNMP::agent::_uptime", XS_NetSNMP__agent__uptime, file, "");
        (void)newXSproto_portable("NetSNMP::agent::init_mib", XS_NetSNMP__agent_init_mib, file, "");
        (void)newXSproto_portable("NetSNMP::agent::init_agent", XS_NetSNMP__agent_init_agent, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::init_snmp", XS_NetSNMP__agent_init_snmp, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::init_master_agent", XS_NetSNMP__agent_init_master_agent, file, "");
        (void)newXSproto_portable("NetSNMP::agent::snmp_enable_stderrlog", XS_NetSNMP__agent_snmp_enable_stderrlog, file, "");
        (void)newXSproto_portable("NetSNMP::agent::shutdown", XS_NetSNMP__agent_shutdown, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::errlog", XS_NetSNMP__agent_errlog, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_handler_registration::new", XS_NetSNMP__agent__netsnmp_handler_registration_new, file, "$$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_handler_registration::DESTROY", XS_NetSNMP__agent__netsnmp_handler_registration_DESTROY, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_handler_registration::register", XS_NetSNMP__agent__netsnmp_handler_registration_register, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_handler_registrationPtr::getRootOID", XS_NetSNMP__agent__netsnmp_handler_registrationPtr_getRootOID, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getOID", XS_NetSNMP__agent__netsnmp_request_infoPtr_getOID, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getOIDptr", XS_NetSNMP__agent__netsnmp_request_infoPtr_getOIDptr, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getType", XS_NetSNMP__agent__netsnmp_request_infoPtr_getType, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setType", XS_NetSNMP__agent__netsnmp_request_infoPtr_setType, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getValue", XS_NetSNMP__agent__netsnmp_request_infoPtr_getValue, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getDelegated", XS_NetSNMP__agent__netsnmp_request_infoPtr_getDelegated, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setDelegated", XS_NetSNMP__agent__netsnmp_request_infoPtr_setDelegated, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getProcessed", XS_NetSNMP__agent__netsnmp_request_infoPtr_getProcessed, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setProcessed", XS_NetSNMP__agent__netsnmp_request_infoPtr_setProcessed, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getStatus", XS_NetSNMP__agent__netsnmp_request_infoPtr_getStatus, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setStatus", XS_NetSNMP__agent__netsnmp_request_infoPtr_setStatus, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::getRepeat", XS_NetSNMP__agent__netsnmp_request_infoPtr_getRepeat, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setRepeat", XS_NetSNMP__agent__netsnmp_request_infoPtr_setRepeat, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setValue", XS_NetSNMP__agent__netsnmp_request_infoPtr_setValue, file, "$$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setOID", XS_NetSNMP__agent__netsnmp_request_infoPtr_setOID, file, "$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::setError", XS_NetSNMP__agent__netsnmp_request_infoPtr_setError, file, "$$$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_request_infoPtr::next", XS_NetSNMP__agent__netsnmp_request_infoPtr_next, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_agent_request_info::getSourceIp", XS_NetSNMP__agent__netsnmp_agent_request_info_getSourceIp, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_agent_request_info::getDestIp", XS_NetSNMP__agent__netsnmp_agent_request_info_getDestIp, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_agent_request_info::getMode", XS_NetSNMP__agent__netsnmp_agent_request_info_getMode, file, "$");
        (void)newXSproto_portable("NetSNMP::agent::netsnmp_agent_request_info::setMode", XS_NetSNMP__agent__netsnmp_agent_request_info_setMode, file, "$$");
#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

