; Script generated by the HM NIS Edit Script Wizard.
SetCompressor /SOLID lzma

!include x64.nsh
!include "Sections.nsh"
!include FileFunc.nsh
!include WinVer.nsh
!insertmacro GetParameters
!insertmacro GetOptions
var cmdLineParameters

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Net-SNMP"
!define PRODUCT_EXE_SUFFIX ".${INSTALLER_PLATFORM}.exe"
!define PRODUCT_WEB_SITE "http://www.net-snmp.org"
!define PRODUCT_DIR_REGKEY "Software\Net-SNMP"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "Net-SNMP:StartMenuDir"

; Is OpenSSL required for this build?
!define OPENSSL_REQUIRED "0"

; For environment variables
!define ALL_USERS
;!include "SetEnVar.nsi"
!include "Add2Path.nsi"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
!define MUI_HEADERIMAGE_BITMAP "net-snmp-header1.bmp"
!define MUI_HEADERIMAGE_UNBITMAP "net-snmp-header1.bmp"
; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_RADIOBUTTONS
!insertmacro MUI_PAGE_LICENSE "docs\COPYING"

; Make sure SSL is installed.
; Page custom IsSSLInstalled "" ": custom page"

; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "Net-SNMP"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; For sections
;!define SECTION_OFF   0xFFFFFFFE
; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_MAJ_VERSION}.${PRODUCT_MIN_VERSION}.${PRODUCT_REVISION}"
OutFile "net-snmp-${PRODUCT_MAJ_VERSION}.\
                  ${PRODUCT_MIN_VERSION}.\
                  ${PRODUCT_REVISION}\
                  -${PRODUCT_EXE_VERSION}\
                  ${PRODUCT_EXE_SUFFIX}"
InstallDir "C:\usr"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" "InstallDir"
ShowInstDetails show
ShowUnInstDetails show

; Variables for writing config files
Var conf_file

Var winExtDLL
Var openSSL

Section "Base Components" SEC01
  SectionIn RO
  StrCmp $openSSL "false" SEC01_noOpenSSL SEC01_OpenSSL
  
  SEC01_noOpenSSL:
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "README.txt"
  SetOutPath "$INSTDIR\bin"

  File "bin\netsnmp.dll"
  File "bin\encode_keychange.exe"
  File "bin\snmpvacm.exe"
  File "bin\snmpusm.exe"
  File "bin\snmptrap.exe"
  File "bin\snmptranslate.exe"
  File "bin\snmptest.exe"
  File "bin\snmptable.exe"
  File "bin\snmpstatus.exe"
  File "bin\snmpset.exe"
  File "bin\snmpnetstat.exe"
  File "bin\snmpgetnext.exe"
  File "bin\snmpget.exe"
  File "bin\snmpdf.exe"
  File "bin\snmpdelta.exe"
  File "bin\snmpbulkwalk.exe"
  File "bin\snmpbulkget.exe"
  File "bin\snmpwalk.exe"
  goto SEC01_continue

  SEC01_OpenSSL:
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "README.txt"
  SetOutPath "$INSTDIR\bin"

  File "bin.ssl\netsnmp.dll"
  File "bin.ssl\encode_keychange.exe"
  File "bin.ssl\snmpvacm.exe"
  File "bin.ssl\snmpusm.exe"
  File "bin.ssl\snmptrap.exe"
  File "bin.ssl\snmptranslate.exe"
  File "bin.ssl\snmptest.exe"
  File "bin.ssl\snmptable.exe"
  File "bin.ssl\snmpstatus.exe"
  File "bin.ssl\snmpset.exe"
  File "bin.ssl\snmpnetstat.exe"
  File "bin.ssl\snmpgetnext.exe"
  File "bin.ssl\snmpget.exe"
  File "bin.ssl\snmpdf.exe"
  File "bin.ssl\snmpdelta.exe"
  File "bin.ssl\snmpbulkwalk.exe"
  File "bin.ssl\snmpbulkget.exe"
  File "bin.ssl\snmpwalk.exe"

  SEC01_continue:

  File "bin\mib2c"
  File "bin\mib2c.bat"
  Call CreateMib2cBat
  
  File "bin\snmpconf"
  File "bin\snmpconf.bat"
  Call CreateSnmpconfBat
  
  File "bin\traptoemail"
  File "bin\traptoemail.bat"
  Call CreatTraptoemailBat
  
  SetOutPath "$INSTDIR\share\snmp\mibs"
  File "share\snmp\mibs\*.*"
  SetOutPath "$INSTDIR\share\snmp"
  File "share\snmp\mib2c.*.conf"
  SetOutPath "$INSTDIR\share\snmp\mib2c-data"
  File "share\snmp\mib2c-data\*.*"
  SetOutPath "$INSTDIR\docs"
  File "docs\COPYING"
  File "docs\Net-SNMP.chm"
  SetOutPath "$INSTDIR\share\snmp\snmpconf-data\snmp-data"
  File "share\snmp\snmpconf-data\snmp-data\*.*"
  SetOutPath "$INSTDIR\etc\snmp"
  ; File "etc\snmp\snmp.conf"
  SetOutPath "$INSTDIR\include\net-snmp"
  File "include\net-snmp\net-snmp-config.h"
  SetOutPath "$INSTDIR\include\net-snmp\agent"
  File "include\net-snmp\agent\agent_module_config.h"
  File "include\net-snmp\agent\mib_module_config.h"
  CreateDirectory "$INSTDIR\temp"
  CreateDirectory "$INSTDIR\snmp"
  CreateDirectory "$INSTDIR\snmp\persist"
  CreateDirectory "$INSTDIR\log"
  
  ; Add bin directory to the search path
  Push "$INSTDIR\bin"
  Call AddToPath
  
  Call CreateSnmpConf
SectionEnd

SectionGroup /e "Net-SNMP Agent Service"
  Section "Standard agent" SEC02
    StrCpy $winExtDLL "0"
    SetOutPath "$INSTDIR\bin"

    ; Delete agent otherwise re-installing a different agent may not work because of date stamps
    Delete "$INSTDIR\bin\snmpd.exe"  

    StrCmp $openSSL "false" SEC02_noOpenSSL SEC02_OpenSSL
    SEC02_noOpenSSL:
      File "bin\snmpd.exe"

    SEC02_OpenSSL:
      File "bin.ssl\snmpd.exe"

    SetOutPath "$INSTDIR\share\snmp\snmpconf-data\snmpd-data"
    File "share\snmp\snmpconf-data\snmpd-data\*.*"
  
    ; If we are on an NT system then install the service batch files.
    Call IsNT
    Pop $1
    StrCmp $1 0 SEC02_NoService
  
    SetOutPath "$INSTDIR\"
    File "registeragent.bat"
    File "unregisteragent.bat"
    Call CreateAgentBats

	ClearErrors
	StrCmp $ICONS_GROUP "" SEC02_NoService
    CreateDirectory "$SMPROGRAMS\$ICONS_GROUP\Service"
    CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Service\Register Agent Service.lnk" "$INSTDIR\registeragent.bat"
    CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Agent Service.lnk" "$INSTDIR\unregisteragent.bat"
    
    SEC02_NoService:
	
  SectionEnd

  Section "With Windows Extension DLL support" SEC03	
	StrCpy $winExtDLL "1"
	SetOutPath "$INSTDIR\bin"

    ; Delete agent otherwise re-installing a different agent may not work because of date stamps
    Delete "$INSTDIR\bin\snmpd.exe"  

    StrCmp $openSSL "false" SEC03_noOpenSSL SEC03_OpenSSL
    SEC03_noOpenSSL:
      File /oname=snmpd.exe "bin\snmpd-winExtDLL.exe"

    SEC03_OpenSSL:
      File /oname=snmpd.exe "bin.ssl\snmpd-winExtDLL.exe"

    SetOutPath "$INSTDIR\share\snmp\snmpconf-data\snmpd-data"
    File "share\snmp\snmpconf-data\snmpd-data\*.*"
  
    ; If we are on an NT system then install the service batch files.
    Call IsNT
    Pop $1
    StrCmp $1 0 SEC03_NoService
  
    SetOutPath "$INSTDIR\"
    File "registeragent.bat"
    File "unregisteragent.bat"
    Call CreateAgentBats

	ClearErrors
	StrCmp $ICONS_GROUP "" SEC03_NoService
    CreateDirectory "$SMPROGRAMS\$ICONS_GROUP\Service"
    CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Service\Register Agent Service.lnk" "$INSTDIR\registeragent.bat"
    CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Agent Service.lnk" "$INSTDIR\unregisteragent.bat"
    
    SEC03_NoService:
  SectionEnd
  
;  Section "Hidden" SECAgentHidden
  ;SectionEnd
SectionGroupEnd

Section "Net-SNMP Trap Service" SEC04
  SetOutPath "$INSTDIR\bin"

  StrCmp $openSSL "false" SEC04_noOpenSSL SEC04_OpenSSL

  SEC04_noOpenSSL:
  File "bin\snmptrapd.exe"
  goto SEC04_continue

  SEC04_OpenSSL:
  File "bin.ssl\snmptrapd.exe"

  SEC04_continue:
  SetOutPath "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data"
  File "share\snmp\snmpconf-data\snmptrapd-data\*.*"
  ;SetOutPath "$INSTDIR\etc\snmp"
  ;File "etc\snmp\snmptrapd.conf"
  
  ; If we are on an NT system then install the service batch files.
  Call IsNT
  Pop $1
  StrCmp $1 0 NoTrapService

  SetOutPath "$INSTDIR\"
  File "registertrapd.bat"
  File "unregistertrapd.bat"
  Call CreateTrapdBats
  
  ClearErrors
  StrCmp $ICONS_GROUP "" NoTrapService
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Service\Register Trap Service.lnk" "$INSTDIR\registertrapd.bat"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Trap Service.lnk" "$INSTDIR\unregistertrapd.bat"
  
  NoTrapService:
SectionEnd

/*
Section "Perl SNMP Modules" SEC05
  SetOutPath "$INSTDIR\perl\x86"

  StrCmp $openSSL "false" SEC05_noOpenSSL SEC05_OpenSSL

  SEC05_noOpenSSL:
  File "perl\x86\NetSNMP.tar.gz"
  goto SEC05_continue

  SEC05_OpenSSL:
  File "perl.ssl\x86\NetSNMP.tar.gz"

  SEC05_continue:

  SetOutPath "$INSTDIR\perl"
  File "perl\NetSNMP.ppd"
  SetOutPath "$INSTDIR\bin"
  File "bin\net-snmp-perl-test.pl"
SectionEnd
*/

Section "Development files" SEC06
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "README.txt"

  SetOutPath "$INSTDIR\docs"
  File "docs\COPYING"
  File "docs\Net-SNMP.chm"

  SetOutPath "$INSTDIR\include\net-snmp"
  File "include\net-snmp\*.h"

  SetOutPath "$INSTDIR\include\net-snmp\system"
  File "include\net-snmp\system\*.h"

  SetOutPath "$INSTDIR\include\net-snmp\library"
  File "include\net-snmp\library\*.h"

  SetOutPath "$INSTDIR\include\net-snmp\agent"
  File "include\net-snmp\agent\*.h"

  SetOutPath "$INSTDIR\include\net-snmp\machine"
  File "include\net-snmp\machine\generic.h"

  SetOutPath "$INSTDIR\include\net-snmp\data_access"
  File "include\net-snmp\data_access\*.h"

  SetOutPath "$INSTDIR\lib"
  File "lib\*.*"
SectionEnd

Section "Encryption support (OpenSSL)" SEC07
SectionEnd

Section -AdditionalIcons
  ClearErrors
  StrCmp $ICONS_GROUP "" noAdditionalItems
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Net-SNMP Help.lnk" "$INSTDIR\docs\Net-SNMP.chm"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\README.lnk" "$INSTDIR\README.txt"
  
  noAdditionalItems:
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "InstallDir" $INSTDIR
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "Version" ${PRODUCT_MAJ_VERSION}.${PRODUCT_MIN_VERSION}.${PRODUCT_REVISION}
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\bin\encode_keychange.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_MAJ_VERSION}.${PRODUCT_MIN_VERSION}.${PRODUCT_REVISION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "${PRODUCT_STARTMENU_REGVAL}" "$ICONS_GROUP"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} \
               "The Base Components provide basic means for interrogating SNMP devices. These \
               include the command-line client applications, a short list of Management \
               Information Base MIB files, and a user-friendly Help subsystem"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} \
               "The Net-SNMP Agent Service provides information to a remote management system."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} \
               "The Net-SNMP Agent Service provides information to a remote management system.  Includes the ability to load existing Windows SNMP Service extension agents.  See README.win32."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} \
               "The Net-SNMP Trap Service receives SNMP notifications traps and informs) \
               from other SNMP-enabled devices."
/*
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} \
               "The Perl SNMP Modules can be used if this computer will be used to \
               run or develop Perl-based SNMP programs (e.g. 'mib2c')"
*/
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC06} \
               "The Development files provide header and library files used for developing \
               applications that use the Net-SNMP library."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC07} \
               "Encryption support is required for SNMPv3 SHA authentication and DES / AES privacy.  A Windows package is available from www.slproweb.com."
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Function CreateSnmpConf
  SetOutPath "$INSTDIR\etc\snmp"
  StrCpy $conf_file "snmp.conf"
  
  ; Slash it
  Push $INSTDIR
  Push "\"
  Push "/"
  Call StrRep
  Pop $R0 

  IfSilent overwrite_conf
  IfFileExists "$conf_file" 0 overwrite_conf
    MessageBox MB_YESNO|MB_ICONQUESTION "File $conf_file exists.  Overwrite?" IDYES overwrite_conf
    StrCpy $conf_file "$conf_file.new"
    MessageBox MB_OK "File saved as $conf_file"
  overwrite_conf:  

  ClearErrors
  FileOpen $0 "$conf_file" "w"
  IfErrors cleanup
  FileWrite $0 "mibdirs $R0/share/snmp/mibs$\r$\n"
  FileWrite $0 "persistentDir $R0/snmp/persist$\r$\n"
  FileWrite $0 "tempFilePattern $R0/temp/snmpdXXXXXX$\r$\n"
  
  cleanup:
  FileClose $0
  
  ; For environment variables
  ;!define ALL_USERS
  
  ; Set the conf path
  ;Push "SNMPCONFPATH"
  ;Push "$R0/etc/snmp"
  ;Call WriteEnvStr
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "SNMPCONFPATH" "$R0/etc/snmp;$R0/snmp/persist"
  
  ;Push "SNMPSHAREPATH"
  ;Push "$R0/share/snmp"
  ;Call WriteEnvStr
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "SNMPSHAREPATH" "$R0/share/snmp"
FunctionEnd

Function CreateAgentBats
  SetOutPath "$INSTDIR\"
  ClearErrors
  
  ; Slash it
  Push $INSTDIR
  Push "\"
  Push "/"
  Call StrRep
  Pop $R0
  
  FileOpen $0 "registeragent.bat" "w"
  IfErrors cleanup

  StrCmp $winExtDLL "1" CreateAgentBats_winExtDLL CreateAgentBats_normal

  CreateAgentBats_winExtDLL:
  FileWrite $0 "@echo off $\r$\n \
		set cmdline=$\"$INSTDIR\bin\snmpd.exe$\" -register $\r$\n\
		set additionaloptions= -Lf $\"$R0/log/snmpd.log$\" -I-udp,udpTable,tcp,tcpTable,icmp,ip,interfaces,system_mib,sysORTable$\r$\n"
  goto CreateAgentBats_continue

  CreateAgentBats_normal:
  FileWrite $0 "@echo off $\r$\n \
		set cmdline=$\"$INSTDIR\bin\snmpd.exe$\" -register $\r$\n\
		set additionaloptions= -Lf $\"$R0/log/snmpd.log$\"$\r$\n"

  CreateAgentBats_continue:

  FileWrite $0 "echo Registering snmpd as a service using the following additional options: $\r$\n \
		echo . $\r$\n \
		echo %additionaloptions% $\r$\n \
		$\r$\n"

  FileWrite $0 "echo . $\r$\n \
		%cmdline% %additionaloptions% $\r$\n \
                echo .  $\r$\n \
		echo For information on running snmpd.exe and snmptrapd.exe as a Windows $\r$\n \
		echo service, see 'How to Register the Net-SNMP Agent and Trap Daemon as $\r$\n \
		echo Windows services' in README.win32. $\r$\n \
		echo . $\r$\n \
		pause"

  ClearErrors
  FileOpen $1 "unregisteragent.bat" "w"
  IfErrors cleanup
  FileWrite $1 "@echo off $\r$\n \
		$\"$INSTDIR\bin\snmpd.exe$\" -unregister"

  cleanup:
  FileClose $0
  FileClose $1
FunctionEnd

; The trap receiver has not been tested
; completely as a Windows service.
Function CreateTrapdBats
  SetOutPath "$INSTDIR\"
  ClearErrors
  
  ; Slash it
  Push $INSTDIR
  Push "\"
  Push "/"
  Call StrRep
  Pop $R0
  
  FileOpen $0 "registertrapd.bat" "w"
  IfErrors cleanup
  IfErrors cleanup
  FileWrite $0 "@echo off $\r$\n \
		set cmdline=$\"$INSTDIR\bin\snmptrapd.exe$\" -register $\r$\n\
		set additionaloptions= -Lf $\"$R0/log/snmptrapd.log$\"$\r$\n"

  FileWrite $0 "echo Registering snmptrapd as a service using the following additional options: $\r$\n \
		echo . $\r$\n \
		echo %additionaloptions% $\r$\n \
		$\r$\n"

  FileWrite $0 "echo . $\r$\n \
		%cmdline% %additionaloptions% $\r$\n \
                echo .  $\r$\n \
		echo For information on running snmpd.exe and snmptrapd.exe as a Windows $\r$\n \
		echo service, see 'How to Register the Net-SNMP Agent and Trap Daemon as $\r$\n \
		echo Windows services' in README.win32. $\r$\n \
		echo . $\r$\n \
		pause"

  ClearErrors
  FileOpen $1 "unregistertrapd.bat" "w"
  IfErrors cleanup
  FileWrite $1 "@echo off $\r$\n \
		$\"$INSTDIR\bin\snmptrapd.exe$\" -unregister"
		
  cleanup:
  FileClose $0
  FileClose $1
FunctionEnd

Function CreateSnmpconfBat
  SetOutPath "$INSTDIR\bin\"
  ClearErrors
  FileOpen $0 "snmpconf.bat" "r"
  GetTempFileName $R0
  FileOpen $1 $R0 "w"
  snmpconfloop:
    FileRead $0 $2
    IfErrors done
    StrCmp $2 "set MYPERLPROGRAM=c:\usr\bin\snmpconf$\n" 0 +3
      FileWrite $1 "set MYPERLPROGRAM=$INSTDIR\bin\snmpconf$\n"
      Goto snmpconfloop
    StrCmp $2 "set MYPERLPROGRAM=c:\usr\bin\snmpconf$\r$\n" 0 +3
      FileWrite $1 "set MYPERLPROGRAM=$INSTDIR\bin\snmpconf$\r$\n"
      Goto snmpconfloop
    FileWrite $1 $2
    Goto snmpconfloop

  done:
    FileClose $0
    FileClose $1
    Delete "snmpconf.bat"
    CopyFiles /SILENT $R0 "snmpconf.bat"
    Delete $R0
FunctionEnd

Function CreateMib2cBat
  SetOutPath "$INSTDIR\bin\"
  ClearErrors
  FileOpen $0 "mib2c.bat" "r"
  GetTempFileName $R0
  FileOpen $1 $R0 "w"
  mib2cloop:
    FileRead $0 $2
    IfErrors done
    StrCmp $2 "set MYPERLPROGRAM=c:\usr\bin\mib2c$\n" 0 +3
      FileWrite $1 "set MYPERLPROGRAM=$INSTDIR\bin\mib2c$\n"
      Goto mib2cloop
    StrCmp $2 "set MYPERLPROGRAM=c:\usr\bin\mib2c$\r$\n" 0 +3
      FileWrite $1 "set MYPERLPROGRAM=$INSTDIR\bin\mib2c$\r$\n"
      Goto mib2cloop
    FileWrite $1 $2
    Goto mib2cloop

  done:
    FileClose $0
    FileClose $1
    Delete "mib2c.bat"
    CopyFiles /SILENT $R0 "mib2c.bat"
    Delete $R0
FunctionEnd

Function CreatTraptoemailBat
  SetOutPath "$INSTDIR\bin\"
  ClearErrors
  FileOpen $0 "traptoemail.bat" "r"
  GetTempFileName $R0
  FileOpen $1 $R0 "w"
  traptoemailloop:
    FileRead $0 $2
    IfErrors done
    StrCmp $2 "set MYPERLPROGRAM=c:\usr\bin\traptoemail$\n" 0 +3
      FileWrite $1 "set MYPERLPROGRAM=$INSTDIR\bin\traptoemail$\n"
      Goto traptoemailloop
    StrCmp $2 "set MYPERLPROGRAM=c:\usr\bin\traptoemail$\r$\n" 0 +3
      FileWrite $1 "set MYPERLPROGRAM=$INSTDIR\bin\traptoemail$\r$\n"
      Goto traptoemailloop
    FileWrite $1 $2
    Goto traptoemailloop

  done:
    FileClose $0
    FileClose $1
    Delete "traptoemail.bat"
    CopyFiles /SILENT $R0 "traptoemail.bat"
    Delete $R0
FunctionEnd

Function StrRep
  Exch $R4 ; $R4 = Replacement String
  Exch
  Exch $R3 ; $R3 = String to replace (needle)
  Exch 2
  Exch $R1 ; $R1 = String to do replacement in (haystack)
  Push $R2 ; Replaced haystack
  Push $R5 ; Len (needle)
  Push $R6 ; len (haystack)
  Push $R7 ; Scratch reg
  StrCpy $R2 ""
  StrLen $R5 $R3
  StrLen $R6 $R1
loop:
  StrCpy $R7 $R1 $R5
  StrCmp $R7 $R3 found
  StrCpy $R7 $R1 1 ; - optimization can be removed if U know len needle=1
  StrCpy $R2 "$R2$R7"
  StrCpy $R1 $R1 $R6 1
  StrCmp $R1 "" done loop
found:
  StrCpy $R2 "$R2$R4"
  StrCpy $R1 $R1 $R6 $R5
  StrCmp $R1 "" done loop
done:
  StrCpy $R3 $R2
  Pop $R7
  Pop $R6
  Pop $R5
  Pop $R2
  Pop $R1
  Pop $R4
  Exch $R3
FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  SetRegView 64		; Prevent the installer from using the Wow6432Node HKLM subkey on 64-bit systems
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Function .onInit
SetRegView 64		; Prevent the installer from using the Wow6432Node HKLM subkey on 64-bit systems
Push $0
Push $R0
Push $R1

; Check for /? command line usage option
${GetParameters} $R1
StrCpy $cmdLineParameters $R1
ClearErrors
${GetOptions} $cmdLineParameters '/?' $R0
IfErrors +3 0
MessageBox MB_OK "Options:$\n  \StartMenu={GroupName}$\n  \Agent=standard|extDLL|none   (default standard)$\n  \noTrapd$\t(default \Trapd)$\n  \noPerl$\t$\t(default \Perl)$\n  \Dev$\t$\t(default \noDev)$\n  \OpenSSL$\t(default \noOpenSSL)"
Abort

; Make sure we're running Windows 2000 (5.0) or higher
${If} ${AtMostWinME}
MessageBox MB_ICONINFORMATION|MB_OK "This version of $(^Name) requires Windows 2000 or higher.  For Windows NT and lower, please use Net-SNMP 5.4."
Quit
${Endif}

; Make sure we're running the right platform
;INSTALLER_PLATFORM
${If} ${INSTALLER_PLATFORM} == "x64"
  ;MessageBox MB_OK "64-bit binary"
  ${IfNot} ${RunningX64}
    ;MessageBox MB_OK "32-bit OS"
	MessageBox MB_OK "This Net-SNMP package requires 64-bit Windows (x64).  Please download the x86 installer package."
	Quit
  ${Else}
    ;MessageBox MB_OK "64-bit OS"
  ${EndIf}
${Else}
  ;MessageBox MB_OK "x86 (32-bit) binary"
  ${If} ${RunningX64}
    ;MessageBox MB_OK "64-bit OS"
	MessageBox MB_OK "You are installing a 32-bit package on a 64-bit operating system.  All applications should work except for the 'Net-SNMP Agent Service with Windows Extension DLL support'.  Please download the x64 installer package."
  ${EndIf}	
${EndIf}

; Disable Development files section by default
SectionGetFlags ${SEC06} $0
IntOp $0 $0 & ${SECTION_OFF}
SectionSetFlags ${SEC06} $0

; Disable OpenSSL section by default
SectionGetFlags ${SEC07} $0
IntOp $0 $0 & ${SECTION_OFF}
SectionSetFlags ${SEC07} $0
StrCpy $openSSL "false"

; Disable Agent with winExtDLL support - user can select either but not both.
StrCpy $R8 ${SEC02}
SectionGetFlags ${SEC02} $0
IntOp $0 $0 | ${SF_SELECTED}
SectionSetFlags ${SEC02} $0
SectionGetFlags ${SEC03} $0
IntOp $0 $0 & ${SECTION_OFF}
SectionSetFlags ${SEC03} $0

; Store current status of SEC07 (SSL).  Used for checking if OpenSSL is installed.
SectionGetFlags ${SEC07} $R9

; process other command line parameters
Call parseParameters

Pop $R0
Pop $0
FunctionEnd

Function parseParameters
  Push $R0
  Push $0

  ; /StartMenu=
  ClearErrors
  ${GetOptions} $cmdLineParameters "/StartMenu="  $R0
  IfErrors +2 0
  StrCpy $ICONS_GROUP $R0

  ; /{no,}Trapd  
  ClearErrors
  ${GetOptions} $cmdLineParameters "/Trapd"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC04} $0
  IntOp $0 $0 | ${SF_SELECTED}
  SectionSetFlags ${SEC04} $0
  ClearErrors
  ${GetOptions} $cmdLineParameters "/noTrapd"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC04} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC04} $0

  ; /{no,}Perl  
/*
  ClearErrors
  ${GetOptions} $cmdLineParameters "/Perl"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC05} $0
  IntOp $0 $0 | ${SF_SELECTED}
  SectionSetFlags ${SEC05} $0
  ClearErrors
  ${GetOptions} $cmdLineParameters "/noPerl"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC05} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC05} $0
*/

  ; /{no,}Dev  
  ClearErrors
  ${GetOptions} $cmdLineParameters "/Dev"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC06} $0
  IntOp $0 $0 | ${SF_SELECTED}
  SectionSetFlags ${SEC06} $0
  ClearErrors
  ${GetOptions} $cmdLineParameters "/noDev"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC06} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC06} $0

  ; /{no,}OpenSSL  
  ClearErrors
  ${GetOptions} $cmdLineParameters "/OpenSSL"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC07} $0
  IntOp $0 $0 | ${SF_SELECTED}
  SectionSetFlags ${SEC07} $0
  ClearErrors
  ${GetOptions} $cmdLineParameters "/noOpenSSL"  $R0
  IfErrors +4 0
  SectionGetFlags ${SEC07} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC07} $0

  ; /Agent=  
  ClearErrors
  ${GetOptions} $cmdLineParameters "/Agent="  $R0
  IfErrors endOfAgent 0
  ; /Agent=none
  ClearErrors
  StrCmp $R0 "none" 0 standardAgent
  SectionGetFlags ${SEC02} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC02} $0
  SectionGetFlags ${SEC03} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC03} $0
  Goto endOfAgent
  
  standardAgent:
  ; /Agent=standard
  ClearErrors
  StrCmp $R0 "standard" 0 winExtDLLAgent
  SectionGetFlags ${SEC02} $0
  IntOp $0 $0 | ${SF_SELECTED}
  SectionSetFlags ${SEC02} $0
  SectionGetFlags ${SEC03} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC03} $0
  Goto endOfAgent
  
  winExtDLLAgent:
  ; /Agent=extDLL
  ClearErrors
  StrCmp $R0 "extDLL" 0 endOfAgent
  SectionGetFlags ${SEC02} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC02} $0
  SectionGetFlags ${SEC03} $0
  IntOp $0 $0 | ${SF_SELECTED}
  SectionSetFlags ${SEC03} $0
  endOfAgent:
  
  Pop $R0  
FunctionEnd

Function .onSelChange

;  !insertmacro StartRadioButtons $2
    ;!insertmacro RadioButton ${SEC02}
    ;!insertmacro RadioButton ${SEC03}
  ;!insertmacro EndRadioButtons

  # Create a backup copy of $0
  Push $0

  ; Agent - Only allow user to select standard or winExtDLL agent
  StrCmp $R8 ${SEC02} onSelChange_check_SEC3
  SectionGetFlags ${SEC02} $0
  IntOp $0 $0 & ${SF_SELECTED}
  IntCmp $0 ${SF_SELECTED} 0 onSelChange_agent_done onSelChange_agent_done
  StrCpy $R8 ${SEC02}
  SectionGetFlags ${SEC03} $0
  IntOp $0 $0 & ${SECTION_OFF}
  SectionSetFlags ${SEC03} $0
  Goto onSelChange_agent_done
 
  onSelChange_check_SEC3:
    SectionGetFlags ${SEC03} $0
    IntOp $0 $0 & ${SF_SELECTED}
    IntCmp $0 ${SF_SELECTED} 0 onSelChange_agent_done onSelChange_agent_done
    StrCpy $R8 ${SEC03}
    SectionGetFlags ${SEC02} $0
    IntOp $0 $0 & ${SECTION_OFF}
    SectionSetFlags ${SEC02} $0
 
  onSelChange_agent_done:

  ; If the user is installing a 32-bit binary on a 64-bit OS, disable winExtDLL agent.
  ${If} ${RunningX64}
    ${IfNot} ${INSTALLER_PLATFORM} == "x64"
	  SectionGetFlags ${SEC03} $0
      IntOp $0 $0 & ${SECTION_OFF}
      SectionSetFlags ${SEC03} $0
    ${EndIf}
  ${EndIf}
    
  ; If user selected Encryption support, make sure OpenSSL is installed.
  SectionGetFlags ${SEC07} $0
  IntOp $0 $0 & ${SF_SELECTED}
  IntCmp $0 ${SF_SELECTED} enableSSLonSelChange disableSSLonSelChange
  enableSSLonSelChange:
    StrCpy $openSSL "true"
    IntCmp $R9 $0 SSLalreadyEnabled SSLjustEnabled
    SSLjustEnabled:
      Call IsSSLInstalled
      SectionGetFlags ${SEC07} $R9
    SSLalreadyEnabled:
      goto continueSSLonSelChange
  disableSSLonSelChange:
    StrCpy $openSSL "false"
	SectionGetFlags ${SEC07} $R9
  continueSSLonSelChange:
  
  Pop $0

FunctionEnd

Section Uninstall
  ReadRegStr $ICONS_GROUP ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "${PRODUCT_STARTMENU_REGVAL}"

  ReadRegStr $1 "HKLM" "SYSTEM\CurrentControlSet\Services\Net-SNMP Agent" "DisplayName"
  IfErrors SkipAgentUninstall
  ExecWait "$\"$INSTDIR\bin\snmpd.exe$\" -unregister -quiet 2>nul$\r$\n"
  SkipAgentUninstall:

  ReadRegStr $1 "HKLM" "SYSTEM\CurrentControlSet\Services\Net-SNMP Trap Handler" "DisplayName"
  IfErrors SkipTrapDUninstall
  ExecWait "$\"$INSTDIR\bin\snmptrapd.exe$\" -unregister -quiet 2>nul$\r$\n" 
  SkipTrapDUninstall:

  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\registeragent.bat"
  Delete "$INSTDIR\unregisteragent.bat"
  Delete "$INSTDIR\registertrapd.bat"
  Delete "$INSTDIR\unregistertrapd.bat"
  Delete "$INSTDIR\perl\NetSNMP.ppd"
  Delete "$INSTDIR\perl\x86\NetSNMP.tar.gz"
  Delete "$INSTDIR\include\net-snmp\net-snmp-config.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_module_config.h"
  Delete "$INSTDIR\include\net-snmp\agent\mib_module_config.h"
  Delete "$INSTDIR\docs\COPYING"
  Delete "$INSTDIR\docs\Net-SNMP.chm"
  Delete "$INSTDIR\bin\net-snmp-perl-test.pl"
  ; ideally we should check whether this file has changed
  Delete "$INSTDIR\etc\snmp\snmp.conf"

  Delete "$INSTDIR\bin\snmptrapd.exe"
  Delete "$INSTDIR\bin\snmpd.exe"
  Delete "$INSTDIR\bin\snmpwalk.exe"
  Delete "$INSTDIR\bin\snmpbulkget.exe"
  Delete "$INSTDIR\bin\snmpbulkwalk.exe"
  Delete "$INSTDIR\bin\snmpconf.pl"
  Delete "$INSTDIR\bin\snmpdelta.exe"
  Delete "$INSTDIR\bin\snmpdf.exe"
  Delete "$INSTDIR\bin\snmpget.exe"
  Delete "$INSTDIR\bin\snmpgetnext.exe"
  Delete "$INSTDIR\bin\snmpnetstat.exe"
  Delete "$INSTDIR\bin\snmpset.exe"
  Delete "$INSTDIR\bin\snmpstatus.exe"
  Delete "$INSTDIR\bin\snmptable.exe"
  Delete "$INSTDIR\bin\snmptest.exe"
  Delete "$INSTDIR\bin\snmptranslate.exe"
  Delete "$INSTDIR\bin\snmptrap.exe"
  Delete "$INSTDIR\bin\snmpusm.exe"
  Delete "$INSTDIR\bin\snmpvacm.exe"
  Delete "$INSTDIR\bin\encode_keychange.exe"
  Delete "$INSTDIR\bin\netsnmp.dll"

  Delete "$INSTDIR\bin\mib2c"
  Delete "$INSTDIR\bin\mib2c.bat"
  Delete "$INSTDIR\bin\snmpconf"
  Delete "$INSTDIR\bin\snmpconf.bat"
  Delete "$INSTDIR\bin\traptoemail"
  Delete "$INSTDIR\bin\traptoemail.bat"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmp-data\authopts"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmp-data\debugging"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmp-data\mibs"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmp-data\output"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmp-data\snmpconf-config"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\acl"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\basic_setup"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\extending"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\monitor"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\operation"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\snmpconf-config"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\system"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmpd-data\trapsinks"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data\formatting"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data\snmpconf-config"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data\traphandle"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data\authentication"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data\logging"
  Delete "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data\runtime"
  Delete "$INSTDIR\share\snmp\mibs\AGENTX-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\BRIDGE-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-EVENT-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-EXPRESSION-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-NSLOOKUP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-PING-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-SCHEDULE-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-SCRIPT-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\DISMAN-TRACEROUTE-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\EtherLike-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\HCNUM-TC.txt"
  Delete "$INSTDIR\share\snmp\mibs\HOST-RESOURCES-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\HOST-RESOURCES-TYPES.txt"
  Delete "$INSTDIR\share\snmp\mibs\IANA-ADDRESS-FAMILY-NUMBERS-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IANAifType-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IANA-LANGUAGE-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IANA-RTPROTO-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IF-INVERTED-STACK-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IF-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\INET-ADDRESS-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IP-FORWARD-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IPV6-FLOW-LABEL-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IPV6-ICMP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IPV6-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IPV6-TC.txt"
  Delete "$INSTDIR\share\snmp\mibs\IPV6-TCP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\IPV6-UDP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\LM-SENSORS-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\MTA-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-AGENT-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-EXAMPLES-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-EXTEND-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-MONITOR-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-PASS-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-PERIODIC-NOTIFY-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-SYSTEM-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-TC.txt"
  Delete "$INSTDIR\share\snmp\mibs\NET-SNMP-VACM-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NETWORK-SERVICES-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\NOTIFICATION-LOG-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\RFC1155-SMI.txt"
  Delete "$INSTDIR\share\snmp\mibs\RFC1213-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\RFC-1215.txt"
  Delete "$INSTDIR\share\snmp\mibs\RMON-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SMUX-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SCTP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-COMMUNITY-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-FRAMEWORK-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-MPD-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-NOTIFICATION-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-PROXY-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-TARGET-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-TLS-TM-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-TSM-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-USER-BASED-SM-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-USM-AES-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-USM-DH-OBJECTS-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMPv2-CONF.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMPv2-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMPv2-SMI.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMPv2-TC.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMPv2-TM.txt"
  Delete "$INSTDIR\share\snmp\mibs\SNMP-VIEW-BASED-ACM-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\TCP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\TRANSPORT-ADDRESS-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\TUNNEL-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-DEMO-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-DISKIO-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-DLMOD-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-IPFILTER-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-IPFWACC-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-SNMP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\UCD-SNMP-MIB-OLD.txt"
  Delete "$INSTDIR\share\snmp\mibs\UDP-MIB.txt"
  Delete "$INSTDIR\share\snmp\mibs\.index"
  Delete "$INSTDIR\snmp\persist\mib_indexes\0"

  Delete "$INSTDIR\share\snmp\mib2c.access_functions.conf"
  Delete "$INSTDIR\share\snmp\mib2c.array-user.conf"
  Delete "$INSTDIR\share\snmp\mib2c.check_values.conf"
  Delete "$INSTDIR\share\snmp\mib2c.check_values_local.conf"
  Delete "$INSTDIR\share\snmp\mib2c.column_defines.conf"
  Delete "$INSTDIR\share\snmp\mib2c.column_enums.conf"
  Delete "$INSTDIR\share\snmp\mib2c.column_storage.conf"
  Delete "$INSTDIR\share\snmp\mib2c.conf"
  Delete "$INSTDIR\share\snmp\mib2c.container.conf"
  Delete "$INSTDIR\share\snmp\mib2c.create-dataset.conf"
  Delete "$INSTDIR\share\snmp\mib2c.emulation.conf"
  Delete "$INSTDIR\share\snmp\mib2c.genhtml.conf"
  Delete "$INSTDIR\share\snmp\mib2c.int_watch.conf"
  Delete "$INSTDIR\share\snmp\mib2c.iterate.conf"
  Delete "$INSTDIR\share\snmp\mib2c.iterate_access.conf"
  Delete "$INSTDIR\share\snmp\mib2c.mfd.conf"
  Delete "$INSTDIR\share\snmp\mib2c.notify.conf"
  Delete "$INSTDIR\share\snmp\mib2c.old-api.conf"
  Delete "$INSTDIR\share\snmp\mib2c.perl.conf"
  Delete "$INSTDIR\share\snmp\mib2c.raw-table.conf"
  Delete "$INSTDIR\share\snmp\mib2c.row.conf"
  Delete "$INSTDIR\share\snmp\mib2c.scalar.conf"
  Delete "$INSTDIR\share\snmp\mib2c.table_data.conf"

  Delete "$INSTDIR\share\snmp\mib2c-data\default-mfd-top.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\details-enums.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\details-node.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\details-table.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-ctx-copy.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-ctx-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-ctx-set.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-data-allocate.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-data-context.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-get-char.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-get-decl-bot.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-get-decl.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-get-long.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-get-oid.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-header-bottom.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-header-top.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-source-includes.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-constants.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-enums.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-indexes-from-oid.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-indexes-set.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-indexes-to-oid.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-indexes-varbind-setup.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-indexes.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-table-oids.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-value-map-func.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-value-map-reverse.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\generic-value-map.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\m2c-internal-warning.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\m2c_setup_enum.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\m2c_setup_node.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\m2c_setup_table.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\m2c_table_save_defaults.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-access-container-cached-defines.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-access-unsorted-external-defines.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-data-access.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-data-get.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-data-set.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-doxygen.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-interactive-setup.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-interface.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-makefile.m2m"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-persistence.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-readme.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\mfd-top.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\node-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\node-set.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\node-storage.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\node-validate.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\node-varbind-validate.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\parent-dependencies.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\parent-set.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\subagent.m2c"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-COUNTER64-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-DateAndTime-get.m2d"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-DateAndTime-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-DateAndTime-readme.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-InetAddress-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-InetAddress-set.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-InetAddressType-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-InetAddressType-set.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-RowStatus-dependencies.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-RowStatus-get.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-RowStatus-varbind-validate.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-StorageType-dependencies.m2i"
  Delete "$INSTDIR\share\snmp\mib2c-data\syntax-TestAndIncr-get.m2i"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Net-SNMP Help.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\README.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Register Agent Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Agent Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Register Trap Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Trap Service.lnk"
  Delete "$INSTDIR\snmp\persist\snmpd.conf"
  Delete "$INSTDIR\snmp\persist\snmptrapd.conf"

  Delete "$INSTDIR\include\net-snmp\config_api.h"
  Delete "$INSTDIR\include\net-snmp\snmpv3_api.h"
  Delete "$INSTDIR\include\net-snmp\version.h"
  Delete "$INSTDIR\include\net-snmp\session_api.h"
  Delete "$INSTDIR\include\net-snmp\output_api.h"
  Delete "$INSTDIR\include\net-snmp\types.h"
  Delete "$INSTDIR\include\net-snmp\mib_api.h"
  Delete "$INSTDIR\include\net-snmp\pdu_api.h"
  Delete "$INSTDIR\include\net-snmp\definitions.h"
  Delete "$INSTDIR\include\net-snmp\utilities.h"
  Delete "$INSTDIR\include\net-snmp\net-snmp-includes.h"
  Delete "$INSTDIR\include\net-snmp\varbind_api.h"
  Delete "$INSTDIR\include\net-snmp\net-snmp-config.h"

  Delete "$INSTDIR\include\net-snmp\system\irix.h"
  Delete "$INSTDIR\include\net-snmp\system\bsdi4.h"
  Delete "$INSTDIR\include\net-snmp\system\generic.h"
  Delete "$INSTDIR\include\net-snmp\system\sysv.h"
  Delete "$INSTDIR\include\net-snmp\system\hpux.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd2.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd.h"
  Delete "$INSTDIR\include\net-snmp\system\bsdi3.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.3.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.4.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.5.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.6.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd6.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd7.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd8.h"
  Delete "$INSTDIR\include\net-snmp\system\kfreebsd.h"
  Delete "$INSTDIR\include\net-snmp\system\dragonfly.h"
  Delete "$INSTDIR\include\net-snmp\system\mingw32.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.9.h"
  Delete "$INSTDIR\include\net-snmp\system\linux.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd5.h"
  Delete "$INSTDIR\include\net-snmp\system\aix.h"
  Delete "$INSTDIR\include\net-snmp\system\mingw32msvc.h"
  Delete "$INSTDIR\include\net-snmp\system\openbsd.h"
  Delete "$INSTDIR\include\net-snmp\system\mips.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.7.h"
  Delete "$INSTDIR\include\net-snmp\system\sunos.h"
  Delete "$INSTDIR\include\net-snmp\system\darwin7.h"
  Delete "$INSTDIR\include\net-snmp\system\netbsd.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.8.h"
  Delete "$INSTDIR\include\net-snmp\system\svr5.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd4.h"
  Delete "$INSTDIR\include\net-snmp\system\freebsd3.h"
  Delete "$INSTDIR\include\net-snmp\system\osf5.h"
  Delete "$INSTDIR\include\net-snmp\system\darwin.h"
  Delete "$INSTDIR\include\net-snmp\system\ultrix4.h"
  Delete "$INSTDIR\include\net-snmp\system\bsdi.h"
  Delete "$INSTDIR\include\net-snmp\system\cygwin.h"
  Delete "$INSTDIR\include\net-snmp\system\dynix.h"
  Delete "$INSTDIR\include\net-snmp\system\bsd.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris.h"
  Delete "$INSTDIR\include\net-snmp\system\darwin8.h"
  Delete "$INSTDIR\include\net-snmp\system\darwin9.h"
  Delete "$INSTDIR\include\net-snmp\system\solaris2.10.h"

  Delete "$INSTDIR\include\net-snmp\library\snmp_transport.h"
  Delete "$INSTDIR\include\net-snmp\library\container_binary_array.h"
  Delete "$INSTDIR\include\net-snmp\library\data_list.h"
  Delete "$INSTDIR\include\net-snmp\library\factory.h"
  Delete "$INSTDIR\include\net-snmp\library\md5.h"
  Delete "$INSTDIR\include\net-snmp\library\scapi.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpCallbackDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_debug.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_impl.h"
  Delete "$INSTDIR\include\net-snmp\library\libsnmp.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_assert.h"
  Delete "$INSTDIR\include\net-snmp\library\callback.h"
  Delete "$INSTDIR\include\net-snmp\library\mt_support.h"
  Delete "$INSTDIR\include\net-snmp\library\ucd_compat.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpIPXDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpksm.h"
  Delete "$INSTDIR\include\net-snmp\library\lcd_time.h"
  Delete "$INSTDIR\include\net-snmp\library\container.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpAAL5PVCDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\asn1.h"
  Delete "$INSTDIR\include\net-snmp\library\container_null.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_parse_args.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpusm.h"
  Delete "$INSTDIR\include\net-snmp\library\default_store.h"
  Delete "$INSTDIR\include\net-snmp\library\check_varbind.h"
  Delete "$INSTDIR\include\net-snmp\library\parse.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_api.h"
  Delete "$INSTDIR\include\net-snmp\library\transform_oids.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpUnixDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\container_iterator.h"
  Delete "$INSTDIR\include\net-snmp\library\mib.h"
  Delete "$INSTDIR\include\net-snmp\library\winservice.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpTCPIPv6Domain.h"
  Delete "$INSTDIR\include\net-snmp\library\int64.h"
  Delete "$INSTDIR\include\net-snmp\library\keytools.h"
  Delete "$INSTDIR\include\net-snmp\library\container_list_ssll.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_secmod.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp.h"
  Delete "$INSTDIR\include\net-snmp\library\getopt.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_logging.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_alarm.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_client.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpUDPIPv6Domain.h"
  Delete "$INSTDIR\include\net-snmp\library\read_config.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp-tc.h"
  Delete "$INSTDIR\include\net-snmp\library\vacm.h"
  Delete "$INSTDIR\include\net-snmp\library\system.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_locking.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpv3.h"
  Delete "$INSTDIR\include\net-snmp\library\oid_stash.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpAliasDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpDTLSUDPDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpSSHDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpSTDDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpTCPDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpUDPDomain.h"
  Delete "$INSTDIR\include\net-snmp\library\tools.h"
  Delete "$INSTDIR\include\net-snmp\library\winpipe.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_enum.h"
  Delete "$INSTDIR\include\net-snmp\library\cmu_compat.h"
  Delete "$INSTDIR\include\net-snmp\library\snmpv3-security-includes.h"
  Delete "$INSTDIR\include\net-snmp\library\dir_utils.h"
  Delete "$INSTDIR\include\net-snmp\library\file_utils.h"
  Delete "$INSTDIR\include\net-snmp\library\text_utils.h"
  Delete "$INSTDIR\include\net-snmp\library\types.h"
  Delete "$INSTDIR\include\net-snmp\library\fd_event_manager.h"
  Delete "$INSTDIR\include\net-snmp\library\large_fd_set.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_openssl.h"
  Delete "$INSTDIR\include\net-snmp\library\snmp_service.h"
  Delete "$INSTDIR\include\net-snmp\library\snmptsm.h"

  Delete "$INSTDIR\include\net-snmp\agent\stash_cache.h"
  Delete "$INSTDIR\include\net-snmp\agent\instance.h"
  Delete "$INSTDIR\include\net-snmp\agent\snmp_agent.h"
  Delete "$INSTDIR\include\net-snmp\agent\table_array.h"
  Delete "$INSTDIR\include\net-snmp\agent\table_container.h"
  Delete "$INSTDIR\include\net-snmp\agent\bulk_to_next.h"
  Delete "$INSTDIR\include\net-snmp\agent\set_helper.h"
  Delete "$INSTDIR\include\net-snmp\agent\watcher.h"
  Delete "$INSTDIR\include\net-snmp\agent\baby_steps.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_callbacks.h"
  Delete "$INSTDIR\include\net-snmp\agent\snmp_vars.h"
  Delete "$INSTDIR\include\net-snmp\agent\multiplexer.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_index.h"
  Delete "$INSTDIR\include\net-snmp\agent\table_iterator.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_handler.h"
  Delete "$INSTDIR\include\net-snmp\agent\table.h"
  Delete "$INSTDIR\include\net-snmp\agent\net-snmp-agent-includes.h"
  Delete "$INSTDIR\include\net-snmp\agent\old_api.h"
  Delete "$INSTDIR\include\net-snmp\agent\all_helpers.h"
  Delete "$INSTDIR\include\net-snmp\agent\scalar.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_registry.h"
  Delete "$INSTDIR\include\net-snmp\agent\mib_modules.h"
  Delete "$INSTDIR\include\net-snmp\agent\mfd.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_trap.h"
  Delete "$INSTDIR\include\net-snmp\agent\cache_handler.h"
  Delete "$INSTDIR\include\net-snmp\agent\table_dataset.h"
  Delete "$INSTDIR\include\net-snmp\agent\debug_handler.h"
  Delete "$INSTDIR\include\net-snmp\agent\table_data.h"
  Delete "$INSTDIR\include\net-snmp\agent\var_struct.h"
  Delete "$INSTDIR\include\net-snmp\agent\row_merge.h"
  Delete "$INSTDIR\include\net-snmp\agent\read_only.h"
  Delete "$INSTDIR\include\net-snmp\agent\auto_nlist.h"
  Delete "$INSTDIR\include\net-snmp\agent\mode_end_call.h"
  Delete "$INSTDIR\include\net-snmp\agent\scalar_group.h"
  Delete "$INSTDIR\include\net-snmp\agent\object_monitor.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_read_config.h"
  Delete "$INSTDIR\include\net-snmp\agent\ds_agent.h"
  Delete "$INSTDIR\include\net-snmp\agent\null.h"
  Delete "$INSTDIR\include\net-snmp\agent\serialize.h"
  Delete "$INSTDIR\include\net-snmp\agent\stash_to_next.h"
  Delete "$INSTDIR\include\net-snmp\agent\table_tdata.h"
  Delete "$INSTDIR\include\net-snmp\agent\sysORTable.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_sysORTable.h"
  Delete "$INSTDIR\include\net-snmp\agent\mib_module_config.h"
  Delete "$INSTDIR\include\net-snmp\agent\agent_module_config.h"

  Delete "$INSTDIR\include\net-snmp\machine\generic.h"

  Delete "$INSTDIR\include\net-snmp\data_access\arp.h"
  Delete "$INSTDIR\include\net-snmp\data_access\net-snmp-data-access-includes.h"
  Delete "$INSTDIR\include\net-snmp\data_access\interface.h"
  Delete "$INSTDIR\include\net-snmp\data_access\systemstats.h"
  Delete "$INSTDIR\include\net-snmp\data_access\route.h"
  Delete "$INSTDIR\include\net-snmp\data_access\ipstats.h"
  Delete "$INSTDIR\include\net-snmp\data_access\ipaddress.h"
  Delete "$INSTDIR\include\net-snmp\data_access\tcpConn.h"
  Delete "$INSTDIR\include\net-snmp\data_access\default_route.h"
  Delete "$INSTDIR\include\net-snmp\data_access\ip_scalars.h"
  Delete "$INSTDIR\include\net-snmp\data_access\scopezone.h"
  Delete "$INSTDIR\include\net-snmp\data_access\swinst.h"
  Delete "$INSTDIR\include\net-snmp\data_access\swrun.h"
  Delete "$INSTDIR\include\net-snmp\data_access\udp_endpoint.h"

  Delete "$INSTDIR\lib\netsnmpagent.lib"
  Delete "$INSTDIR\lib\netsnmphelpers.lib"
  Delete "$INSTDIR\lib\netsnmp.lib"
  Delete "$INSTDIR\lib\netsnmptrapd.lib"
  Delete "$INSTDIR\lib\netsnmpmibs.lib"
  Delete "$INSTDIR\lib\netsnmp.exp"
  
  RMDir "$INSTDIR\perl\x86"
  RMDir "$INSTDIR\perl"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\include\net-snmp\agent"
  RMDir "$INSTDIR\include\net-snmp\data_access"
  RMDir "$INSTDIR\include\net-snmp\library"
  RMDir "$INSTDIR\include\net-snmp\machine"
  RMDir "$INSTDIR\include\net-snmp\system"
  RMDir "$INSTDIR\include\net-snmp"
  RMDir "$INSTDIR\include\ucd-snmp"
  RMDir "$INSTDIR\include"
  RMDir "$INSTDIR\docs"
  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR\share\snmp\snmpconf-data\snmptrapd-data"
  RMDir "$INSTDIR\share\snmp\snmpconf-data\snmpd-data"
  RMDir "$INSTDIR\share\snmp\snmpconf-data\snmp-data"
  RMDir "$INSTDIR\share\snmp\snmpconf-data"
  RMDir "$INSTDIR\share\snmp\mib2c-data"
  RMDir "$INSTDIR\share\snmp\mibs"
  RMDir "$INSTDIR\share\snmp"
  RMDir "$INSTDIR\share"

  RMDir "$INSTDIR\temp"
  RMDir "$INSTDIR\snmp\persist\mib_indexes"
  RMDir "$INSTDIR\snmp\persist"
  RMDir "$INSTDIR\snmp"
  RMDir "$INSTDIR\etc\snmp"
  RMDir "$INSTDIR\etc"
  RMDir "$INSTDIR\include\net-snmp\agent"
  RMDir "$INSTDIR\include\net-snmp"
  RMDir "$INSTDIR\include"
  RMDir "$INSTDIR\log"
  RMDir "$INSTDIR"
  
  ; Start Menu entries may have been installed for the current user only,
  ; or for All Users.  So let's delete both sets....
  SetShellVarContext current
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Net-SNMP Help.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\README.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Register Agent Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Agent Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Register Trap Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Trap Service.lnk"
  RMDir "$SMPROGRAMS\$ICONS_GROUP\Service"
  RMDir "$SMPROGRAMS\$ICONS_GROUP"

  SetShellVarContext all
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Net-SNMP Help.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\README.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Register Agent Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Agent Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Register Trap Service.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Service\Unregister Trap Service.lnk"
  RMDir "$SMPROGRAMS\$ICONS_GROUP\Service"
  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  
  ; Delete the environment variables
  ;Push "SNMPCONFPATH"
  ;Call un.DeleteEnvStr
  
  ;Push "SNMPSHAREPATH"
  ;Call un.DeleteEnvStr

  Push "$INSTDIR\bin"
  Call un.RemoveFromPath
  
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd

Function IsSSLInstalled
  Push $R0
  Push $R1

  GetDLLVersion libeay32.dll $R0 $R1
  IfErrors noSSL

  ; Continue installing if the DLL version is >= 1.0.0.0
  IntCmpU 65536 $R0 continueInstall continueInstall

  MessageBox MB_OK "This package is known not to work with OpenSSL versions before 1.0.0.  Please install the latest OpenSSL version from http://www.slproweb.com/products/Win32OpenSSL.html and try again."
  Quit

  noSSL:
    MessageBox MB_YESNO|MB_ICONQUESTION "OpenSSL does not appear to be installed.  OpenSSL is required for this installation of Net-SNMP.  Please install OpenSSL from http://www.slproweb.com/products/Win32OpenSSL.html and try again.  Would you like to continue installing anyways?" IDYES continueInstall
  Quit
  
  continueInstall:
  Pop $R1
  Pop $R0
FunctionEnd


