/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;
import prefuse.data.DataTypeException;
import prefuse.util.collections.BooleanIntBitSetMap;
import prefuse.util.collections.DoubleIntTreeMap;
import prefuse.util.collections.FloatIntTreeMap;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIntTreeMap;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;
import prefuse.util.collections.LongIntTreeMap;
import prefuse.util.collections.ObjectIntTreeMap;

public class SortedMapFactory {
    public static IntSortedMap getMap(Class type, Comparator cmp, boolean unique) throws IncompatibleComparatorException {
        if (!SortedMapFactory.comparatorCheck(type, cmp)) {
            throw new IncompatibleComparatorException();
        }
        if (type.equals(Integer.TYPE)) {
            return new IntIntTreeMap((LiteralComparator)cmp, !unique);
        }
        if (type.equals(Long.TYPE)) {
            return new LongIntTreeMap((LiteralComparator)cmp, !unique);
        }
        if (type.equals(Float.TYPE)) {
            return new FloatIntTreeMap((LiteralComparator)cmp, !unique);
        }
        if (type.equals(Double.TYPE)) {
            return new DoubleIntTreeMap((LiteralComparator)cmp, !unique);
        }
        if (type.equals(Boolean.TYPE)) {
            return new BooleanIntBitSetMap();
        }
        if (Object.class.isAssignableFrom(type)) {
            return new ObjectIntTreeMap(cmp, !unique);
        }
        throw new DataTypeException("No map available for the provided type");
    }

    public static boolean comparatorCheck(Class type, Comparator cmp) {
        if (cmp == null) {
            return true;
        }
        if (type.equals(Integer.TYPE)) {
            if (!(cmp instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)cmp).compare(0, 0);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (type.equals(Long.TYPE)) {
            if (!(cmp instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)cmp).compare(0L, 0L);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (type.equals(Float.TYPE)) {
            if (!(cmp instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)cmp).compare(0.0f, 0.0f);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (type.equals(Double.TYPE)) {
            if (!(cmp instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)cmp).compare(0.0, 0.0);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (type.equals(Boolean.TYPE)) {
            if (!(cmp instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)cmp).compare(false, false);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (Object.class.isAssignableFrom(type)) {
            return true;
        }
        throw new DataTypeException("No comparator available for the provided type");
    }
}

