/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.model.physical.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.modules.java.api.model.physical.BelongsTo;
import org.netbeans.modules.java.api.model.physical.ClassFeature;
import org.netbeans.modules.java.api.model.physical.ClassResource;
import org.netbeans.modules.java.api.model.physical.Codebase;
import org.netbeans.modules.java.api.model.physical.DefinesClass;
import org.netbeans.modules.java.api.model.physical.HasResources;
import org.netbeans.modules.java.api.model.physical.JavaClass;
import org.netbeans.modules.java.api.model.physical.PhysicalPackage;

public abstract class BelongsToImpl
extends AssociationHandler
implements BelongsTo {
    DefinesClass definesAssoc;
    HasResources resourcesAssoc;

    public BelongsToImpl(StorableAssociation storableAssociation) {
        super(storableAssociation);
    }

    void initializeData() {
        PhysicalPackage physicalPackage = (PhysicalPackage)this.refImmediatePackage();
        this.definesAssoc = physicalPackage.getDefinesClass();
        this.resourcesAssoc = physicalPackage.getHasResources();
    }

    public boolean exists(Codebase codebase, JavaClass javaClass) {
        return codebase.refImmediatePackage() == javaClass.refImmediatePackage();
    }

    public Collection getClasses(Codebase codebase) {
        if (this.definesAssoc == null) {
            this.initializeData();
        }
        Collection collection = this.resourcesAssoc.getResources(codebase);
        ArrayList arrayList = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassResource classResource = (ClassResource)iterator.next();
            this.addClasses(arrayList, this.definesAssoc.getDefinedClasses(classResource));
        }
        return arrayList;
    }

    private void addClasses(Collection collection, Collection collection2) {
        collection.addAll(collection2);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            this.addNestedClasses(collection, javaClass.getInitializers());
            this.addNestedClasses(collection, javaClass.getFields());
            this.addNestedClasses(collection, javaClass.getConstructors());
            this.addNestedClasses(collection, javaClass.getMethods());
            Collection collection3 = javaClass.getNestedClasses();
            this.addClasses(collection, collection3);
        }
    }

    private void addNestedClasses(Collection collection, Collection collection2) {
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ClassFeature classFeature = (ClassFeature)iterator.next();
            Collection collection3 = classFeature.getNestedClasses();
            if (collection3.isEmpty()) continue;
            this.addClasses(collection, collection3);
        }
    }

    public Codebase getCodebase(JavaClass javaClass) {
        if (this.definesAssoc == null) {
            this.initializeData();
        }
        JavaClass javaClass2 = javaClass.getEnclosingClass();
        while (javaClass2 != null) {
            javaClass = javaClass2;
            javaClass2 = javaClass.getEnclosingClass();
        }
        ClassResource classResource = this.definesAssoc.getClassResource(javaClass);
        if (classResource == null) {
            return null;
        }
        return this.resourcesAssoc.getCodebase(classResource);
    }
}

