/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class PropertyPointer
extends NodePointer {
    public static final int UNSPECIFIED_PROPERTY = Integer.MIN_VALUE;
    protected int propertyIndex = Integer.MIN_VALUE;
    protected Object bean;
    private static final Object UNINITIALIZED = new Object();
    private Object value = UNINITIALIZED;

    public PropertyPointer(NodePointer parent) {
        super(parent);
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public void setPropertyIndex(int index) {
        this.propertyIndex = index;
        index = Integer.MIN_VALUE;
    }

    public Object getBean() {
        if (this.bean == null) {
            this.bean = this.getParent().getNode();
        }
        return this.bean;
    }

    public QName getName() {
        return new QName(null, this.getPropertyName());
    }

    public abstract String getPropertyName();

    public abstract void setPropertyName(String var1);

    public abstract int getPropertyCount();

    public abstract String[] getPropertyNames();

    protected abstract boolean isActualProperty();

    public boolean isActual() {
        if (!this.isActualProperty()) {
            return false;
        }
        return super.isActual();
    }

    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == Integer.MIN_VALUE ? this.getBaseValue() : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public int getLength() {
        return ValueUtils.getLength(this.getBaseValue());
    }

    public NodePointer getImmediateValuePointer() {
        return NodePointer.newChildNodePointer(this, this.getName(), this.getImmediateNode());
    }

    public NodePointer createPath(JXPathContext context) {
        if (this.getImmediateNode() == null) {
            AbstractFactory factory = this.getAbstractFactory(context);
            int inx = this.index == Integer.MIN_VALUE ? 0 : this.index;
            boolean success = factory.createObject(context, this, this.getBean(), this.getPropertyName(), inx);
            if (!success) {
                throw new JXPathException("Factory " + factory + " could not create an object for path: " + this.asPath());
            }
        }
        return this;
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.index != Integer.MIN_VALUE && this.index >= this.getLength()) {
            this.createPath(context);
        }
        this.setValue(value);
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        PropertyPointer prop = (PropertyPointer)this.clone();
        if (name != null) {
            prop.setPropertyName(name.toString());
        }
        prop.setIndex(index);
        return prop.createPath(context, value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        PropertyPointer prop = (PropertyPointer)this.clone();
        if (name != null) {
            prop.setPropertyName(name.toString());
        }
        prop.setIndex(index);
        return prop.createPath(context);
    }

    public int hashCode() {
        return this.getParent().hashCode() + this.propertyIndex + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPointer)) {
            return false;
        }
        PropertyPointer other = (PropertyPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.getPropertyIndex() != other.getPropertyIndex() || !this.getPropertyName().equals(other.getPropertyName())) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        return iThis == iOther;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return this.getValuePointer().compareChildNodePointers(pointer1, pointer2);
    }

    private AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }
}

