/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactoryImpl;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactoryImpl;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.Constants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarBuilder
implements ContentHandler {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static Log log = LogFactory.getLog((Class)CalendarBuilder.class);
    private CalendarParser parser;
    private TimeZoneRegistry registry;
    protected Calendar calendar;
    protected Component component;
    protected Component subComponent;
    protected Property property;

    public CalendarBuilder() {
        this(new CalendarParserImpl(), TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(CalendarParser calendarParser) {
        this(calendarParser, TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(TimeZoneRegistry timeZoneRegistry) {
        this(new CalendarParserImpl(), timeZoneRegistry);
    }

    public CalendarBuilder(CalendarParser calendarParser, TimeZoneRegistry timeZoneRegistry) {
        this.parser = calendarParser;
        this.registry = timeZoneRegistry;
    }

    public Calendar build(InputStream inputStream) throws IOException, ParserException {
        return this.build(new InputStreamReader(inputStream, DEFAULT_CHARSET));
    }

    public Calendar build(Reader reader) throws IOException, ParserException {
        UnfoldingReader unfoldingReader = new UnfoldingReader(reader);
        this.calendar = null;
        this.component = null;
        this.subComponent = null;
        this.property = null;
        this.parser.parse(unfoldingReader, (ContentHandler)this);
        return this.calendar;
    }

    public void endCalendar() {
    }

    public void endComponent(String string) {
        if (this.component != null) {
            if (this.subComponent != null) {
                if (this.component instanceof VTimeZone) {
                    ((VTimeZone)this.component).getObservances().add(this.subComponent);
                } else if (this.component instanceof VEvent) {
                    ((VEvent)this.component).getAlarms().add(this.subComponent);
                } else if (this.component instanceof VToDo) {
                    ((VToDo)this.component).getAlarms().add(this.subComponent);
                }
                this.subComponent = null;
            } else {
                this.calendar.getComponents().add(this.component);
                if (this.component instanceof VTimeZone && this.registry != null) {
                    this.registry.register(new TimeZone((VTimeZone)this.component));
                }
                this.component = null;
            }
        }
    }

    public void endProperty(String string) {
        if (this.property != null) {
            this.property = Constants.forProperty(this.property);
            if (this.component != null) {
                if (this.subComponent != null) {
                    this.subComponent.getProperties().add(this.property);
                } else {
                    this.component.getProperties().add(this.property);
                }
            } else if (this.calendar != null) {
                this.calendar.getProperties().add(this.property);
            }
            this.property = null;
        }
    }

    public void parameter(String string, String string2) throws URISyntaxException {
        if (this.property != null) {
            TimeZone timeZone;
            Parameter parameter = ParameterFactoryImpl.getInstance().createParameter(string.toUpperCase(), string2);
            this.property.getParameters().add(parameter);
            if (parameter instanceof TzId && this.registry != null && (timeZone = this.registry.getTimeZone(parameter.getValue())) != null) {
                try {
                    ((DateProperty)this.property).setTimeZone(timeZone);
                }
                catch (Exception exception) {
                    try {
                        ((DateListProperty)this.property).setTimeZone(timeZone);
                    }
                    catch (Exception exception2) {
                        log.warn((Object)("Error setting timezone [" + parameter + "] on property [" + this.property.getName() + "]"), (Throwable)exception);
                    }
                }
            }
        }
    }

    public void propertyValue(String string) throws URISyntaxException, ParseException, IOException {
        if (this.property != null) {
            this.property.setValue(string);
        }
    }

    public void startCalendar() {
        this.calendar = new Calendar();
    }

    public void startComponent(String string) {
        if (this.component != null) {
            this.subComponent = ComponentFactory.getInstance().createComponent(string);
        } else {
            this.component = ComponentFactory.getInstance().createComponent(string);
        }
    }

    public void startProperty(String string) {
        this.property = PropertyFactoryImpl.getInstance().createProperty(string.toUpperCase());
    }

    public final TimeZoneRegistry getRegistry() {
        return this.registry;
    }
}

