/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarParserImpl
implements CalendarParser {
    private static final int WORD_CHAR_START = 32;
    private static final int WORD_CHAR_END = 126;
    private static final int WHITESPACE_CHAR_START = 0;
    private static final int WHITESPACE_CHAR_END = 20;
    private static Log log = LogFactory.getLog((Class)CalendarParserImpl.class);

    public final void parse(InputStream inputStream, ContentHandler contentHandler) throws IOException, ParserException {
        this.parse(new InputStreamReader(inputStream), contentHandler);
    }

    public final void parse(Reader reader, ContentHandler contentHandler) throws IOException, ParserException {
        StreamTokenizer streamTokenizer = null;
        try {
            streamTokenizer = new StreamTokenizer(reader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(32, 126);
            streamTokenizer.whitespaceChars(0, 20);
            streamTokenizer.ordinaryChar(58);
            streamTokenizer.ordinaryChar(59);
            streamTokenizer.ordinaryChar(61);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.whitespaceChars(0, 0);
            streamTokenizer.quoteChar(34);
            CalendarParserImpl.assertToken(streamTokenizer, "BEGIN");
            CalendarParserImpl.assertToken(streamTokenizer, 58);
            CalendarParserImpl.assertToken(streamTokenizer, "VCALENDAR", true);
            CalendarParserImpl.assertToken(streamTokenizer, 10);
            contentHandler.startCalendar();
            this.parsePropertyList(streamTokenizer, contentHandler);
            this.parseComponentList(streamTokenizer, contentHandler);
            CalendarParserImpl.assertToken(streamTokenizer, 58);
            CalendarParserImpl.assertToken(streamTokenizer, "VCALENDAR", true);
            contentHandler.endCalendar();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ParserException) {
                throw (ParserException)exception;
            }
            String string = "An error ocurred during parsing";
            if (streamTokenizer != null) {
                int n = streamTokenizer.lineno();
                if (reader instanceof UnfoldingReader) {
                    n += ((UnfoldingReader)reader).getLinesUnfolded();
                }
                string = string + " - line: " + n;
            }
            throw new ParserException(string, exception);
        }
    }

    private void parsePropertyList(StreamTokenizer streamTokenizer, ContentHandler contentHandler) throws IOException, ParseException, URISyntaxException, ParserException {
        CalendarParserImpl.assertToken(streamTokenizer, -3);
        while (!"END".equals(streamTokenizer.sval)) {
            if ("BEGIN".equals(streamTokenizer.sval)) {
                this.parseComponent(streamTokenizer, contentHandler);
            } else {
                this.parseProperty(streamTokenizer, contentHandler);
            }
            this.absorbWhitespace(streamTokenizer);
        }
    }

    private void parseProperty(StreamTokenizer streamTokenizer, ContentHandler contentHandler) throws IOException, ParserException, URISyntaxException, ParseException {
        String string = streamTokenizer.sval;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property [" + string + "]"));
        }
        contentHandler.startProperty(string);
        this.parseParameterList(streamTokenizer, contentHandler);
        StringBuffer stringBuffer = new StringBuffer();
        int n = streamTokenizer.nextToken();
        while (n != 10 && n != -1) {
            if (streamTokenizer.ttype == -3) {
                stringBuffer.append(streamTokenizer.sval);
            } else if (streamTokenizer.ttype == 34) {
                stringBuffer.append((char)streamTokenizer.ttype);
                stringBuffer.append(streamTokenizer.sval);
            } else {
                stringBuffer.append((char)streamTokenizer.ttype);
            }
            n = streamTokenizer.nextToken();
        }
        if (n == -1) {
            throw new ParserException("Unexpected end of file at line " + streamTokenizer.lineno());
        }
        contentHandler.propertyValue(Strings.unescape(stringBuffer.toString()));
        contentHandler.endProperty(string);
    }

    private void parseParameterList(StreamTokenizer streamTokenizer, ContentHandler contentHandler) throws IOException, ParserException, URISyntaxException {
        while (streamTokenizer.nextToken() == 59) {
            this.parseParameter(streamTokenizer, contentHandler);
        }
    }

    private void parseParameter(StreamTokenizer streamTokenizer, ContentHandler contentHandler) throws IOException, ParserException, URISyntaxException {
        CalendarParserImpl.assertToken(streamTokenizer, -3);
        String string = streamTokenizer.sval;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter [" + string + "]"));
        }
        CalendarParserImpl.assertToken(streamTokenizer, 61);
        StringBuffer stringBuffer = new StringBuffer();
        if (streamTokenizer.nextToken() == 34) {
            stringBuffer.append('\"');
            stringBuffer.append(streamTokenizer.sval);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(streamTokenizer.sval);
        }
        contentHandler.parameter(string, Strings.unescape(stringBuffer.toString()));
    }

    private void parseComponentList(StreamTokenizer streamTokenizer, ContentHandler contentHandler) throws IOException, ParseException, URISyntaxException, ParserException {
        while ("BEGIN".equals(streamTokenizer.sval)) {
            this.parseComponent(streamTokenizer, contentHandler);
            this.absorbWhitespace(streamTokenizer);
        }
    }

    private void parseComponent(StreamTokenizer streamTokenizer, ContentHandler contentHandler) throws IOException, ParseException, URISyntaxException, ParserException {
        CalendarParserImpl.assertToken(streamTokenizer, 58);
        CalendarParserImpl.assertToken(streamTokenizer, -3);
        String string = streamTokenizer.sval;
        contentHandler.startComponent(string);
        CalendarParserImpl.assertToken(streamTokenizer, 10);
        this.parsePropertyList(streamTokenizer, contentHandler);
        CalendarParserImpl.assertToken(streamTokenizer, 58);
        CalendarParserImpl.assertToken(streamTokenizer, string);
        CalendarParserImpl.assertToken(streamTokenizer, 10);
        contentHandler.endComponent(string);
    }

    private static void assertToken(StreamTokenizer streamTokenizer, int n) throws IOException, ParserException {
        if (streamTokenizer.nextToken() != n) {
            throw new ParserException("Expected [" + n + "], read [" + streamTokenizer.ttype + "] at line " + streamTokenizer.lineno());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + n + "]"));
        }
    }

    private static void assertToken(StreamTokenizer streamTokenizer, String string) throws IOException, ParserException {
        CalendarParserImpl.assertToken(streamTokenizer, string, false);
    }

    private static void assertToken(StreamTokenizer streamTokenizer, String string, boolean bl) throws IOException, ParserException {
        CalendarParserImpl.assertToken(streamTokenizer, -3);
        if (bl ? !string.equalsIgnoreCase(streamTokenizer.sval) : !string.equals(streamTokenizer.sval)) {
            throw new ParserException("Expected [" + string + "], read [" + streamTokenizer.sval + "] at line " + streamTokenizer.lineno());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + string + "]"));
        }
    }

    private void absorbWhitespace(StreamTokenizer streamTokenizer) throws IOException {
        try {
            while (true) {
                CalendarParserImpl.assertToken(streamTokenizer, 10);
            }
        }
        catch (ParserException parserException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caught exception absorbing extra whitespace", (Throwable)parserException);
            }
            return;
        }
    }
}

