/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FoldingWriter
extends FilterWriter {
    public static final int REDUCED_FOLD_LENGTH = 73;
    public static final int MAX_FOLD_LENGTH = 75;
    private static final char[] FOLD_PATTERN = new char[]{'\r', '\n', ' '};
    private static Log log = LogFactory.getLog((Class)FoldingWriter.class);
    private int lineLength;
    private int foldLength;

    public FoldingWriter(Writer writer, int n) {
        super(writer);
        this.foldLength = Math.min(n, 75);
    }

    public FoldingWriter(Writer writer) {
        this(writer, 73);
    }

    public final void write(int n) throws IOException {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public final void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2 - 1;
        for (int i = n; i <= n3; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("char [" + cArray[i] + "], line length [" + this.lineLength + "]"));
            }
            if (this.lineLength >= this.foldLength) {
                super.write(FOLD_PATTERN, 0, FOLD_PATTERN.length);
                this.lineLength = 1;
            }
            super.write(cArray[i]);
            if (cArray[i] == '\n') {
                this.lineLength = 0;
                continue;
            }
            ++this.lineLength;
        }
    }

    public final void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }
}

