/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.XComponent;

public final class ComponentFactory {
    private static ComponentFactory instance = new ComponentFactory();

    private ComponentFactory() {
    }

    public static ComponentFactory getInstance() {
        return instance;
    }

    public Component createComponent(String string) {
        return this.createComponent(string, new PropertyList());
    }

    public Component createComponent(String string, PropertyList propertyList) {
        if ("VALARM".equals(string)) {
            return new VAlarm(propertyList);
        }
        if ("VEVENT".equals(string)) {
            return new VEvent(propertyList);
        }
        if ("VFREEBUSY".equals(string)) {
            return new VFreeBusy(propertyList);
        }
        if ("VJOURNAL".equals(string)) {
            return new VJournal(propertyList);
        }
        if ("VTODO".equals(string)) {
            return new VToDo(propertyList);
        }
        if ("STANDARD".equals(string)) {
            return new Standard(propertyList);
        }
        if ("DAYLIGHT".equals(string)) {
            return new Daylight(propertyList);
        }
        if ("VTIMEZONE".equals(string)) {
            return new VTimeZone(propertyList);
        }
        throw new IllegalArgumentException("Unkown component [" + string + "]");
    }

    public Component createComponent(String string, PropertyList propertyList, ComponentList componentList) {
        if (componentList != null) {
            if ("VTIMEZONE".equals(string)) {
                return new VTimeZone(propertyList, componentList);
            }
            if ("VEVENT".equals(string)) {
                return new VEvent(propertyList, componentList);
            }
            if (this.isExperimentalName(string)) {
                return new XComponent(string, propertyList);
            }
            throw new IllegalArgumentException("Unkown component [" + string + "]");
        }
        return this.createComponent(string, propertyList);
    }

    private boolean isExperimentalName(String string) {
        return string.startsWith("X-") && string.length() > "X-".length();
    }
}

