/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.TimeZones;

public class DateList
extends ArrayList
implements Serializable {
    private static final long serialVersionUID = 5925108767897130313L;
    private Value type;
    private TimeZone timeZone;

    public DateList() {
    }

    public DateList(int n) {
        super(n);
    }

    public DateList(Value value) {
        this.type = value;
    }

    public DateList(String string, Value value) throws ParseException {
        this(value);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (Value.DATE.equals(this.type)) {
                this.add(new Date(stringTokenizer.nextToken()));
                continue;
            }
            this.add(new DateTime(stringTokenizer.nextToken()));
        }
    }

    public DateList(DateList dateList, Value value) {
        if (!Value.DATE.equals(value) && !Value.DATE_TIME.equals(value)) {
            throw new IllegalArgumentException("Type must be either DATE or DATE-TIME");
        }
        this.type = value;
        if (Value.DATE.equals(value)) {
            Iterator iterator = dateList.iterator();
            while (iterator.hasNext()) {
                this.add(new Date((Date)iterator.next()));
            }
        } else {
            Iterator iterator = dateList.iterator();
            while (iterator.hasNext()) {
                this.add(new DateTime((Date)iterator.next()));
            }
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public final boolean add(Date date) {
        if (date instanceof DateTime) {
            ((DateTime)date).setTimeZone(this.getTimeZone());
        } else if (!Value.DATE.equals(this.getType())) {
            DateTime dateTime = new DateTime(date);
            dateTime.setTimeZone(this.getTimeZone());
            return this.add((Object)dateTime);
        }
        return this.add((Object)date);
    }

    public final boolean add(Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Argument not a " + Date.class.getName());
        }
        return super.add(object);
    }

    public final boolean remove(Date date) {
        return this.remove((Object)date);
    }

    public final Value getType() {
        return this.type;
    }

    public final boolean isUtc() {
        return TimeZones.isUtc(this.getTimeZone());
    }

    public final void setUtc(boolean bl) {
        if (!Value.DATE.equals(this.type)) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ((DateTime)iterator.next()).setUtc(bl);
            }
        }
        this.timeZone = null;
    }

    public final void setTimeZone(TimeZone timeZone) {
        if (!Value.DATE.equals(this.type)) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ((DateTime)iterator.next()).setTimeZone(timeZone);
            }
        }
        this.timeZone = timeZone;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }
}

