/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Language;
import net.fortuna.ical4j.model.parameter.Member;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Range;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;

public final class ParameterFactoryImpl
implements ParameterFactory {
    private static ParameterFactoryImpl instance = new ParameterFactoryImpl();
    private Map factories = new HashMap();

    private ParameterFactoryImpl() {
        this.factories.put("ALTREP", this.createAltRepFactory());
        this.factories.put("CN", this.createCnFactory());
        this.factories.put("CUTYPE", this.createCuTypeFactory());
        this.factories.put("DELEGATED-FROM", this.createDelegatedFromFactory());
        this.factories.put("DELEGATED-TO", this.createDelegatedToFactory());
        this.factories.put("DIR", this.createDirFactory());
        this.factories.put("ENCODING", this.createEncodingFactory());
        this.factories.put("FMTTYPE", this.createFmtTypeFactory());
        this.factories.put("FBTYPE", this.createFbTypeFactory());
        this.factories.put("LANGUAGE", this.createLanguageFactory());
        this.factories.put("MEMBER", this.createMemberFactory());
        this.factories.put("PARTSTAT", this.createPartStatFactory());
        this.factories.put("RANGE", this.createRangeFactory());
        this.factories.put("RELATED", this.createRelatedFactory());
        this.factories.put("RELTYPE", this.createRelTypeFactory());
        this.factories.put("ROLE", this.createRoleFactory());
        this.factories.put("RSVP", this.createRsvpFactory());
        this.factories.put("SENT-BY", this.createSentByFactory());
        this.factories.put("TZID", this.createTzIdFactory());
        this.factories.put("VALUE", this.createValueFactory());
    }

    private ParameterFactory createAltRepFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new AltRep(string2);
            }
        };
    }

    private ParameterFactory createCnFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new Cn(string2);
            }
        };
    }

    private ParameterFactory createCuTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                CuType cuType = new CuType(string2);
                if (CuType.INDIVIDUAL.equals(cuType)) {
                    return CuType.INDIVIDUAL;
                }
                if (CuType.GROUP.equals(cuType)) {
                    return CuType.GROUP;
                }
                if (CuType.RESOURCE.equals(cuType)) {
                    return CuType.RESOURCE;
                }
                if (CuType.ROOM.equals(cuType)) {
                    return CuType.ROOM;
                }
                if (CuType.UNKNOWN.equals(cuType)) {
                    return CuType.UNKNOWN;
                }
                return cuType;
            }
        };
    }

    private ParameterFactory createDelegatedFromFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new DelegatedFrom(string2);
            }
        };
    }

    private ParameterFactory createDelegatedToFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new DelegatedTo(string2);
            }
        };
    }

    private ParameterFactory createDirFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new Dir(string2);
            }
        };
    }

    private ParameterFactory createEncodingFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                Encoding encoding = new Encoding(string2);
                if (Encoding.EIGHT_BIT.equals(encoding)) {
                    return Encoding.EIGHT_BIT;
                }
                if (Encoding.BASE64.equals(encoding)) {
                    return Encoding.BASE64;
                }
                return encoding;
            }
        };
    }

    private ParameterFactory createFmtTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new FmtType(string2);
            }
        };
    }

    private ParameterFactory createFbTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                FbType fbType = new FbType(string2);
                if (FbType.FREE.equals(fbType)) {
                    return FbType.FREE;
                }
                if (FbType.BUSY.equals(fbType)) {
                    return FbType.BUSY;
                }
                if (FbType.BUSY_TENTATIVE.equals(fbType)) {
                    return FbType.BUSY_TENTATIVE;
                }
                if (FbType.BUSY_UNAVAILABLE.equals(fbType)) {
                    return FbType.BUSY_UNAVAILABLE;
                }
                return fbType;
            }
        };
    }

    private ParameterFactory createLanguageFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new Language(string2);
            }
        };
    }

    private ParameterFactory createMemberFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new Member(string2);
            }
        };
    }

    private ParameterFactory createPartStatFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                PartStat partStat = new PartStat(string2);
                if (PartStat.NEEDS_ACTION.equals(partStat)) {
                    return PartStat.NEEDS_ACTION;
                }
                if (PartStat.ACCEPTED.equals(partStat)) {
                    return PartStat.ACCEPTED;
                }
                if (PartStat.DECLINED.equals(partStat)) {
                    return PartStat.DECLINED;
                }
                if (PartStat.TENTATIVE.equals(partStat)) {
                    return PartStat.TENTATIVE;
                }
                if (PartStat.DELEGATED.equals(partStat)) {
                    return PartStat.DELEGATED;
                }
                if (PartStat.COMPLETED.equals(partStat)) {
                    return PartStat.COMPLETED;
                }
                if (PartStat.IN_PROCESS.equals(partStat)) {
                    return PartStat.IN_PROCESS;
                }
                return partStat;
            }
        };
    }

    private ParameterFactory createRangeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                Range range = new Range(string2);
                if (Range.THISANDFUTURE.equals(range)) {
                    return Range.THISANDFUTURE;
                }
                if (Range.THISANDPRIOR.equals(range)) {
                    return Range.THISANDPRIOR;
                }
                return range;
            }
        };
    }

    private ParameterFactory createRelatedFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                Related related = new Related(string2);
                if (Related.START.equals(related)) {
                    return Related.START;
                }
                if (Related.END.equals(related)) {
                    return Related.END;
                }
                return related;
            }
        };
    }

    private ParameterFactory createRelTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                RelType relType = new RelType(string2);
                if (RelType.PARENT.equals(relType)) {
                    return RelType.PARENT;
                }
                if (RelType.CHILD.equals(relType)) {
                    return RelType.CHILD;
                }
                if (RelType.SIBLING.equals(relType)) {
                    return RelType.SIBLING;
                }
                return relType;
            }
        };
    }

    private ParameterFactory createRoleFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                Role role = new Role(string2);
                if (Role.CHAIR.equals(role)) {
                    return Role.CHAIR;
                }
                if (Role.REQ_PARTICIPANT.equals(role)) {
                    return Role.REQ_PARTICIPANT;
                }
                if (Role.OPT_PARTICIPANT.equals(role)) {
                    return Role.OPT_PARTICIPANT;
                }
                if (Role.NON_PARTICIPANT.equals(role)) {
                    return Role.NON_PARTICIPANT;
                }
                return role;
            }
        };
    }

    private ParameterFactory createRsvpFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                Rsvp rsvp = new Rsvp(string2);
                if (Rsvp.TRUE.equals(rsvp)) {
                    return Rsvp.TRUE;
                }
                if (Rsvp.FALSE.equals(rsvp)) {
                    return Rsvp.FALSE;
                }
                return rsvp;
            }
        };
    }

    private ParameterFactory createSentByFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new SentBy(string2);
            }
        };
    }

    private ParameterFactory createTzIdFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                return new TzId(string2);
            }
        };
    }

    private ParameterFactory createValueFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String string, String string2) throws URISyntaxException {
                Value value = new Value(string2);
                if (Value.BINARY.equals(value)) {
                    return Value.BINARY;
                }
                if (Value.BOOLEAN.equals(value)) {
                    return Value.BOOLEAN;
                }
                if (Value.CAL_ADDRESS.equals(value)) {
                    return Value.CAL_ADDRESS;
                }
                if (Value.DATE.equals(value)) {
                    return Value.DATE;
                }
                if (Value.DATE_TIME.equals(value)) {
                    return Value.DATE_TIME;
                }
                if (Value.DURATION.equals(value)) {
                    return Value.DURATION;
                }
                if (Value.FLOAT.equals(value)) {
                    return Value.FLOAT;
                }
                if (Value.INTEGER.equals(value)) {
                    return Value.INTEGER;
                }
                if (Value.PERIOD.equals(value)) {
                    return Value.PERIOD;
                }
                if (Value.RECUR.equals(value)) {
                    return Value.RECUR;
                }
                if (Value.TEXT.equals(value)) {
                    return Value.TEXT;
                }
                if (Value.TIME.equals(value)) {
                    return Value.TIME;
                }
                if (Value.URI.equals(value)) {
                    return Value.URI;
                }
                if (Value.UTC_OFFSET.equals(value)) {
                    return Value.UTC_OFFSET;
                }
                return value;
            }
        };
    }

    public static ParameterFactoryImpl getInstance() {
        return instance;
    }

    public Parameter createParameter(String string, String string2) throws URISyntaxException {
        ParameterFactory parameterFactory = (ParameterFactory)this.factories.get(string);
        if (parameterFactory != null) {
            return parameterFactory.createParameter(string, string2);
        }
        if (this.isExperimentalName(string)) {
            return new XParameter(string, string2);
        }
        throw new IllegalArgumentException("Invalid parameter name: " + string);
    }

    private boolean isExperimentalName(String string) {
        return string.startsWith("X-") && string.length() > "X-".length();
    }
}

