/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactoryImpl;

public class ParameterList
implements Serializable {
    private static final long serialVersionUID = -1913059830016450169L;
    private List parameters;

    public ParameterList() {
        this(false);
    }

    public ParameterList(boolean bl) {
        this.parameters = bl ? Collections.unmodifiableList(new ArrayList()) : new ArrayList();
    }

    public ParameterList(ParameterList parameterList, boolean bl) throws URISyntaxException {
        this.parameters = new ArrayList();
        Iterator iterator = parameterList.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            this.parameters.add(ParameterFactoryImpl.getInstance().createParameter(parameter.getName(), parameter.getValue()));
        }
        if (bl) {
            this.parameters = Collections.unmodifiableList(this.parameters);
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(';');
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    public final Parameter getParameter(String string) {
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!string.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public final ParameterList getParameters(String string) {
        ParameterList parameterList = new ParameterList();
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.getName().equals(string)) continue;
            parameterList.add(parameter);
        }
        return parameterList;
    }

    public final boolean add(Parameter parameter) {
        Iterator iterator = this.getParameters(parameter.getName()).iterator();
        while (iterator.hasNext()) {
            this.remove((Parameter)iterator.next());
        }
        return this.parameters.add(parameter);
    }

    public final boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public final Iterator iterator() {
        return this.parameters.iterator();
    }

    public final boolean remove(Parameter parameter) {
        return this.parameters.remove(parameter);
    }

    public final int size() {
        return this.parameters.size();
    }

    public final boolean equals(Object object) {
        if (object instanceof ParameterList) {
            ParameterList parameterList = (ParameterList)object;
            Iterator iterator = parameterList.iterator();
            while (iterator.hasNext()) {
                if (this.parameters.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public final int hashCode() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }
}

