/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;

public class Period
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7321090422911676490L;
    private DateTime start;
    private DateTime end;
    private Dur duration;

    public Period(String string) throws ParseException {
        this.start = new DateTime(string.substring(0, string.indexOf(47)));
        try {
            this.end = new DateTime(string.substring(string.indexOf(47) + 1));
        }
        catch (ParseException parseException) {
            this.duration = new Dur(string);
        }
    }

    public Period(DateTime dateTime, DateTime dateTime2) {
        this.start = dateTime;
        this.end = dateTime2;
    }

    public Period(DateTime dateTime, Dur dur) {
        this.start = dateTime;
        this.duration = dur;
    }

    public final Dur getDuration() {
        if (this.end != null) {
            return new Dur(this.start, this.end);
        }
        return this.duration;
    }

    public final DateTime getEnd() {
        if (this.end == null) {
            return new DateTime(this.duration.getTime(this.start).getTime());
        }
        return this.end;
    }

    public final DateTime getStart() {
        return this.start;
    }

    public final boolean includes(Date date) {
        return !this.getStart().after(date) && !this.getEnd().before(date);
    }

    public final boolean before(Period period) {
        return this.getEnd().before(period.getStart());
    }

    public final boolean after(Period period) {
        return this.getStart().after(period.getEnd());
    }

    public final boolean intersects(Period period) {
        if (period.includes(this.getStart()) && !period.getEnd().equals(this.getStart())) {
            return true;
        }
        return this.includes(period.getStart()) && !this.getEnd().equals(period.getStart());
    }

    public final boolean adjacent(Period period) {
        if (this.getStart().equals(period.getEnd())) {
            return true;
        }
        return this.getEnd().equals(period.getStart());
    }

    public final boolean contains(Period period) {
        return this.includes(period.getStart()) && this.includes(period.getEnd());
    }

    public final Period add(Period period) {
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        if (period == null) {
            dateTime = this.getStart();
            dateTime2 = this.getEnd();
        } else {
            dateTime = this.getStart().before(period.getStart()) ? this.getStart() : period.getStart();
            dateTime2 = this.getEnd().after(period.getEnd()) ? this.getEnd() : period.getEnd();
        }
        return new Period(dateTime, dateTime2);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.start);
        stringBuffer.append('/');
        if (this.end != null) {
            stringBuffer.append(this.end);
        } else {
            stringBuffer.append(this.duration);
        }
        return stringBuffer.toString();
    }

    public final int compareTo(Object object) {
        return this.compareTo((Period)object);
    }

    public final int compareTo(Period period) {
        int n;
        if (period == null) {
            throw new ClassCastException("Cannot compare this object to null");
        }
        int n2 = this.getStart().compareTo(period.getStart());
        if (n2 != 0) {
            return n2;
        }
        if (this.end != null && (n = this.end.compareTo(period.getEnd())) != 0) {
            return n;
        }
        return this.getDuration().compareTo(period.getDuration());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Period)) {
            return false;
        }
        Period period = (Period)object;
        if (!this.getStart().equals(period.getStart())) {
            return false;
        }
        return this.getEnd().equals(period.getEnd());
    }

    public final int hashCode() {
        int n = this.getStart().hashCode();
        n = 29 * n + this.getEnd().hashCode();
        return n;
    }
}

