/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Dates;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Recur
implements Serializable {
    private static final long serialVersionUID = -7333226591784095142L;
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";
    public static final String SECONDLY = "SECONDLY";
    public static final String MINUTELY = "MINUTELY";
    public static final String HOURLY = "HOURLY";
    public static final String DAILY = "DAILY";
    public static final String WEEKLY = "WEEKLY";
    public static final String MONTHLY = "MONTHLY";
    public static final String YEARLY = "YEARLY";
    private static Log log = LogFactory.getLog((Class)Recur.class);
    private String frequency;
    private Date until;
    private int count = -1;
    private int interval = -1;
    private NumberList secondList;
    private NumberList minuteList;
    private NumberList hourList;
    private WeekDayList dayList;
    private NumberList monthDayList;
    private NumberList yearDayList;
    private NumberList weekNoList;
    private NumberList monthList;
    private NumberList setPosList;
    private String weekStartDay;
    private Map experimentalValues = new HashMap();

    public Recur(String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (FREQ.equals(string2)) {
                this.frequency = stringTokenizer.nextToken();
                continue;
            }
            if (UNTIL.equals(string2)) {
                String string3 = stringTokenizer.nextToken();
                try {
                    this.until = new DateTime(string3);
                    ((DateTime)this.until).setUtc(true);
                }
                catch (ParseException parseException) {
                    this.until = new Date(string3);
                }
                continue;
            }
            if (COUNT.equals(string2)) {
                this.count = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            if (INTERVAL.equals(string2)) {
                this.interval = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            if (BYSECOND.equals(string2)) {
                this.secondList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYMINUTE.equals(string2)) {
                this.minuteList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYHOUR.equals(string2)) {
                this.hourList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYDAY.equals(string2)) {
                this.dayList = new WeekDayList(stringTokenizer.nextToken());
                continue;
            }
            if (BYMONTHDAY.equals(string2)) {
                this.monthDayList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYYEARDAY.equals(string2)) {
                this.yearDayList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYWEEKNO.equals(string2)) {
                this.weekNoList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYMONTH.equals(string2)) {
                this.monthList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (BYSETPOS.equals(string2)) {
                this.setPosList = new NumberList(stringTokenizer.nextToken());
                continue;
            }
            if (WKST.equals(string2)) {
                this.weekStartDay = stringTokenizer.nextToken();
                continue;
            }
            this.experimentalValues.put(string2, stringTokenizer.nextToken());
        }
    }

    public Recur(String string, Date date) {
        this.frequency = string;
        this.until = date;
    }

    public Recur(String string, int n) {
        this.frequency = string;
        this.count = n;
    }

    public final WeekDayList getDayList() {
        if (this.dayList == null) {
            this.dayList = new WeekDayList();
        }
        return this.dayList;
    }

    public final NumberList getHourList() {
        if (this.hourList == null) {
            this.hourList = new NumberList();
        }
        return this.hourList;
    }

    public final NumberList getMinuteList() {
        if (this.minuteList == null) {
            this.minuteList = new NumberList();
        }
        return this.minuteList;
    }

    public final NumberList getMonthDayList() {
        if (this.monthDayList == null) {
            this.monthDayList = new NumberList();
        }
        return this.monthDayList;
    }

    public final NumberList getMonthList() {
        if (this.monthList == null) {
            this.monthList = new NumberList();
        }
        return this.monthList;
    }

    public final NumberList getSecondList() {
        if (this.secondList == null) {
            this.secondList = new NumberList();
        }
        return this.secondList;
    }

    public final NumberList getSetPosList() {
        if (this.setPosList == null) {
            this.setPosList = new NumberList();
        }
        return this.setPosList;
    }

    public final NumberList getWeekNoList() {
        if (this.weekNoList == null) {
            this.weekNoList = new NumberList();
        }
        return this.weekNoList;
    }

    public final NumberList getYearDayList() {
        if (this.yearDayList == null) {
            this.yearDayList = new NumberList();
        }
        return this.yearDayList;
    }

    public final int getCount() {
        return this.count;
    }

    public final Map getExperimentalValues() {
        return this.experimentalValues;
    }

    public final String getFrequency() {
        return this.frequency;
    }

    public final int getInterval() {
        return this.interval;
    }

    public final Date getUntil() {
        return this.until;
    }

    public final String getWeekStartDay() {
        return this.weekStartDay;
    }

    public final void setWeekStartDay(String string) {
        this.weekStartDay = string;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FREQ);
        stringBuffer.append('=');
        stringBuffer.append(this.frequency);
        if (this.weekStartDay != null) {
            stringBuffer.append(';');
            stringBuffer.append(WKST);
            stringBuffer.append('=');
            stringBuffer.append(this.weekStartDay);
        }
        if (this.interval >= 1) {
            stringBuffer.append(';');
            stringBuffer.append(INTERVAL);
            stringBuffer.append('=');
            stringBuffer.append(this.interval);
        }
        if (this.until != null) {
            stringBuffer.append(';');
            stringBuffer.append(UNTIL);
            stringBuffer.append('=');
            stringBuffer.append(this.until);
        }
        if (this.count >= 1) {
            stringBuffer.append(';');
            stringBuffer.append(COUNT);
            stringBuffer.append('=');
            stringBuffer.append(this.count);
        }
        if (!this.getMonthList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYMONTH);
            stringBuffer.append('=');
            stringBuffer.append(this.monthList);
        }
        if (!this.getWeekNoList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYWEEKNO);
            stringBuffer.append('=');
            stringBuffer.append(this.weekNoList);
        }
        if (!this.getYearDayList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYYEARDAY);
            stringBuffer.append('=');
            stringBuffer.append(this.yearDayList);
        }
        if (!this.getMonthDayList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYMONTHDAY);
            stringBuffer.append('=');
            stringBuffer.append(this.monthDayList);
        }
        if (!this.getDayList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYDAY);
            stringBuffer.append('=');
            stringBuffer.append(this.dayList);
        }
        if (!this.getHourList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYHOUR);
            stringBuffer.append('=');
            stringBuffer.append(this.hourList);
        }
        if (!this.getMinuteList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYMINUTE);
            stringBuffer.append('=');
            stringBuffer.append(this.minuteList);
        }
        if (!this.getSecondList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYSECOND);
            stringBuffer.append('=');
            stringBuffer.append(this.secondList);
        }
        if (!this.getSetPosList().isEmpty()) {
            stringBuffer.append(';');
            stringBuffer.append(BYSETPOS);
            stringBuffer.append('=');
            stringBuffer.append(this.setPosList);
        }
        return stringBuffer.toString();
    }

    public final DateList getDates(Date date, Date date2, Value value) {
        return this.getDates(date, date, date2, value);
    }

    public final DateList getDates(Date date, Date date2, Date date3, Value value) {
        DateList dateList = new DateList(value);
        Calendar calendar = Dates.getCalendarInstance(date);
        calendar.setTime(date);
        int n = 0;
        while (!(this.getUntil() != null && calendar.getTime().after(this.getUntil()) || date3 != null && calendar.getTime().after(date3) || this.getCount() >= 1 && dateList.size() + n >= this.getCount())) {
            DateList dateList2 = this.getCandidates(Dates.getInstance(calendar.getTime(), value), value);
            Iterator iterator = dateList2.iterator();
            while (iterator.hasNext()) {
                Date date4 = (Date)iterator.next();
                if (date4.before(date)) continue;
                if (date4.before(date2) || !date4.before(date3)) {
                    ++n;
                    continue;
                }
                if (this.getCount() >= 1 && dateList.size() + n >= this.getCount()) break;
                if (this.getUntil() != null && date4.after(this.getUntil())) continue;
                dateList.add(date4);
            }
            this.increment(calendar);
        }
        Collections.sort(dateList);
        return dateList;
    }

    private void increment(Calendar calendar) {
        int n;
        int n2 = n = this.getInterval() >= 1 ? this.getInterval() : 1;
        if (SECONDLY.equals(this.getFrequency())) {
            calendar.add(13, n);
        } else if (MINUTELY.equals(this.getFrequency())) {
            calendar.add(12, n);
        } else if (HOURLY.equals(this.getFrequency())) {
            calendar.add(11, n);
        } else if (DAILY.equals(this.getFrequency())) {
            calendar.add(6, n);
        } else if (WEEKLY.equals(this.getFrequency())) {
            calendar.add(3, n);
        } else if (MONTHLY.equals(this.getFrequency())) {
            calendar.add(2, n);
        } else if (YEARLY.equals(this.getFrequency())) {
            calendar.add(1, n);
        }
    }

    private DateList getCandidates(Date date, Value value) {
        DateList dateList = new DateList(value);
        dateList.add(date);
        dateList = this.getMonthVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYMONTH processing: " + dateList));
        }
        dateList = this.getWeekNoVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYWEEKNO processing: " + dateList));
        }
        dateList = this.getYearDayVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYYEARDAY processing: " + dateList));
        }
        dateList = this.getMonthDayVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYMONTHDAY processing: " + dateList));
        }
        dateList = this.getDayVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYDAY processing: " + dateList));
        }
        dateList = this.getHourVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYHOUR processing: " + dateList));
        }
        dateList = this.getMinuteVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYMINUTE processing: " + dateList));
        }
        dateList = this.getSecondVariants(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after BYSECOND processing: " + dateList));
        }
        dateList = this.applySetPosRules(dateList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dates after SETPOS processing: " + dateList));
        }
        return dateList;
    }

    private DateList applySetPosRules(DateList dateList) {
        if (this.getSetPosList().isEmpty()) {
            return dateList;
        }
        Collections.sort(dateList);
        DateList dateList2 = new DateList(dateList.getType());
        int n = dateList.size();
        Iterator iterator = this.getSetPosList().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            if (n3 > 0 && n3 <= n) {
                dateList2.add(dateList.get(n3 - 1));
                continue;
            }
            if (n3 >= 0 || n3 < -n) continue;
            dateList2.add(dateList.get(n + n3));
        }
        return dateList2;
    }

    private DateList getMonthVariants(DateList dateList) {
        if (this.getMonthList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getMonthList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(2, n - 1);
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    private DateList getWeekNoVariants(DateList dateList) {
        if (this.getWeekNoList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getWeekNoList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(3, Dates.getAbsWeekNo(calendar.getTime(), n));
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    private DateList getYearDayVariants(DateList dateList) {
        if (this.getYearDayList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getYearDayList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(6, Dates.getAbsYearDay(calendar.getTime(), n));
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    private DateList getMonthDayVariants(DateList dateList) {
        if (this.getMonthDayList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getMonthDayList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(5, Dates.getAbsMonthDay(calendar.getTime(), n));
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    private DateList getDayVariants(DateList dateList) {
        if (this.getDayList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Iterator iterator2 = this.getDayList().iterator();
            while (iterator2.hasNext()) {
                WeekDay weekDay = (WeekDay)iterator2.next();
                dateList2.addAll(this.getAbsWeekDays(date, dateList.getType(), weekDay));
            }
        }
        return dateList2;
    }

    private List getAbsWeekDays(Date date, Value value, WeekDay weekDay) {
        int n;
        Calendar calendar = Dates.getCalendarInstance(date);
        calendar.setTime(date);
        DateList dateList = new DateList(value);
        int n2 = WeekDay.getCalendarDay(weekDay);
        if (n2 == -1) {
            return dateList;
        }
        if (DAILY.equals(this.getFrequency())) {
            if (calendar.get(7) == n2) {
                dateList.add(Dates.getInstance(calendar.getTime(), value));
            }
        } else if (WEEKLY.equals(this.getFrequency()) || !this.getWeekNoList().isEmpty()) {
            while (calendar.get(7) != n2) {
                calendar.add(7, 1);
            }
            n = calendar.get(3);
            while (calendar.get(3) == n) {
                dateList.add(Dates.getInstance(calendar.getTime(), value));
                calendar.add(7, 7);
            }
        } else if (MONTHLY.equals(this.getFrequency()) || !this.getMonthList().isEmpty()) {
            n = calendar.get(2);
            calendar.set(5, 1);
            while (calendar.get(7) != n2) {
                calendar.add(5, 1);
            }
            while (calendar.get(2) == n) {
                dateList.add(Dates.getInstance(calendar.getTime(), value));
                calendar.add(5, 7);
            }
        } else if (YEARLY.equals(this.getFrequency())) {
            n = calendar.get(1);
            calendar.set(6, 1);
            while (calendar.get(7) != n2) {
                calendar.add(6, 1);
            }
            while (calendar.get(1) == n) {
                dateList.add(Dates.getInstance(calendar.getTime(), value));
                calendar.add(6, 7);
            }
        }
        DateList dateList2 = new DateList(dateList.getType());
        this.sublist(dateList, weekDay.getOffset(), dateList2);
        return dateList2;
    }

    private void sublist(List list, int n, List list2) {
        int n2 = list.size();
        if (n < 0 && n >= -n2) {
            list2.add(list.get(n2 + n));
        } else if (n > 0 && n <= n2) {
            list2.add(list.get(n - 1));
        } else {
            list2.addAll(list);
        }
    }

    private DateList getHourVariants(DateList dateList) {
        if (this.getHourList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getHourList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(11, n);
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    private DateList getMinuteVariants(DateList dateList) {
        if (this.getMinuteList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getMinuteList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(12, n);
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    private DateList getSecondVariants(DateList dateList) {
        if (this.getSecondList().isEmpty()) {
            return dateList;
        }
        DateList dateList2 = new DateList(dateList.getType());
        Iterator iterator = dateList.iterator();
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Calendar calendar = Dates.getCalendarInstance(date);
            calendar.setTime(date);
            Iterator iterator2 = this.getSecondList().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                calendar.set(13, n);
                dateList2.add(Dates.getInstance(calendar.getTime(), dateList2.getType()));
            }
        }
        return dateList2;
    }

    public final void setCount(int n) {
        this.count = n;
        this.until = null;
    }

    public final void setFrequency(String string) {
        this.frequency = string;
    }

    public final void setInterval(int n) {
        this.interval = n;
    }

    public final void setUntil(Date date) {
        this.until = date;
        this.count = -1;
    }
}

