/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Calendar;
import java.util.Date;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzOffsetTo;

public class TimeZone
extends java.util.TimeZone {
    private static final long serialVersionUID = -5620979316746547234L;
    private VTimeZone vTimeZone;

    public TimeZone(VTimeZone vTimeZone) {
        this.vTimeZone = vTimeZone;
        TzId tzId = (TzId)vTimeZone.getProperties().getProperty("TZID");
        this.setID(tzId.getValue());
    }

    public final int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(0, n);
        calendar.set(1, n2);
        calendar.set(2, n3);
        calendar.set(6, n4);
        calendar.set(7, n5);
        calendar.set(14, n6);
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(calendar.getTime()));
        if (observance != null) {
            TzOffsetTo tzOffsetTo = (TzOffsetTo)observance.getProperties().getProperty("TZOFFSETTO");
            return (int)tzOffsetTo.getOffset().getOffset();
        }
        return 0;
    }

    public final int getRawOffset() {
        TzOffsetTo tzOffsetTo;
        Component component = this.vTimeZone.getObservances().getComponent("STANDARD");
        if (component == null) {
            component = this.vTimeZone.getObservances().getComponent("DAYLIGHT");
        }
        if ((tzOffsetTo = (TzOffsetTo)component.getProperties().getProperty("TZOFFSETTO")) != null) {
            return (int)tzOffsetTo.getOffset().getOffset();
        }
        return 0;
    }

    public final boolean inDaylightTime(Date date) {
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(date));
        return observance != null && observance instanceof Daylight;
    }

    public final void setRawOffset(int n) {
        throw new UnsupportedOperationException("Updates to the VTIMEZONE object must be performed directly");
    }

    public final boolean useDaylightTime() {
        ComponentList componentList = this.vTimeZone.getObservances().getComponents("DAYLIGHT");
        return !componentList.isEmpty();
    }

    public final VTimeZone getVTimeZone() {
        return this.vTimeZone;
    }
}

