/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UtcOffset {
    private static final int HOUR_START_INDEX = 1;
    private static final int HOUR_END_INDEX = 3;
    private static final int MINUTE_START_INDEX = 3;
    private static final int MINUTE_END_INDEX = 5;
    private static final int SECOND_START_INDEX = 5;
    private static final int SECOND_END_INDEX = 7;
    private static final NumberFormat HOUR_FORMAT = new DecimalFormat("00");
    private static final NumberFormat MINUTE_FORMAT = new DecimalFormat("00");
    private static final NumberFormat SECOND_FORMAT = new DecimalFormat("00");
    private static Log log = LogFactory.getLog((Class)UtcOffset.class);
    private long offset;

    public UtcOffset(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing string [" + string + "]"));
        }
        boolean bl = string.startsWith("-");
        this.offset = 0L;
        this.offset += (long)Integer.parseInt(string.substring(1, 3)) * 3600000L;
        this.offset += (long)Integer.parseInt(string.substring(3, 5)) * 60000L;
        try {
            this.offset += (long)Integer.parseInt(string.substring(5, 7)) * 1000L;
        }
        catch (Exception exception) {
            log.debug((Object)"Seconds not specified", (Throwable)exception);
        }
        if (bl) {
            this.offset = -this.offset;
        }
    }

    public UtcOffset(long l) {
        this.offset = (long)Math.floor((double)l / 1000.0) * 1000L;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = Math.abs(this.offset);
        if (this.offset < 0L) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append('+');
        }
        stringBuffer.append(HOUR_FORMAT.format(l / 3600000L));
        stringBuffer.append(MINUTE_FORMAT.format((l %= 3600000L) / 60000L));
        if ((l %= 60000L) > 0L) {
            stringBuffer.append(SECOND_FORMAT.format(l / 1000L));
        }
        return stringBuffer.toString();
    }

    public final long getOffset() {
        return this.offset;
    }

    public final boolean equals(Object object) {
        if (object instanceof UtcOffset) {
            return this.getOffset() == ((UtcOffset)object).getOffset();
        }
        return super.equals(object);
    }

    public final int hashCode() {
        return (int)this.getOffset();
    }
}

