/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.util.PropertyValidator;

public abstract class Observance
extends Component
implements Comparable {
    public static final String STANDARD = "STANDARD";
    public static final String DAYLIGHT = "DAYLIGHT";
    private Map onsets = new HashMap();

    protected Observance(String string) {
        super(string);
    }

    protected Observance(String string, PropertyList propertyList) {
        super(string, propertyList);
    }

    public final void validate(boolean bl) throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("TZOFFSETTO", this.getProperties());
        PropertyValidator.getInstance().assertOne("TZOFFSETFROM", this.getProperties());
        if (bl) {
            this.validateProperties();
        }
    }

    public final Date getLatestOnset(Date date) {
        Serializable serializable = ((DtStart)this.getProperties().getProperty("DTSTART")).getDate();
        if (date.before((java.util.Date)serializable)) {
            return null;
        }
        if (this.onsets.get(date) == null) {
            Serializable serializable2;
            Iterator iterator;
            Content content;
            PropertyList propertyList = this.getProperties().getProperties("RDATE");
            Object object = propertyList.iterator();
            while (object.hasNext()) {
                content = (RDate)object.next();
                iterator = content.getDates().iterator();
                while (iterator.hasNext()) {
                    serializable2 = (Date)iterator.next();
                    if (((java.util.Date)serializable2).after(date) || !((java.util.Date)serializable2).after((java.util.Date)serializable)) continue;
                    serializable = serializable2;
                }
            }
            object = this.getProperties().getProperties("RRULE");
            content = date instanceof DateTime ? Value.DATE_TIME : Value.DATE;
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                serializable2 = (RRule)iterator.next();
                Iterator iterator2 = ((RRule)serializable2).getRecur().getDates((Date)serializable, date, (Value)content).iterator();
                while (iterator2.hasNext()) {
                    Date date2 = (Date)iterator2.next();
                    if (date2.after(date) || !date2.after((java.util.Date)serializable)) continue;
                    serializable = date2;
                }
            }
            this.onsets.put(date, serializable);
        }
        return (Date)this.onsets.get(date);
    }

    public final int compareTo(Object object) {
        return this.compareTo((Observance)object);
    }

    public final int compareTo(Observance observance) {
        DtStart dtStart = (DtStart)this.getProperties().getProperty("DTSTART");
        DtStart dtStart2 = (DtStart)observance.getProperties().getProperty("DTSTART");
        return dtStart.getDate().compareTo(dtStart2.getDate());
    }
}

