/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.util.PropertyValidator;

public class VAlarm
extends Component {
    private static final long serialVersionUID = -8193965477414653802L;

    public VAlarm() {
        super("VALARM");
    }

    public VAlarm(PropertyList propertyList) {
        super("VALARM", propertyList);
    }

    public VAlarm(DateTime dateTime) {
        this();
        this.getProperties().add(new Trigger(dateTime));
    }

    public VAlarm(Dur dur) {
        this();
        this.getProperties().add(new Trigger(dur));
    }

    public final void validate(boolean bl) throws ValidationException {
        Property property = this.getProperties().getProperty("ACTION");
        if (property == null) {
            throw new ValidationException("Property [ACTION] must be specified once");
        }
        if (this.getProperties().getProperty("TRIGGER") == null) {
            throw new ValidationException("Property [TRIGGER] must be specified once");
        }
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("REPEAT", this.getProperties());
        if (this.getProperties().getProperty("DURATION") == null && this.getProperties().getProperty("REPEAT") != null || this.getProperties().getProperty("REPEAT") == null && this.getProperties().getProperty("DURATION") != null) {
            throw new ValidationException("Properties [DURATION,REPEAT] must both be specified or not at all");
        }
        if (Action.AUDIO.equals(property.getValue())) {
            this.validateAudio();
        } else if (Action.DISPLAY.equals(property.getValue())) {
            this.validateDisplay();
        } else if (Action.EMAIL.equals(property.getValue())) {
            this.validateEmail();
        } else if (Action.PROCEDURE.equals(property.getValue())) {
            this.validateProcedure();
        }
        if (bl) {
            this.validateProperties();
        }
    }

    private void validateAudio() throws ValidationException {
        PropertyValidator.getInstance().assertOneOrLess("ATTACH", this.getProperties());
    }

    private void validateDisplay() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DESCRIPTION", this.getProperties());
    }

    private void validateEmail() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOne("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", this.getProperties());
    }

    private void validateProcedure() throws ValidationException {
        PropertyValidator.getInstance().assertOne("ATTACH", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
    }
}

