/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.util.Dates;
import net.fortuna.ical4j.util.PropertyValidator;

public class VEvent
extends Component {
    private static final long serialVersionUID = 2547948989200697335L;
    private ComponentList alarms;

    public VEvent() {
        super("VEVENT");
        this.alarms = new ComponentList();
    }

    public VEvent(PropertyList propertyList) {
        super("VEVENT", propertyList);
        this.alarms = new ComponentList();
    }

    public VEvent(PropertyList propertyList, ComponentList componentList) {
        super("VEVENT", propertyList);
        this.alarms = componentList;
    }

    public VEvent(Date date, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new Summary(string));
    }

    public VEvent(Date date, Date date2, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new DtEnd(date2));
        this.getProperties().add(new Summary(string));
    }

    public VEvent(Date date, Dur dur, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new Duration(dur));
        this.getProperties().add(new Summary(string));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        return "BEGIN:" + this.getName() + "\r\n" + this.getProperties() + this.getAlarms() + "END" + ":" + this.getName() + "\r\n";
    }

    public final void validate(boolean bl) throws ValidationException {
        Serializable serializable;
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            serializable = (Component)iterator.next();
            if (serializable instanceof VAlarm) continue;
            throw new ValidationException("Component [" + ((Component)serializable).getName() + "] may not occur in VEVENT");
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        serializable = (Status)this.getProperties().getProperty("STATUS");
        if (!(serializable == null || Status.VEVENT_TENTATIVE.equals(serializable) || Status.VEVENT_CONFIRMED.equals(serializable) || Status.VEVENT_CANCELLED.equals(serializable))) {
            throw new ValidationException("Status property [" + ((Property)serializable).toString() + "] is not applicable for VEVENT");
        }
        if (this.getProperties().getProperty("DTEND") != null) {
            Parameter parameter;
            if (this.getProperties().getProperty("DURATION") != null) {
                throw new ValidationException("Properties [DTEND,DURATION] may not occur in the same VEVENT");
            }
            DtStart dtStart = (DtStart)this.getProperties().getProperty("DTSTART");
            DtEnd dtEnd = (DtEnd)this.getProperties().getProperty("DTEND");
            if (dtStart != null && (parameter = dtStart.getParameters().getParameter("VALUE")) != null && !parameter.equals(dtEnd.getParameters().getParameter("VALUE"))) {
                throw new ValidationException("Property [DTEND] must have the same [VALUE] as [DTSTART]");
            }
        }
        if (bl) {
            this.validateProperties();
        }
    }

    public final PeriodList getConsumedTime(Date date, Date date2) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Object object2;
        PeriodList periodList = new PeriodList();
        if (Transp.TRANSPARENT.equals(this.getProperties().getProperty("TRANSP"))) {
            return periodList;
        }
        DtStart dtStart = (DtStart)this.getProperties().getProperty("DTSTART");
        DtEnd dtEnd = (DtEnd)this.getProperties().getProperty("DTEND");
        Duration duration = (Duration)this.getProperties().getProperty("DURATION");
        if (dtStart == null) {
            return periodList;
        }
        Dur dur = duration == null ? new Dur(dtStart.getDate(), dtEnd.getDate()) : duration.getDuration();
        if (Value.DATE.equals(dtStart.getParameters().getParameter("VALUE"))) {
            return periodList;
        }
        PropertyList propertyList = this.getProperties().getProperties("RDATE");
        Object object3 = propertyList.iterator();
        while (object3.hasNext()) {
            object2 = (RDate)object3.next();
            if (!Value.PERIOD.equals(((Property)object2).getParameters().getParameter("VALUE"))) continue;
            object = ((RDate)object2).getPeriods().iterator();
            while (object.hasNext()) {
                serializable2 = (Period)object.next();
                if (!((Period)serializable2).getStart().before(date2) || !((Period)serializable2).getEnd().after(date)) continue;
                periodList.add((Period)serializable2);
            }
        }
        object3 = this.getProperties().getProperties("RRULE");
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            object = (RRule)object2.next();
            serializable2 = ((RRule)object).getRecur().getDates(dtStart.getDate(), date, date2, (Value)dtStart.getParameters().getParameter("VALUE"));
            for (int i = 0; i < ((ArrayList)serializable2).size(); ++i) {
                serializable = (Date)((ArrayList)serializable2).get(i);
                periodList.add(new Period(new DateTime((java.util.Date)serializable), dur));
            }
        }
        object2 = this.getProperties().getProperties("EXDATE");
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            serializable2 = (ExDate)object.next();
            Iterator iterator = periodList.iterator();
            while (iterator.hasNext()) {
                serializable = (Period)iterator.next();
                if (!((DateListProperty)serializable2).getDates().contains(((Period)serializable).getStart()) && !((DateListProperty)serializable2).getDates().contains(new Date(((Period)serializable).getStart()))) continue;
                periodList.remove((Period)serializable);
            }
        }
        object = this.getProperties().getProperties("EXRULE");
        serializable2 = new PeriodList();
        Object object4 = ((ArrayList)object).iterator();
        while (object4.hasNext()) {
            serializable = (ExRule)object4.next();
            DateList dateList = ((ExRule)serializable).getRecur().getDates(dtStart.getDate(), date, date2, (Value)dtStart.getParameters().getParameter("VALUE"));
            Iterator iterator = dateList.iterator();
            while (iterator.hasNext()) {
                Date date3 = (Date)iterator.next();
                ((PeriodList)serializable2).add(new Period(new DateTime(date3), dur));
            }
        }
        if (!((TreeSet)serializable2).isEmpty()) {
            periodList = periodList.subtract((PeriodList)serializable2);
        }
        if (!periodList.isEmpty()) {
            return periodList.normalise();
        }
        if (dtStart.getDate().before(date2)) {
            if (dtEnd != null && dtEnd.getDate().after(date)) {
                periodList.add(new Period(new DateTime(dtStart.getDate()), new DateTime(dtEnd.getDate())));
            } else if (duration != null && ((Period)(object4 = new Period(new DateTime(dtStart.getDate()), duration.getDuration()))).getEnd().after(date)) {
                periodList.add((Period)object4);
            }
        }
        return periodList;
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperties().getProperty("DTSTART");
    }

    public final DtEnd getEndDate() {
        DtEnd dtEnd = (DtEnd)this.getProperties().getProperty("DTEND");
        if (dtEnd == null) {
            DtStart dtStart = this.getStartDate();
            Duration duration = (Duration)this.getProperties().getProperty("DURATION");
            dtEnd = new DtEnd(Dates.getInstance(duration.getDuration().getTime(dtStart.getDate()), (Value)dtStart.getParameters().getParameter("VALUE")));
        }
        return dtEnd;
    }
}

