/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VFreeBusy
extends Component {
    private static final long serialVersionUID = 1046534053331139832L;
    private static Log log = LogFactory.getLog((Class)VFreeBusy.class);

    public VFreeBusy() {
        super("VFREEBUSY");
    }

    public VFreeBusy(PropertyList propertyList) {
        super("VFREEBUSY", propertyList);
    }

    public VFreeBusy(DateTime dateTime, DateTime dateTime2) {
        this();
        this.getProperties().add(new DtStart(dateTime, true));
        this.getProperties().add(new DtEnd(dateTime2, true));
        this.getProperties().add(new DtStamp(new DateTime()));
    }

    public VFreeBusy(DateTime dateTime, DateTime dateTime2, Dur dur) {
        this();
        this.getProperties().add(new DtStart(dateTime, true));
        this.getProperties().add(new DtEnd(dateTime2, true));
        this.getProperties().add(new Duration(dur));
        this.getProperties().add(new DtStamp(new DateTime()));
    }

    public VFreeBusy(VFreeBusy vFreeBusy, ComponentList componentList) {
        this();
        DtStart dtStart = (DtStart)vFreeBusy.getProperties().getProperty("DTSTART");
        DtEnd dtEnd = (DtEnd)vFreeBusy.getProperties().getProperty("DTEND");
        Duration duration = (Duration)vFreeBusy.getProperties().getProperty("DURATION");
        this.getProperties().add(new DtStart(dtStart.getDate(), true));
        this.getProperties().add(new DtEnd(dtEnd.getDate(), true));
        this.getProperties().add(new DtStamp(new DateTime()));
        if (duration != null) {
            this.getProperties().add(new Duration(duration.getDuration()));
            DateTime dateTime = new DateTime(dtStart.getDate());
            DateTime dateTime2 = new DateTime(dtEnd.getDate());
            FreeBusy freeBusy = this.createFreeTime(dateTime, dateTime2, duration.getDuration(), componentList);
            if (freeBusy != null && !freeBusy.getPeriods().isEmpty()) {
                this.getProperties().add(freeBusy);
            }
        } else {
            DateTime dateTime;
            DateTime dateTime3 = new DateTime(dtStart.getDate());
            FreeBusy freeBusy = this.createBusyTime(dateTime3, dateTime = new DateTime(dtEnd.getDate()), componentList);
            if (freeBusy != null && !freeBusy.getPeriods().isEmpty()) {
                this.getProperties().add(freeBusy);
            }
        }
    }

    private FreeBusy createBusyTime(DateTime dateTime, DateTime dateTime2, ComponentList componentList) {
        PeriodList periodList = this.getConsumedTime(componentList, dateTime, dateTime2);
        Iterator iterator = periodList.iterator();
        while (iterator.hasNext()) {
            Period period = (Period)iterator.next();
            if (!period.getStart().after(dateTime2) && !period.getEnd().before(dateTime)) continue;
            periodList.remove(period);
        }
        return new FreeBusy(periodList);
    }

    private FreeBusy createFreeTime(DateTime dateTime, DateTime dateTime2, Dur dur, ComponentList componentList) {
        FreeBusy freeBusy = new FreeBusy();
        freeBusy.getParameters().add(FbType.FREE);
        PeriodList periodList = this.getConsumedTime(componentList, dateTime, dateTime2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Busy periods: " + periodList));
        }
        DateTime dateTime3 = null;
        if (periodList.isEmpty()) {
            dateTime3 = new DateTime(dateTime);
        }
        Object object = periodList.iterator();
        while (object.hasNext()) {
            Duration duration;
            Period period = (Period)object.next();
            if (period.getStart().after(dateTime2) || period.getEnd().before(dateTime)) continue;
            if (dateTime3 == null && period.getStart().after(dateTime)) {
                dateTime3 = new DateTime(dateTime);
            }
            if (dateTime3 != null && (duration = new Duration(dateTime3, period.getStart())).getDuration().compareTo(dur) >= 0) {
                freeBusy.getPeriods().add(new Period(dateTime3, duration.getDuration()));
            }
            dateTime3 = period.getEnd();
        }
        if (dateTime3 != null && ((Duration)(object = new Duration(dateTime3, dateTime2))).getDuration().compareTo(dur) >= 0) {
            freeBusy.getPeriods().add(new Period(dateTime3, ((Duration)object).getDuration()));
        }
        return freeBusy;
    }

    private PeriodList getConsumedTime(ComponentList componentList, DateTime dateTime, DateTime dateTime2) {
        PeriodList periodList = new PeriodList();
        Iterator iterator = componentList.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!(component instanceof VEvent)) continue;
            periodList.addAll(((VEvent)component).getConsumedTime(dateTime, dateTime2));
        }
        return periodList.normalise();
    }

    public final void validate(boolean bl) throws ValidationException {
        PropertyValidator propertyValidator = PropertyValidator.getInstance();
        propertyValidator.assertOneOrLess("CONTACT", this.getProperties());
        propertyValidator.assertOneOrLess("DTSTART", this.getProperties());
        propertyValidator.assertOneOrLess("DTEND", this.getProperties());
        propertyValidator.assertOneOrLess("DURATION", this.getProperties());
        propertyValidator.assertOneOrLess("DTSTAMP", this.getProperties());
        propertyValidator.assertOneOrLess("ORGANIZER", this.getProperties());
        propertyValidator.assertOneOrLess("UID", this.getProperties());
        propertyValidator.assertOneOrLess("URL", this.getProperties());
        propertyValidator.assertNone("RRULE", this.getProperties());
        propertyValidator.assertNone("EXRULE", this.getProperties());
        propertyValidator.assertNone("RDATE", this.getProperties());
        propertyValidator.assertNone("EXDATE", this.getProperties());
        DtStart dtStart = (DtStart)this.getProperties().getProperty("DTSTART");
        DtEnd dtEnd = (DtEnd)this.getProperties().getProperty("DTEND");
        if (dtStart != null && dtEnd != null && !dtStart.getDate().before(dtEnd.getDate())) {
            throw new ValidationException("Property [DTEND] must be later in time than [DTSTART]");
        }
        if (bl) {
            this.validateProperties();
        }
    }
}

