/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.Serializable;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.util.PropertyValidator;

public class VToDo
extends Component {
    private static final long serialVersionUID = -269658210065896668L;
    private ComponentList alarms = new ComponentList();

    public VToDo() {
        super("VTODO");
    }

    public VToDo(PropertyList propertyList) {
        super("VTODO", propertyList);
    }

    public VToDo(Date date, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new Summary(string));
    }

    public VToDo(Date date, Date date2, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new Due(date2));
        this.getProperties().add(new Summary(string));
    }

    public VToDo(Date date, Dur dur, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new Duration(dur));
        this.getProperties().add(new Summary(string));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN");
        stringBuffer.append(':');
        stringBuffer.append(this.getName());
        stringBuffer.append("\r\n");
        stringBuffer.append(this.getProperties());
        stringBuffer.append(this.getAlarms());
        stringBuffer.append("END");
        stringBuffer.append(':');
        stringBuffer.append(this.getName());
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public final void validate(boolean bl) throws ValidationException {
        Serializable serializable;
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            serializable = (Component)iterator.next();
            if (serializable instanceof VAlarm) continue;
            throw new ValidationException("Component [" + ((Component)serializable).getName() + "] may not occur in VTODO");
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMPLETED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        serializable = (Status)this.getProperties().getProperty("STATUS");
        if (!(serializable == null || Status.VTODO_NEEDS_ACTION.equals(serializable) || Status.VTODO_COMPLETED.equals(serializable) || Status.VTODO_IN_PROCESS.equals(serializable) || Status.VTODO_CANCELLED.equals(serializable))) {
            throw new ValidationException("Status property [" + ((Property)serializable).toString() + "] may not occur in VTODO");
        }
        if (this.getProperties().getProperty("DUE") != null && this.getProperties().getProperty("DURATION") != null) {
            throw new ValidationException("Properties [DUE,DURATION] may not occur in the same VTODO");
        }
        if (bl) {
            this.validateProperties();
        }
    }
}

