/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Base64;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class Attach
extends Property {
    private static final long serialVersionUID = 4439949507756383452L;
    private URI uri;
    private byte[] binary;

    public Attach() {
        super("ATTACH");
    }

    public Attach(ParameterList parameterList, String string) throws IOException, URISyntaxException {
        super("ATTACH", parameterList);
        this.setValue(string);
    }

    public void setValue(String string) throws IOException, URISyntaxException {
        if (Encoding.BASE64.equals(this.getParameters().getParameter("ENCODING")) && Value.BINARY.equals(this.getParameters().getParameter("VALUE"))) {
            this.binary = Base64.decode(string);
        } else {
            this.uri = new URI(Uris.encode(string));
        }
    }

    public Attach(byte[] byArray) {
        super("ATTACH");
        this.getParameters().add(Encoding.BASE64);
        this.getParameters().add(Value.BINARY);
        this.binary = byArray;
    }

    public Attach(ParameterList parameterList, byte[] byArray) {
        super("ATTACH", parameterList);
        this.binary = byArray;
    }

    public Attach(URI uRI) {
        super("ATTACH");
        this.uri = uRI;
    }

    public Attach(ParameterList parameterList, URI uRI) {
        super("ATTACH", parameterList);
        this.uri = uRI;
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("FMTTYPE", this.getParameters());
    }

    public final byte[] getBinary() {
        return this.binary;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final String getValue() {
        if (this.getUri() != null) {
            return Uris.decode(Strings.valueOf(this.getUri()));
        }
        if (this.getBinary() != null) {
            return Base64.encodeBytes(this.getBinary(), 8);
        }
        return null;
    }

    public final void setBinary(byte[] byArray) {
        this.binary = byArray;
        this.uri = null;
    }

    public final void setUri(URI uRI) {
        this.uri = uRI;
        this.binary = null;
    }
}

