/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class Attendee
extends Property {
    private static final long serialVersionUID = 8430929418723298803L;
    private URI calAddress;

    public Attendee() {
        super("ATTENDEE");
    }

    public Attendee(String string) throws URISyntaxException {
        super("ATTENDEE");
        this.setValue(string);
    }

    public Attendee(ParameterList parameterList, String string) throws URISyntaxException {
        super("ATTENDEE", parameterList);
        this.setValue(string);
    }

    public Attendee(URI uRI) {
        super("ATTENDEE");
        this.calAddress = uRI;
    }

    public Attendee(ParameterList parameterList, URI uRI) {
        super("ATTENDEE", parameterList);
        this.calAddress = uRI;
    }

    public void setValue(String string) throws URISyntaxException {
        this.calAddress = new URI(Uris.encode(string));
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("CUTYPE", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("MEMBER", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("ROLE", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("PARTSTAT", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("RSVP", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DELEGATED-TO", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DELEGATED-FROM", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("SENT-BY", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("CN", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DIR", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("LANGUAGE", this.getParameters());
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI uRI) {
        this.calAddress = uRI;
    }
}

