/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Strings;

public abstract class DateListProperty
extends Property {
    private DateList dates;

    public DateListProperty(String string) {
        super(string);
        this.dates = new DateList(Value.DATE_TIME);
    }

    public DateListProperty(String string, ParameterList parameterList) {
        super(string, parameterList);
    }

    public DateListProperty(String string, DateList dateList) {
        super(string);
        this.dates = dateList;
    }

    public DateListProperty(String string, ParameterList parameterList, DateList dateList) {
        super(string, parameterList);
        this.dates = dateList;
    }

    public final DateList getDates() {
        return this.dates;
    }

    public void setValue(String string) throws ParseException {
        this.dates = new DateList(string, (Value)this.getParameters().getParameter("VALUE"));
    }

    public String getValue() {
        return Strings.valueOf(this.dates);
    }

    public final void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            if (!Value.DATE_TIME.equals(this.getDates().getType())) {
                throw new UnsupportedOperationException("TimeZone is not applicable to current value");
            }
            this.dates.setTimeZone(timeZone);
            this.getParameters().remove(this.getParameters().getParameter("TZID"));
            TzId tzId = new TzId(timeZone.getID());
            this.getParameters().add(tzId);
        } else {
            this.setUtc(false);
        }
    }

    public final void setUtc(boolean bl) {
        if (!Value.DATE_TIME.equals(this.dates.getType())) {
            throw new UnsupportedOperationException("TimeZone is not applicable to current value");
        }
        this.dates.setUtc(bl);
        this.getParameters().remove(this.getParameters().getParameter("TZID"));
    }
}

