/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.ParameterValidator;

public class DtEnd
extends DateProperty {
    private static final long serialVersionUID = 8107416684717228297L;

    public DtEnd() {
        super("DTEND");
    }

    public DtEnd(ParameterList parameterList, String string) throws ParseException {
        super("DTEND", parameterList);
        this.setValue(string);
    }

    public DtEnd(Date date) {
        super("DTEND");
        this.setDate(date);
    }

    public DtEnd(Date date, boolean bl) {
        super("DTEND");
        this.setDate(date);
        this.setUtc(bl);
    }

    public DtEnd(ParameterList parameterList, Date date) {
        super("DTEND", parameterList);
        this.setDate(date);
    }

    public final void validate() throws ValidationException {
        super.validate();
        ParameterValidator.getInstance().assertOneOrLess("VALUE", this.getParameters());
        Parameter parameter = this.getParameters().getParameter("VALUE");
        if (parameter == null && !(this.getDate() instanceof DateTime)) {
            throw new ValidationException("VALUE parameter is invalid for time instance");
        }
        if (this.getDate() instanceof DateTime) {
            DateTime dateTime = (DateTime)this.getDate();
            if (dateTime.isUtc()) {
                ParameterValidator.getInstance().assertNone("TZID", this.getParameters());
            } else {
                ParameterValidator.getInstance().assertOneOrLess("TZID", this.getParameters());
            }
        }
    }
}

