/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class Organizer
extends Property {
    private static final long serialVersionUID = -5216965653165090725L;
    private URI calAddress;

    public Organizer() {
        super("ORGANIZER");
    }

    public Organizer(ParameterList parameterList, String string) throws URISyntaxException {
        super("ORGANIZER", parameterList);
        this.setValue(string);
    }

    public Organizer(URI uRI) {
        super("ORGANIZER");
        this.calAddress = uRI;
    }

    public Organizer(ParameterList parameterList, URI uRI) {
        super("ORGANIZER", parameterList);
        this.calAddress = uRI;
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("CN", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DIR", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("SENT-BY", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("LANGUAGE", this.getParameters());
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    public final void setValue(String string) throws URISyntaxException {
        this.calAddress = new URI(Uris.encode(string));
    }

    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI uRI) {
        this.calAddress = uRI;
    }
}

